/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtmp;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.library.base.FromFileBase;
import com.pedro.library.rtmp.RtmpFromFile;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtmp.rtmp.RtmpClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0011\b\u0007\u0018\u00002\u00020\u0001B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB)\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000eB!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0016H\u0016J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020\u0018H\u0014J$\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010*2\b\u0010,\u001a\u0004\u0018\u00010*H\u0014J\u0018\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0014J\u0018\u00101\u001a\u00020\u00182\u0006\u00102\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0014R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/pedro/library/rtmp/RtmpFromFile;", "Lcom/pedro/library/base/FromFileBase;", "openGlView", "Lcom/pedro/library/view/OpenGlView;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "videoDecoderInterface", "Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;", "audioDecoderInterface", "Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;", "<init>", "(Lcom/pedro/library/view/OpenGlView;Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "(Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "streamClientListener", "com/pedro/library/rtmp/RtmpFromFile$streamClientListener$1", "Lcom/pedro/library/rtmp/RtmpFromFile$streamClientListener$1;", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "streamClient", "Lcom/pedro/library/util/streamclient/RtmpStreamClient;", "init", "", "setVideoCodecImp", "codec", "Lcom/pedro/common/VideoCodec;", "setAudioCodecImp", "Lcom/pedro/common/AudioCodec;", "getStreamClient", "prepareAudioRtp", "isStereo", "", "sampleRate", "", "startStreamRtp", "url", "", "stopStreamRtp", "onSpsPpsVpsRtp", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "getH264DataRtp", "h264Buffer", "info", "Landroid/media/MediaCodec$BufferInfo;", "getAacDataRtp", "aacBuffer", "library_release"})
@RequiresApi(api=18)
public final class RtmpFromFile
extends FromFileBase {
    @NotNull
    private final streamClientListener.1 streamClientListener;
    private RtmpClient rtmpClient;
    private RtmpStreamClient streamClient;

    public RtmpFromFile(@NotNull OpenGlView openGlView, @NotNull ConnectChecker connectChecker, @NotNull VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)openGlView, (String)"openGlView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoDecoderInterface, (String)"videoDecoderInterface");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(openGlView, videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ RtmpFromFile this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyFrame();
            }
        };
        this.init(connectChecker);
    }

    public RtmpFromFile(@NotNull Context context, @NotNull ConnectChecker connectChecker, @NotNull VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoDecoderInterface, (String)"videoDecoderInterface");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(context, videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.init(connectChecker);
    }

    public RtmpFromFile(@NotNull ConnectChecker connectChecker, @NotNull VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoDecoderInterface, (String)"videoDecoderInterface");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.init(connectChecker);
    }

    private final void init(ConnectChecker connectChecker) {
        this.rtmpClient = new RtmpClient(connectChecker);
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        this.streamClient = new RtmpStreamClient(rtmpClient, this.streamClientListener);
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioCodec(codec);
    }

    @Override
    @NotNull
    public RtmpStreamClient getStreamClient() {
        RtmpStreamClient rtmpStreamClient = this.streamClient;
        if (rtmpStreamClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streamClient");
            rtmpStreamClient = null;
        }
        return rtmpStreamClient;
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(@NotNull String url) {
        RtmpClient rtmpClient;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            RtmpClient rtmpClient2 = this.rtmpClient;
            if (rtmpClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient2 = null;
            }
            rtmpClient2.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            RtmpClient rtmpClient3 = this.rtmpClient;
            if (rtmpClient3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient3 = null;
            }
            rtmpClient3.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        if ((rtmpClient = this.rtmpClient) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setFps(this.videoEncoder.getFps());
        RtmpClient rtmpClient4 = this.rtmpClient;
        if (rtmpClient4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient4 = null;
        }
        rtmpClient4.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.disconnect();
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.sendVideo(h264Buffer, info);
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.sendAudio(aacBuffer, info);
    }
}

