/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.sources.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.video.Camera1ApiManager;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.facedetector.FaceDetectorCallback;
import com.pedro.library.util.sources.video.VideoSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J(\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0014J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\bJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010 \u001a\u00020\fJ\u0006\u0010!\u001a\u00020\fJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#J\u0006\u0010$\u001a\u00020\nJ\u0006\u0010%\u001a\u00020\nJ\u0006\u0010&\u001a\u00020\nJ\b\u0010'\u001a\u00020\nH\u0016J\u0006\u0010(\u001a\u00020\nJ(\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0010\u0010*\u001a\f\u0012\b\u0012\u00060+R\u00020,0\u001e2\u0006\u0010-\u001a\u00020\nH\u0002J\u000e\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\fJ\b\u00100\u001a\u00020\u0012H\u0016J\u000e\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\fJ\u000e\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u000205J\u000e\u00103\u001a\u00020\u00122\u0006\u00102\u001a\u00020\fJ\u0010\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u0012H\u0016J\u0006\u0010:\u001a\u00020\u0012J\u0016\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020=2\u0006\u00104\u001a\u000205R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/pedro/library/util/sources/video/Camera1Source;", "Lcom/pedro/library/util/sources/video/VideoSource;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "camera", "Lcom/pedro/encoder/input/video/Camera1ApiManager;", "facing", "Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "checkResolutionSupported", "", "width", "", "height", "create", "fps", "rotation", "disableAutoFocus", "", "disableFaceDetection", "disableLantern", "disableVideoStabilization", "enableAutoFocus", "enableFaceDetection", "callback", "Lcom/pedro/encoder/input/video/facedetector/FaceDetectorCallback;", "enableLantern", "enableVideoStabilization", "getCameraFacing", "getCameraResolutions", "", "Landroid/util/Size;", "getExposure", "getZoom", "getZoomRange", "Landroid/util/Range;", "isAutoFocusEnabled", "isFaceDetectionEnabled", "isLanternEnabled", "isRunning", "isVideoStabilizationEnabled", "mapCamera1Resolutions", "resolutions", "Landroid/hardware/Camera$Size;", "Landroid/hardware/Camera;", "shouldRotate", "openCameraId", "id", "release", "setExposure", "level", "setZoom", "event", "Landroid/view/MotionEvent;", "start", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "switchCamera", "tapToFocus", "view", "Landroid/view/View;", "library_release"})
@RequiresApi(value=21)
@SourceDebugExtension(value={"SMAP\nCamera1Source.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Camera1Source.kt\ncom/pedro/library/util/sources/video/Camera1Source\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1#2:185\n1549#3:186\n1620#3,3:187\n*S KotlinDebug\n*F\n+ 1 Camera1Source.kt\ncom/pedro/library/util/sources/video/Camera1Source\n*L\n82#1:186\n82#1:187,3\n*E\n"})
public final class Camera1Source
extends VideoSource {
    @NotNull
    private final Camera1ApiManager camera;
    @NotNull
    private CameraHelper.Facing facing;

    public Camera1Source(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.camera = new Camera1ApiManager(null, context);
        this.facing = CameraHelper.Facing.BACK;
    }

    @Override
    protected boolean create(int width, int height, int fps, int rotation) {
        boolean result = this.checkResolutionSupported(width, height);
        if (!result) {
            throw new IllegalArgumentException("Unsupported resolution: " + width + "x" + height);
        }
        return true;
    }

    @Override
    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.setSurfaceTexture(surfaceTexture);
        if (!this.isRunning()) {
            surfaceTexture.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.camera.setSurfaceTexture(surfaceTexture);
            this.camera.start(this.facing, this.getWidth(), this.getHeight(), this.getFps());
            this.camera.setPreviewOrientation(90);
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.camera.stop();
        }
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRunning() {
        return this.camera.isRunning();
    }

    private final boolean checkResolutionSupported(int width, int height) {
        Object v0;
        block2: {
            if (width % 2 != 0 || height % 2 != 0) {
                throw new IllegalArgumentException("width and height values must be divisible by 2");
            }
            boolean shouldRotate = width > height;
            int w = shouldRotate ? height : width;
            int h = shouldRotate ? width : height;
            Size size = new Size(w, h);
            List resolutions = this.facing == CameraHelper.Facing.BACK ? this.camera.getPreviewSizeBack() : this.camera.getPreviewSizeFront();
            Intrinsics.checkNotNull((Object)resolutions);
            Iterable iterable = this.mapCamera1Resolutions(resolutions, shouldRotate);
            for (Object t : iterable) {
                Size it = (Size)t;
                boolean bl = false;
                if (!(it.getWidth() == size.getWidth() && it.getHeight() == size.getHeight())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        return v0 != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Size> mapCamera1Resolutions(List<? extends Camera.Size> resolutions, boolean shouldRotate) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = resolutions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Camera.Size size = (Camera.Size)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(shouldRotate ? new Size(it.height, it.width) : new Size(it.width, it.height));
        }
        return (List)destination$iv$iv;
    }

    public final void switchCamera() {
        block1: {
            CameraHelper.Facing facing = this.facing = this.facing == CameraHelper.Facing.BACK ? CameraHelper.Facing.FRONT : CameraHelper.Facing.BACK;
            if (!this.isRunning()) break block1;
            this.stop();
            SurfaceTexture surfaceTexture = this.getSurfaceTexture();
            if (surfaceTexture != null) {
                SurfaceTexture it = surfaceTexture;
                boolean bl = false;
                this.start(it);
            }
        }
    }

    @NotNull
    public final CameraHelper.Facing getCameraFacing() {
        return this.facing;
    }

    @NotNull
    public final List<Size> getCameraResolutions(@NotNull CameraHelper.Facing facing) {
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        List resolutions = facing == CameraHelper.Facing.FRONT ? this.camera.getPreviewSizeFront() : this.camera.getPreviewSizeBack();
        Intrinsics.checkNotNull((Object)resolutions);
        return this.mapCamera1Resolutions(resolutions, false);
    }

    public final void setExposure(int level) {
        if (this.isRunning()) {
            this.camera.setExposure(level);
        }
    }

    public final int getExposure() {
        return this.isRunning() ? this.camera.getExposure() : 0;
    }

    public final void enableLantern() {
        if (this.isRunning()) {
            this.camera.enableLantern();
        }
    }

    public final void disableLantern() {
        if (this.isRunning()) {
            this.camera.disableLantern();
        }
    }

    public final boolean isLanternEnabled() {
        return this.isRunning() ? this.camera.isLanternEnabled() : false;
    }

    public final void enableAutoFocus() {
        if (this.isRunning()) {
            this.camera.enableAutoFocus();
        }
    }

    public final void disableAutoFocus() {
        if (this.isRunning()) {
            this.camera.disableAutoFocus();
        }
    }

    public final boolean isAutoFocusEnabled() {
        return this.isRunning() ? this.camera.isAutoFocusEnabled() : false;
    }

    public final void tapToFocus(@NotNull View view, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.camera.tapToFocus(view, event);
    }

    public final void setZoom(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isRunning()) {
            this.camera.setZoom(event);
        }
    }

    public final void setZoom(int level) {
        if (this.isRunning()) {
            this.camera.setZoom(level);
        }
    }

    @NotNull
    public final Range<Integer> getZoomRange() {
        return new Range((Comparable)Integer.valueOf(this.camera.getMinZoom()), (Comparable)Integer.valueOf(this.camera.getMaxZoom()));
    }

    public final int getZoom() {
        return this.camera.getZoom();
    }

    public final boolean enableFaceDetection(@NotNull FaceDetectorCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.isRunning() ? this.camera.enableFaceDetection(callback) : false;
    }

    public final void disableFaceDetection() {
        if (this.isRunning()) {
            this.camera.disableFaceDetection();
        }
    }

    public final boolean isFaceDetectionEnabled() {
        return this.camera.isFaceDetectionEnabled();
    }

    public final void openCameraId(int id) {
        this.camera.switchCamera(id);
    }

    public final boolean enableVideoStabilization() {
        return this.isRunning() ? this.camera.enableVideoStabilization() : false;
    }

    public final void disableVideoStabilization() {
        if (this.isRunning()) {
            this.camera.disableVideoStabilization();
        }
    }

    public final boolean isVideoStabilizationEnabled() {
        return this.camera.isVideoStabilizationEnabled();
    }
}

