/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.rtsp;

import android.media.MediaCodec;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.library.base.OnlyAudioBase;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.rtsp.rtsp.RtspClient;
import java.nio.ByteBuffer;

public class RtspOnlyAudio
extends OnlyAudioBase {
    private final RtspClient rtspClient;
    private final RtspStreamClient streamClient;

    public RtspOnlyAudio(ConnectChecker connectChecker) {
        this.rtspClient = new RtspClient(connectChecker);
        this.rtspClient.setOnlyAudio(true);
        this.streamClient = new RtspStreamClient(this.rtspClient, null);
    }

    @Override
    public RtspStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setAudioCodecImp(AudioCodec codec) {
        this.rtspClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtspClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendAudio(aacBuffer, info);
    }
}

