/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.streamclient;

import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspClient;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0016J\b\u0010 \u001a\u00020\bH\u0016J\b\u0010!\u001a\u00020\bH\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u000fH\u0016J\u001c\u0010%\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010\u001d2\b\u0010'\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0017H\u0016J\u0010\u0010*\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0017H\u0016J\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0017H\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u0017H\u0016J\u000e\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/pedro/library/util/streamclient/RtspStreamClient;", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "streamClientListener", "Lcom/pedro/library/util/streamclient/StreamClientListener;", "(Lcom/pedro/rtsp/rtsp/RtspClient;Lcom/pedro/library/util/streamclient/StreamClientListener;)V", "addCertificates", "", "certificates", "", "Ljavax/net/ssl/TrustManager;", "([Ljavax/net/ssl/TrustManager;)V", "clearCache", "getCacheSize", "", "getDroppedAudioFrames", "", "getDroppedVideoFrames", "getItemsInCache", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "", "percentUsed", "", "reTry", "delay", "reason", "", "backupUrl", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "setAuthorization", "user", "password", "setCheckServerAlive", "enabled", "setLogs", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "setProtocol", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "setReTries", "reTries", "library_release"})
public final class RtspStreamClient
extends StreamBaseClient {
    @NotNull
    private final RtspClient rtspClient;
    @Nullable
    private final StreamClientListener streamClientListener;

    public RtspStreamClient(@NotNull RtspClient rtspClient, @Nullable StreamClientListener streamClientListener2) {
        Intrinsics.checkNotNullParameter((Object)rtspClient, (String)"rtspClient");
        this.rtspClient = rtspClient;
        this.streamClientListener = streamClientListener2;
    }

    public final void addCertificates(@Nullable TrustManager[] certificates) {
        this.rtspClient.addCertificates(certificates);
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        this.rtspClient.setProtocol(protocol);
    }

    @Override
    public void setAuthorization(@Nullable String user, @Nullable String password) {
        this.rtspClient.setAuthorization(user, password);
    }

    @Override
    public void setReTries(int reTries) {
        this.rtspClient.setReTries(reTries);
    }

    @Override
    public boolean reTry(long delay, @NotNull String reason, @Nullable String backupUrl) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        boolean result = this.rtspClient.shouldRetry(reason);
        if (result) {
            StreamClientListener streamClientListener2 = this.streamClientListener;
            if (streamClientListener2 != null) {
                streamClientListener2.onRequestKeyframe();
            }
            this.rtspClient.reConnect(delay, backupUrl);
        }
        return result;
    }

    @Override
    public boolean hasCongestion(float percentUsed) {
        return this.rtspClient.hasCongestion(percentUsed);
    }

    @Override
    public void setLogs(boolean enabled) {
        this.rtspClient.setLogs(enabled);
    }

    @Override
    public void setCheckServerAlive(boolean enabled) {
        this.rtspClient.setCheckServerAlive(enabled);
    }

    @Override
    public void resizeCache(int newSize) {
        this.rtspClient.resizeCache(newSize);
    }

    @Override
    public void clearCache() {
        this.rtspClient.clearCache();
    }

    @Override
    public int getCacheSize() {
        return this.rtspClient.getCacheSize();
    }

    @Override
    public int getItemsInCache() {
        return this.rtspClient.getItemsInCache();
    }

    @Override
    public long getSentAudioFrames() {
        return this.rtspClient.getSentAudioFrames();
    }

    @Override
    public long getSentVideoFrames() {
        return this.rtspClient.getSentVideoFrames();
    }

    @Override
    public long getDroppedAudioFrames() {
        return this.rtspClient.getDroppedAudioFrames();
    }

    @Override
    public long getDroppedVideoFrames() {
        return this.rtspClient.getDroppedVideoFrames();
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtspClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtspClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtspClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtspClient.resetDroppedVideoFrames();
    }

    @Override
    public void setOnlyAudio(boolean onlyAudio) {
        this.rtspClient.setOnlyAudio(onlyAudio);
    }

    @Override
    public void setOnlyVideo(boolean onlyVideo) {
        this.rtspClient.setOnlyVideo(onlyVideo);
    }
}

