/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.sources.audio;

import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.library.util.sources.audio.AudioSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0007J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0006\u0010\u0014\u001a\u00020\u000fJ\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u0006\u0010\u001b\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/pedro/library/util/sources/audio/MicrophoneSource;", "Lcom/pedro/library/util/sources/audio/AudioSource;", "Lcom/pedro/encoder/input/audio/GetMicrophoneData;", "()V", "microphone", "Lcom/pedro/encoder/input/audio/MicrophoneManager;", "create", "", "sampleRate", "", "isStereo", "echoCanceler", "noiseSuppressor", "getMaxInputSize", "inputPCMData", "", "frame", "Lcom/pedro/encoder/Frame;", "isMuted", "isRunning", "mute", "release", "setMaxInputSize", "size", "start", "getMicrophoneData", "stop", "unMute", "library_release"})
public final class MicrophoneSource
extends AudioSource
implements GetMicrophoneData {
    @NotNull
    private final MicrophoneManager microphone = new MicrophoneManager((GetMicrophoneData)this);

    @Override
    public boolean create(int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.setSampleRate(sampleRate);
        this.setStereo(isStereo);
        this.setEchoCanceler(echoCanceler);
        this.setNoiseSuppressor(noiseSuppressor);
        boolean result = this.microphone.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        if (!result) {
            throw new IllegalArgumentException("Some parameters specified are not valid");
        }
        this.setCreated(true);
        return true;
    }

    @Override
    public void start(@NotNull GetMicrophoneData getMicrophoneData2) {
        Intrinsics.checkNotNullParameter((Object)getMicrophoneData2, (String)"getMicrophoneData");
        this.setGetMicrophoneData(getMicrophoneData2);
        if (!this.isRunning()) {
            boolean result = this.microphone.createMicrophone(this.getSampleRate(), this.isStereo(), this.getEchoCanceler(), this.getNoiseSuppressor());
            if (!result) {
                throw new IllegalArgumentException("Failed to create microphone audio source");
            }
            this.microphone.start();
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.setGetMicrophoneData(null);
            this.microphone.stop();
        }
    }

    @Override
    public boolean isRunning() {
        return this.microphone.isRunning();
    }

    @Override
    public void release() {
    }

    @Override
    public int getMaxInputSize() {
        return this.microphone.getMaxInputSize();
    }

    @Override
    public void setMaxInputSize(int size) {
        this.microphone.setMaxInputSize(size);
    }

    public void inputPCMData(@NotNull Frame frame) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            GetMicrophoneData getMicrophoneData2 = this.getGetMicrophoneData();
            if (getMicrophoneData2 == null) break block0;
            getMicrophoneData2.inputPCMData(frame);
        }
    }

    public final void mute() {
        this.microphone.mute();
    }

    public final void unMute() {
        this.microphone.unMute();
    }

    public final boolean isMuted() {
        return this.microphone.isMuted();
    }
}

