/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.sources.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.library.util.sources.video.VideoSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pedro/library/util/sources/video/ScreenSource;", "Lcom/pedro/library/util/sources/video/VideoSource;", "context", "Landroid/content/Context;", "mediaProjection", "Landroid/media/projection/MediaProjection;", "(Landroid/content/Context;Landroid/media/projection/MediaProjection;)V", "handlerThread", "Landroid/os/HandlerThread;", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "checkResolutionSupported", "", "width", "", "height", "create", "fps", "isRunning", "release", "", "start", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "stop", "library_release"})
@RequiresApi(value=21)
public final class ScreenSource
extends VideoSource {
    @NotNull
    private final Context context;
    @NotNull
    private final MediaProjection mediaProjection;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @NotNull
    private final HandlerThread handlerThread;

    public ScreenSource(@NotNull Context context, @NotNull MediaProjection mediaProjection) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
        this.context = context;
        this.mediaProjection = mediaProjection;
        this.handlerThread = new HandlerThread("ScreenSource");
    }

    @Override
    public boolean create(int width, int height, int fps) {
        this.setWidth(width);
        this.setHeight(height);
        this.setFps(fps);
        boolean result = this.checkResolutionSupported(width, height);
        if (result) {
            this.setCreated(true);
        }
        return result;
    }

    @Override
    public void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.setSurfaceTexture(surfaceTexture);
        if (!this.isRunning()) {
            int displayHeight;
            int dpi = this.context.getResources().getDisplayMetrics().densityDpi;
            int flags = 16;
            boolean shouldRotate = this.getWidth() > this.getHeight();
            int displayWidth = shouldRotate ? this.getHeight() : this.getWidth();
            int n = displayHeight = shouldRotate ? this.getWidth() : this.getHeight();
            if (shouldRotate) {
                surfaceTexture.setDefaultBufferSize(this.getHeight(), this.getWidth());
            }
            this.handlerThread.start();
            MediaProjection.Callback mediaProjectionCallback2 = new MediaProjection.Callback(){};
            this.mediaProjection.registerCallback(mediaProjectionCallback2, new Handler(this.handlerThread.getLooper()));
            VirtualDisplay.Callback callback2 = new VirtualDisplay.Callback(){};
            this.virtualDisplay = this.mediaProjection.createVirtualDisplay("ScreenSource", displayWidth, displayHeight, dpi, flags, new Surface(surfaceTexture), callback2, new Handler(this.handlerThread.getLooper()));
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            VirtualDisplay virtualDisplay = this.virtualDisplay;
            if (virtualDisplay != null) {
                virtualDisplay.release();
            }
            this.virtualDisplay = null;
            this.handlerThread.quitSafely();
        }
    }

    @Override
    public void release() {
        this.mediaProjection.stop();
    }

    @Override
    public boolean isRunning() {
        return this.virtualDisplay != null;
    }

    private final boolean checkResolutionSupported(int width, int height) {
        if (width % 2 != 0 || height % 2 != 0) {
            throw new IllegalArgumentException("width and height values must be divisible by 2");
        }
        return true;
    }
}

