/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.util.streamclient;

import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.srt.srt.packets.control.handshake.EncryptionType;
import javax.net.ssl.TrustManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010&\u001a\u00020\u000bH\u0016J\b\u0010'\u001a\u00020\u000bH\u0016J\b\u0010(\u001a\u00020\u000bH\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0018H\u0016J\u001c\u0010,\u001a\u00020\u000b2\b\u0010-\u001a\u0004\u0018\u00010\u00132\b\u0010.\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u0016H\u0016J\u0010\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u0016H\u0016J\u0016\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020;J\u0010\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u0018H\u0016J\u000e\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u0018R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/pedro/library/util/streamclient/GenericStreamClient;", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "rtmpClient", "Lcom/pedro/library/util/streamclient/RtmpStreamClient;", "rtspClient", "Lcom/pedro/library/util/streamclient/RtspStreamClient;", "srtClient", "Lcom/pedro/library/util/streamclient/SrtStreamClient;", "(Lcom/pedro/library/util/streamclient/RtmpStreamClient;Lcom/pedro/library/util/streamclient/RtspStreamClient;Lcom/pedro/library/util/streamclient/SrtStreamClient;)V", "connectedStreamClient", "addCertificates", "", "certificates", "", "Ljavax/net/ssl/TrustManager;", "([Ljavax/net/ssl/TrustManager;)V", "clearCache", "connecting", "url", "", "forceIncrementalTs", "enabled", "", "getCacheSize", "", "getDroppedAudioFrames", "", "getDroppedVideoFrames", "getItemsInCache", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "percentUsed", "", "reTry", "delay", "reason", "backupUrl", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "setAuthorization", "user", "password", "setCheckServerAlive", "setLogs", "setOnlyAudio", "onlyAudio", "setOnlyVideo", "onlyVideo", "setPassphrase", "passphrase", "type", "Lcom/pedro/srt/srt/packets/control/handshake/EncryptionType;", "setProtocol", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "setReTries", "reTries", "setWriteChunkSize", "chunkSize", "library_release"})
public final class GenericStreamClient
extends StreamBaseClient {
    @NotNull
    private final RtmpStreamClient rtmpClient;
    @NotNull
    private final RtspStreamClient rtspClient;
    @NotNull
    private final SrtStreamClient srtClient;
    @Nullable
    private StreamBaseClient connectedStreamClient;

    public GenericStreamClient(@NotNull RtmpStreamClient rtmpClient, @NotNull RtspStreamClient rtspClient, @NotNull SrtStreamClient srtClient) {
        Intrinsics.checkNotNullParameter((Object)rtmpClient, (String)"rtmpClient");
        Intrinsics.checkNotNullParameter((Object)rtspClient, (String)"rtspClient");
        Intrinsics.checkNotNullParameter((Object)srtClient, (String)"srtClient");
        this.rtmpClient = rtmpClient;
        this.rtspClient = rtspClient;
        this.srtClient = srtClient;
    }

    public final void addCertificates(@Nullable TrustManager[] certificates) {
        this.rtmpClient.addCertificates(certificates);
        this.rtspClient.addCertificates(certificates);
    }

    public final void setPassphrase(@NotNull String passphrase, @NotNull EncryptionType type) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.srtClient.setPassphrase(passphrase, type);
    }

    public final void setProtocol(@NotNull Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        this.rtspClient.setProtocol(protocol);
    }

    public final void forceIncrementalTs(boolean enabled) {
        this.rtmpClient.forceIncrementalTs(enabled);
    }

    public final void setWriteChunkSize(int chunkSize) {
        this.rtmpClient.setWriteChunkSize(chunkSize);
    }

    @Override
    public void setAuthorization(@Nullable String user, @Nullable String password) {
        this.rtmpClient.setAuthorization(user, password);
        this.rtspClient.setAuthorization(user, password);
        this.srtClient.setAuthorization(user, password);
    }

    @Override
    public void setReTries(int reTries) {
        this.rtmpClient.setReTries(reTries);
        this.rtspClient.setReTries(reTries);
        this.srtClient.setReTries(reTries);
    }

    @Override
    public boolean reTry(long delay, @NotNull String reason, @Nullable String backupUrl) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.reTry(delay, reason, backupUrl) : false;
    }

    @Override
    public boolean hasCongestion(float percentUsed) {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.hasCongestion(percentUsed) : false;
    }

    @Override
    public void setLogs(boolean enabled) {
        this.rtmpClient.setLogs(enabled);
        this.rtspClient.setLogs(enabled);
        this.srtClient.setLogs(enabled);
    }

    @Override
    public void setCheckServerAlive(boolean enabled) {
        this.rtmpClient.setCheckServerAlive(enabled);
        this.rtspClient.setCheckServerAlive(enabled);
        this.srtClient.setCheckServerAlive(enabled);
    }

    @Override
    public void resizeCache(int newSize) {
        this.rtmpClient.resizeCache(newSize);
        this.rtspClient.resizeCache(newSize);
        this.srtClient.resizeCache(newSize);
    }

    @Override
    public void clearCache() {
        this.rtmpClient.clearCache();
        this.rtspClient.clearCache();
        this.srtClient.clearCache();
    }

    @Override
    public int getCacheSize() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getCacheSize() : 0;
    }

    @Override
    public int getItemsInCache() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getItemsInCache() : 0;
    }

    @Override
    public long getSentAudioFrames() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getSentAudioFrames() : 0L;
    }

    @Override
    public long getSentVideoFrames() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getSentVideoFrames() : 0L;
    }

    @Override
    public long getDroppedAudioFrames() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getDroppedAudioFrames() : 0L;
    }

    @Override
    public long getDroppedVideoFrames() {
        StreamBaseClient streamBaseClient = this.connectedStreamClient;
        return streamBaseClient != null ? streamBaseClient.getDroppedVideoFrames() : 0L;
    }

    @Override
    public void resetSentAudioFrames() {
        this.rtmpClient.resetSentAudioFrames();
        this.rtspClient.resetSentAudioFrames();
        this.srtClient.resetSentAudioFrames();
    }

    @Override
    public void resetSentVideoFrames() {
        this.rtmpClient.resetSentVideoFrames();
        this.rtspClient.resetSentVideoFrames();
        this.srtClient.resetSentVideoFrames();
    }

    @Override
    public void resetDroppedAudioFrames() {
        this.rtmpClient.resetDroppedAudioFrames();
    }

    @Override
    public void resetDroppedVideoFrames() {
        this.rtmpClient.resetDroppedVideoFrames();
        this.rtspClient.resetDroppedVideoFrames();
        this.srtClient.resetDroppedVideoFrames();
    }

    @Override
    public void setOnlyAudio(boolean onlyAudio) {
        this.rtmpClient.setOnlyAudio(onlyAudio);
        this.rtspClient.setOnlyAudio(onlyAudio);
        this.srtClient.setOnlyAudio(onlyAudio);
    }

    @Override
    public void setOnlyVideo(boolean onlyVideo) {
        this.rtmpClient.setOnlyVideo(onlyVideo);
        this.rtspClient.setOnlyVideo(onlyVideo);
        this.srtClient.setOnlyVideo(onlyVideo);
    }

    public final void connecting(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.connectedStreamClient = StringsKt.startsWith((String)url, (String)"rtmp", (boolean)true) ? (StreamBaseClient)this.rtmpClient : (StringsKt.startsWith((String)url, (String)"rtsp", (boolean)true) ? (StreamBaseClient)this.rtspClient : (StringsKt.startsWith((String)url, (String)"srt", (boolean)true) ? (StreamBaseClient)this.srtClient : null));
    }
}

