/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.multiple;

import android.content.Context;
import android.media.MediaCodec;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.Camera1Base;
import com.pedro.library.multiple.RtpType;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtsp.rtsp.RtspClient;
import java.nio.ByteBuffer;

public class MultiRtpCamera1
extends Camera1Base {
    private final RtmpClient[] rtmpClients;
    private final RtspClient[] rtspClients;

    public MultiRtpCamera1(SurfaceView surfaceView, ConnectChecker[] connectCheckerRtmpList, ConnectChecker[] connectCheckerRtspList) {
        super(surfaceView);
        int rtmpSize = connectCheckerRtmpList != null ? connectCheckerRtmpList.length : 0;
        this.rtmpClients = new RtmpClient[rtmpSize];
        for (int i = 0; i < this.rtmpClients.length; ++i) {
            this.rtmpClients[i] = new RtmpClient(connectCheckerRtmpList[i]);
        }
        int rtspSize = connectCheckerRtspList != null ? connectCheckerRtspList.length : 0;
        this.rtspClients = new RtspClient[rtspSize];
        for (int i = 0; i < this.rtspClients.length; ++i) {
            this.rtspClients[i] = new RtspClient(connectCheckerRtspList[i]);
        }
    }

    public MultiRtpCamera1(TextureView textureView, ConnectChecker[] connectCheckerRtmpList, ConnectChecker[] connectCheckerRtspList) {
        super(textureView);
        int rtmpSize = connectCheckerRtmpList != null ? connectCheckerRtmpList.length : 0;
        this.rtmpClients = new RtmpClient[rtmpSize];
        for (int i = 0; i < this.rtmpClients.length; ++i) {
            this.rtmpClients[i] = new RtmpClient(connectCheckerRtmpList[i]);
        }
        int rtspSize = connectCheckerRtspList != null ? connectCheckerRtspList.length : 0;
        this.rtspClients = new RtspClient[rtspSize];
        for (int i = 0; i < this.rtspClients.length; ++i) {
            this.rtspClients[i] = new RtspClient(connectCheckerRtspList[i]);
        }
    }

    @RequiresApi(api=18)
    public MultiRtpCamera1(OpenGlView openGlView, ConnectChecker[] connectCheckerRtmpList, ConnectChecker[] connectCheckerRtspList) {
        super(openGlView);
        int rtmpSize = connectCheckerRtmpList != null ? connectCheckerRtmpList.length : 0;
        this.rtmpClients = new RtmpClient[rtmpSize];
        for (int i = 0; i < this.rtmpClients.length; ++i) {
            this.rtmpClients[i] = new RtmpClient(connectCheckerRtmpList[i]);
        }
        int rtspSize = connectCheckerRtspList != null ? connectCheckerRtspList.length : 0;
        this.rtspClients = new RtspClient[rtspSize];
        for (int i = 0; i < this.rtspClients.length; ++i) {
            this.rtspClients[i] = new RtspClient(connectCheckerRtspList[i]);
        }
    }

    @RequiresApi(api=18)
    public MultiRtpCamera1(LightOpenGlView lightOpenGlView, ConnectChecker[] connectCheckerRtmpList, ConnectChecker[] connectCheckerRtspList) {
        super(lightOpenGlView);
        int rtmpSize = connectCheckerRtmpList != null ? connectCheckerRtmpList.length : 0;
        this.rtmpClients = new RtmpClient[rtmpSize];
        for (int i = 0; i < this.rtmpClients.length; ++i) {
            this.rtmpClients[i] = new RtmpClient(connectCheckerRtmpList[i]);
        }
        int rtspSize = connectCheckerRtspList != null ? connectCheckerRtspList.length : 0;
        this.rtspClients = new RtspClient[rtspSize];
        for (int i = 0; i < this.rtspClients.length; ++i) {
            this.rtspClients[i] = new RtspClient(connectCheckerRtspList[i]);
        }
    }

    @RequiresApi(api=18)
    public MultiRtpCamera1(Context context, ConnectChecker[] connectCheckerRtmpList, ConnectChecker[] connectCheckerRtspList) {
        super(context);
        int rtmpSize = connectCheckerRtmpList != null ? connectCheckerRtmpList.length : 0;
        this.rtmpClients = new RtmpClient[rtmpSize];
        for (int i = 0; i < this.rtmpClients.length; ++i) {
            this.rtmpClients[i] = new RtmpClient(connectCheckerRtmpList[i]);
        }
        int rtspSize = connectCheckerRtspList != null ? connectCheckerRtspList.length : 0;
        this.rtspClients = new RtspClient[rtspSize];
        for (int i = 0; i < this.rtspClients.length; ++i) {
            this.rtspClients[i] = new RtspClient(connectCheckerRtspList[i]);
        }
    }

    public boolean isStreaming(RtpType rtpType, int index) {
        if (rtpType == RtpType.RTMP) {
            return this.rtmpClients[index].isStreaming();
        }
        return this.rtspClients[index].isStreaming();
    }

    public void resizeCache(RtpType rtpType, int index, int newSize) {
        if (rtpType == RtpType.RTMP) {
            this.rtmpClients[index].resizeCache(newSize);
        } else {
            this.rtspClients[index].resizeCache(newSize);
        }
    }

    public void resizeCache(int newSize) throws RuntimeException {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resizeCache(newSize);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resizeCache(newSize);
        }
    }

    public int getCacheSize(RtpType rtpType, int index) {
        if (rtpType == RtpType.RTMP) {
            return this.rtmpClients[index].getCacheSize();
        }
        return this.rtspClients[index].getCacheSize();
    }

    public long getSentAudioFrames() {
        long number = 0L;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            number += rtmpClient.getSentAudioFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            number += rtmpClient.getSentAudioFrames();
        }
        return number;
    }

    public long getSentVideoFrames() {
        long number = 0L;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            number += rtmpClient.getSentVideoFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            number += rtmpClient.getSentVideoFrames();
        }
        return number;
    }

    public long getDroppedAudioFrames() {
        long number = 0L;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            number += rtmpClient.getDroppedAudioFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            number += rtmpClient.getDroppedAudioFrames();
        }
        return number;
    }

    public long getDroppedVideoFrames() {
        long number = 0L;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            number += rtmpClient.getDroppedVideoFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            number += rtmpClient.getDroppedVideoFrames();
        }
        return number;
    }

    public void resetSentAudioFrames() {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resetSentAudioFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resetSentAudioFrames();
        }
    }

    public void resetSentVideoFrames() {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resetSentVideoFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resetSentVideoFrames();
        }
    }

    public void resetDroppedAudioFrames() {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resetDroppedAudioFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resetDroppedAudioFrames();
        }
    }

    public void resetDroppedVideoFrames() {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.resetDroppedVideoFrames();
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.resetDroppedVideoFrames();
        }
    }

    public void setAuthorization(RtpType rtpType, int index, String user, String password) {
        if (rtpType == RtpType.RTMP) {
            this.rtmpClients[index].setAuthorization(user, password);
        } else {
            this.rtspClients[index].setAuthorization(user, password);
        }
    }

    public void setAuthorization(String user, String password) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setAuthorization(user, password);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setAuthorization(user, password);
        }
    }

    public void forceIncrementalTs(boolean enabled) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.forceIncrementalTs(enabled);
        }
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setAudioInfo(sampleRate, isStereo);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setAudioInfo(sampleRate, isStereo);
        }
    }

    public void startStream(RtpType rtpType, int index, String url) {
        boolean shouldStarEncoder = true;
        for (RtmpClient rtmpClient : this.rtmpClients) {
            if (!rtmpClient.isStreaming()) continue;
            shouldStarEncoder = false;
            break;
        }
        if (shouldStarEncoder) {
            for (RtmpClient rtmpClient : this.rtspClients) {
                if (!rtmpClient.isStreaming()) continue;
                shouldStarEncoder = false;
                break;
            }
        }
        if (shouldStarEncoder) {
            super.startStream("");
        }
        if (rtpType == RtpType.RTMP) {
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.rtmpClients[index].setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.rtmpClients[index].setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            this.rtmpClients[index].setFps(this.videoEncoder.getFps());
            this.rtmpClients[index].connect(url);
        } else {
            this.rtspClients[index].connect(url);
        }
    }

    @Override
    protected void startStreamRtp(String url) {
    }

    public void stopStream(RtpType rtpType, int index) {
        boolean shouldStopEncoder = true;
        if (rtpType == RtpType.RTMP) {
            this.rtmpClients[index].disconnect();
        } else {
            this.rtspClients[index].disconnect();
        }
        for (RtmpClient rtmpClient : this.rtmpClients) {
            if (!rtmpClient.isStreaming()) continue;
            shouldStopEncoder = false;
            break;
        }
        if (shouldStopEncoder) {
            for (RtmpClient rtmpClient : this.rtspClients) {
                if (!rtmpClient.isStreaming()) continue;
                shouldStopEncoder = false;
                break;
            }
        }
        if (shouldStopEncoder) {
            super.stopStream();
        }
    }

    @Override
    protected void stopStreamRtp() {
    }

    public void setReTries(int reTries) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setReTries(reTries);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setReTries(reTries);
        }
    }

    public boolean reTry(RtpType rtpType, int index, long delay, String reason, @Nullable String backupUrl) {
        boolean result;
        if (rtpType == RtpType.RTMP) {
            result = this.rtmpClients[index].shouldRetry(reason);
            if (result) {
                this.requestKeyFrame();
                this.rtmpClients[index].reConnect(delay, backupUrl);
            }
        } else {
            result = this.rtspClients[index].shouldRetry(reason);
            if (result) {
                this.requestKeyFrame();
                this.rtmpClients[index].reConnect(delay, backupUrl);
            }
        }
        return result;
    }

    public boolean hasCongestion(RtpType rtpType, int index) {
        if (rtpType == RtpType.RTMP) {
            return this.rtmpClients[index].hasCongestion();
        }
        return this.rtspClients[index].hasCongestion();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.sendAudio(aacBuffer.duplicate(), info);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.sendAudio(aacBuffer.duplicate(), info);
        }
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setVideoInfo(sps.duplicate(), pps.duplicate(), vps != null ? vps.duplicate() : null);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setVideoInfo(sps.duplicate(), pps.duplicate(), vps != null ? vps.duplicate() : null);
        }
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.sendVideo(h264Buffer.duplicate(), info);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.sendVideo(h264Buffer.duplicate(), info);
        }
    }

    @Override
    public StreamBaseClient getStreamClient() {
        return null;
    }

    @Override
    protected void setVideoCodecImp(VideoCodec codec) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setVideoCodec(codec);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setVideoCodec(codec);
        }
    }

    @Override
    protected void setAudioCodecImp(AudioCodec codec) {
        for (RtspClient rtspClient : this.rtspClients) {
            rtspClient.setAudioCodec(codec);
        }
    }

    public void setLogs(boolean enable) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setLogs(enable);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setLogs(enable);
        }
    }

    public void setCheckServerAlive(boolean enable) {
        for (RtmpClient rtmpClient : this.rtmpClients) {
            rtmpClient.setCheckServerAlive(enable);
        }
        for (RtmpClient rtmpClient : this.rtspClients) {
            rtmpClient.setCheckServerAlive(enable);
        }
    }
}

