/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.generic;

import android.content.Context;
import android.media.MediaCodec;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.VideoDecoderInterface;
import com.pedro.library.base.FromFileBase;
import com.pedro.library.generic.ClientType;
import com.pedro.library.generic.GenericFromFile;
import com.pedro.library.util.streamclient.GenericStreamClient;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.srt.srt.SrtClient;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0091\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\u001d\b\u0007\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rB'\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0010B\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0018\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010'\u001a\u00020\u001bH\u0016J\u0010\u0010(\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J$\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\"2\b\u0010,\u001a\u0004\u0018\u00010\"H\u0014J\u0018\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u000204H\u0014J\u0010\u00105\u001a\u00020 2\u0006\u00103\u001a\u000206H\u0014J\u0010\u00107\u001a\u00020 2\u0006\u00108\u001a\u000209H\u0014J\u0010\u0010:\u001a\u00020 2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010;\u001a\u00020 2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010<\u001a\u00020 2\u0006\u00108\u001a\u000209H\u0002J\b\u0010=\u001a\u00020 H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006>"}, d2={"Lcom/pedro/library/generic/GenericFromFile;", "Lcom/pedro/library/base/FromFileBase;", "openGlView", "Lcom/pedro/library/view/OpenGlView;", "connectChecker", "Lcom/pedro/common/ConnectChecker;", "videoDecoderInterface", "Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;", "audioDecoderInterface", "Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;", "(Lcom/pedro/library/view/OpenGlView;Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "lightOpenGlView", "Lcom/pedro/library/view/LightOpenGlView;", "(Lcom/pedro/library/view/LightOpenGlView;Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "(Lcom/pedro/common/ConnectChecker;Lcom/pedro/encoder/input/decoder/VideoDecoderInterface;Lcom/pedro/encoder/input/decoder/AudioDecoderInterface;)V", "connectedType", "Lcom/pedro/library/generic/ClientType;", "rtmpClient", "Lcom/pedro/rtmp/rtmp/RtmpClient;", "rtspClient", "Lcom/pedro/rtsp/rtsp/RtspClient;", "srtClient", "Lcom/pedro/srt/srt/SrtClient;", "streamClient", "Lcom/pedro/library/util/streamclient/GenericStreamClient;", "streamClientListener", "com/pedro/library/generic/GenericFromFile$streamClientListener$1", "Lcom/pedro/library/generic/GenericFromFile$streamClientListener$1;", "getAacDataRtp", "", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getH264DataRtp", "h264Buffer", "getStreamClient", "init", "onSpsPpsVpsRtp", "sps", "pps", "vps", "prepareAudioRtp", "isStereo", "", "sampleRate", "", "setAudioCodecImp", "codec", "Lcom/pedro/common/AudioCodec;", "setVideoCodecImp", "Lcom/pedro/common/VideoCodec;", "startStreamRtp", "url", "", "startStreamRtpRtmp", "startStreamRtpRtsp", "startStreamRtpSrt", "stopStreamRtp", "library_release"})
@RequiresApi(api=18)
public final class GenericFromFile
extends FromFileBase {
    @NotNull
    private final streamClientListener.1 streamClientListener;
    private ConnectChecker connectChecker;
    private RtmpClient rtmpClient;
    private RtspClient rtspClient;
    private SrtClient srtClient;
    private GenericStreamClient streamClient;
    @NotNull
    private ClientType connectedType;

    public GenericFromFile(@NotNull OpenGlView openGlView, @NotNull ConnectChecker connectChecker, @NotNull VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)openGlView, (String)"openGlView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoDecoderInterface, (String)"videoDecoderInterface");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(openGlView, videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new StreamClientListener(this){
            final /* synthetic */ GenericFromFile this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRequestKeyframe() {
                this.this$0.requestKeyFrame();
            }
        };
        this.connectedType = ClientType.NONE;
        this.init(connectChecker);
    }

    public GenericFromFile(@NotNull LightOpenGlView lightOpenGlView, @NotNull ConnectChecker connectChecker, @Nullable VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)lightOpenGlView, (String)"lightOpenGlView");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(lightOpenGlView, videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.connectedType = ClientType.NONE;
        this.init(connectChecker);
    }

    public GenericFromFile(@NotNull Context context, @NotNull ConnectChecker connectChecker, @NotNull VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoDecoderInterface, (String)"videoDecoderInterface");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(context, videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.connectedType = ClientType.NONE;
        this.init(connectChecker);
    }

    public GenericFromFile(@NotNull ConnectChecker connectChecker, @NotNull VideoDecoderInterface videoDecoderInterface, @NotNull AudioDecoderInterface audioDecoderInterface) {
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        Intrinsics.checkNotNullParameter((Object)videoDecoderInterface, (String)"videoDecoderInterface");
        Intrinsics.checkNotNullParameter((Object)audioDecoderInterface, (String)"audioDecoderInterface");
        super(videoDecoderInterface, audioDecoderInterface);
        this.streamClientListener = new /* invalid duplicate definition of identical inner class */;
        this.connectedType = ClientType.NONE;
        this.init(connectChecker);
    }

    private final void init(ConnectChecker connectChecker) {
        this.connectChecker = connectChecker;
        this.rtmpClient = new RtmpClient(connectChecker);
        this.rtspClient = new RtspClient(connectChecker);
        this.srtClient = new SrtClient(connectChecker);
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        RtmpStreamClient rtmpStreamClient = new RtmpStreamClient(rtmpClient, this.streamClientListener);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        RtspStreamClient rtspStreamClient = new RtspStreamClient(rtspClient, this.streamClientListener);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        this.streamClient = new GenericStreamClient(rtmpStreamClient, rtspStreamClient, new SrtStreamClient(srtClient, this.streamClientListener));
    }

    @Override
    @NotNull
    public GenericStreamClient getStreamClient() {
        GenericStreamClient genericStreamClient = this.streamClient;
        if (genericStreamClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streamClient");
            genericStreamClient = null;
        }
        return genericStreamClient;
    }

    @Override
    protected void setVideoCodecImp(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (codec != VideoCodec.H264 && codec != VideoCodec.H265) {
            throw new IllegalArgumentException("Unsupported codec: " + codec.name() + ". Generic only support video H264 and H265");
        }
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoCodec(codec);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setVideoCodec(codec);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        srtClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        if (codec != AudioCodec.AAC) {
            throw new IllegalArgumentException("Unsupported codec: " + codec.name() + ". Generic only support audio AAC");
        }
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioCodec(codec);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setAudioCodec(codec);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        srtClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setAudioInfo(sampleRate, isStereo);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setAudioInfo(sampleRate, isStereo);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        GenericStreamClient genericStreamClient = this.streamClient;
        if (genericStreamClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"streamClient");
            genericStreamClient = null;
        }
        genericStreamClient.connecting(url);
        if (StringsKt.startsWith((String)url, (String)"rtmp", (boolean)true)) {
            this.connectedType = ClientType.RTMP;
            this.startStreamRtpRtmp(url);
        } else if (StringsKt.startsWith((String)url, (String)"rtsp", (boolean)true)) {
            this.connectedType = ClientType.RTSP;
            this.startStreamRtpRtsp(url);
        } else if (StringsKt.startsWith((String)url, (String)"srt", (boolean)true)) {
            this.connectedType = ClientType.SRT;
            this.startStreamRtpSrt(url);
        } else {
            ConnectChecker connectChecker = this.connectChecker;
            if (connectChecker == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connectChecker");
                connectChecker = null;
            }
            connectChecker.onConnectionFailed("unsupported protocol. Only support rtmp, rtsp and srt");
        }
    }

    private final void startStreamRtpRtmp(String url) {
        RtmpClient rtmpClient;
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            RtmpClient rtmpClient2 = this.rtmpClient;
            if (rtmpClient2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient2 = null;
            }
            rtmpClient2.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            RtmpClient rtmpClient3 = this.rtmpClient;
            if (rtmpClient3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                rtmpClient3 = null;
            }
            rtmpClient3.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        if ((rtmpClient = this.rtmpClient) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setFps(this.videoEncoder.getFps());
        RtmpClient rtmpClient4 = this.rtmpClient;
        if (rtmpClient4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient4 = null;
        }
        rtmpClient4.connect(url);
    }

    private final void startStreamRtpRtsp(String url) {
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.connect(url);
    }

    private final void startStreamRtpSrt(String url) {
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        SrtClient.connect$default((SrtClient)srtClient, (String)url, (boolean)false, (int)2, null);
    }

    @Override
    protected void stopStreamRtp() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                RtmpClient rtmpClient = this.rtmpClient;
                if (rtmpClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                    rtmpClient = null;
                }
                rtmpClient.disconnect();
                break;
            }
            case 2: {
                RtspClient rtspClient = this.rtspClient;
                if (rtspClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
                    rtspClient = null;
                }
                rtspClient.disconnect();
                break;
            }
            case 3: {
                SrtClient srtClient = this.srtClient;
                if (srtClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
                    srtClient = null;
                }
                srtClient.disconnect();
            }
        }
        this.connectedType = ClientType.NONE;
    }

    @Override
    protected void getAacDataRtp(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                RtmpClient rtmpClient = this.rtmpClient;
                if (rtmpClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                    rtmpClient = null;
                }
                rtmpClient.sendAudio(aacBuffer, info);
                break;
            }
            case 2: {
                RtspClient rtspClient = this.rtspClient;
                if (rtspClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
                    rtspClient = null;
                }
                rtspClient.sendAudio(aacBuffer, info);
                break;
            }
            case 3: {
                SrtClient srtClient = this.srtClient;
                if (srtClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
                    srtClient = null;
                }
                srtClient.sendAudio(aacBuffer, info);
            }
        }
    }

    @Override
    protected void onSpsPpsVpsRtp(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        RtmpClient rtmpClient = this.rtmpClient;
        if (rtmpClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
            rtmpClient = null;
        }
        rtmpClient.setVideoInfo(sps, pps, vps);
        RtspClient rtspClient = this.rtspClient;
        if (rtspClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
            rtspClient = null;
        }
        rtspClient.setVideoInfo(sps, pps, vps);
        SrtClient srtClient = this.srtClient;
        if (srtClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
            srtClient = null;
        }
        srtClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        switch (WhenMappings.$EnumSwitchMapping$0[this.connectedType.ordinal()]) {
            case 1: {
                RtmpClient rtmpClient = this.rtmpClient;
                if (rtmpClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtmpClient");
                    rtmpClient = null;
                }
                rtmpClient.sendVideo(h264Buffer, info);
                break;
            }
            case 2: {
                RtspClient rtspClient = this.rtspClient;
                if (rtspClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rtspClient");
                    rtspClient = null;
                }
                rtspClient.sendVideo(h264Buffer, info);
                break;
            }
            case 3: {
                SrtClient srtClient = this.srtClient;
                if (srtClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"srtClient");
                    srtClient = null;
                }
                srtClient.sendVideo(h264Buffer, info);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientType.values().length];
            try {
                nArray[ClientType.RTMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.RTSP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientType.SRT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

