/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.generic;

import android.content.Context;
import android.media.MediaCodec;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.ConnectChecker;
import com.pedro.common.VideoCodec;
import com.pedro.library.base.Camera2Base;
import com.pedro.library.generic.ClientType;
import com.pedro.library.util.streamclient.GenericStreamClient;
import com.pedro.library.util.streamclient.RtmpStreamClient;
import com.pedro.library.util.streamclient.RtspStreamClient;
import com.pedro.library.util.streamclient.SrtStreamClient;
import com.pedro.library.util.streamclient.StreamClientListener;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OpenGlView;
import com.pedro.rtmp.rtmp.RtmpClient;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.srt.srt.SrtClient;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class GenericCamera2
extends Camera2Base {
    private RtmpClient rtmpClient;
    private RtspClient rtspClient;
    private SrtClient srtClient;
    private GenericStreamClient streamClient;
    private ClientType connectedType = ClientType.NONE;
    private final StreamClientListener streamClientListener = this::requestKeyFrame;
    private ConnectChecker connectChecker;

    @Deprecated
    public GenericCamera2(SurfaceView surfaceView, ConnectChecker connectChecker) {
        super(surfaceView);
        this.init(connectChecker);
    }

    @Deprecated
    public GenericCamera2(TextureView textureView, ConnectChecker connectChecker) {
        super(textureView);
        this.init(connectChecker);
    }

    public GenericCamera2(OpenGlView openGlView, ConnectChecker connectChecker) {
        super(openGlView);
        this.init(connectChecker);
    }

    public GenericCamera2(LightOpenGlView lightOpenGlView, ConnectChecker connectChecker) {
        super(lightOpenGlView);
        this.init(connectChecker);
    }

    public GenericCamera2(Context context, boolean useOpengl, ConnectChecker connectChecker) {
        super(context, useOpengl);
        this.init(connectChecker);
    }

    private void init(ConnectChecker connectChecker) {
        this.connectChecker = connectChecker;
        this.rtmpClient = new RtmpClient(connectChecker);
        this.rtspClient = new RtspClient(connectChecker);
        this.srtClient = new SrtClient(connectChecker);
        this.streamClient = new GenericStreamClient(new RtmpStreamClient(this.rtmpClient, this.streamClientListener), new RtspStreamClient(this.rtspClient, this.streamClientListener), new SrtStreamClient(this.srtClient, this.streamClientListener));
    }

    @Override
    public GenericStreamClient getStreamClient() {
        return this.streamClient;
    }

    @Override
    protected void setVideoCodecImp(VideoCodec codec) {
        if (codec != VideoCodec.H264 && codec != VideoCodec.H265) {
            throw new IllegalArgumentException("Unsupported codec: " + codec.name() + ". Generic only support video " + VideoCodec.H264.name() + " and " + VideoCodec.H265.name());
        }
        this.rtmpClient.setVideoCodec(codec);
        this.rtspClient.setVideoCodec(codec);
        this.srtClient.setVideoCodec(codec);
    }

    @Override
    protected void setAudioCodecImp(AudioCodec codec) {
        if (codec != AudioCodec.AAC) {
            throw new IllegalArgumentException("Unsupported codec: " + codec.name() + ". Generic only support audio " + AudioCodec.AAC.name());
        }
        this.rtmpClient.setAudioCodec(codec);
        this.rtspClient.setAudioCodec(codec);
        this.srtClient.setAudioCodec(codec);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtmpClient.setAudioInfo(sampleRate, isStereo);
        this.rtspClient.setAudioInfo(sampleRate, isStereo);
        this.srtClient.setAudioInfo(sampleRate, isStereo);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.streamClient.connecting(url);
        if (url.toLowerCase().startsWith("rtmp")) {
            this.connectedType = ClientType.RTMP;
            this.startStreamRtpRtmp(url);
        } else if (url.toLowerCase().startsWith("rtsp")) {
            this.connectedType = ClientType.RTSP;
            this.startStreamRtpRtsp(url);
        } else if (url.toLowerCase().startsWith("srt")) {
            this.connectedType = ClientType.SRT;
            this.startStreamRtpSrt(url);
        } else {
            this.connectChecker.onConnectionFailed("unsupported protocol. Only support rtmp, rtsp and srt");
        }
    }

    private void startStreamRtpRtmp(String url) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
        } else {
            this.rtmpClient.setVideoResolution(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        this.rtmpClient.setFps(this.videoEncoder.getFps());
        this.rtmpClient.connect(url);
    }

    private void startStreamRtpRtsp(String url) {
        this.rtspClient.connect(url);
    }

    private void startStreamRtpSrt(String url) {
        this.srtClient.connect(url);
    }

    @Override
    protected void stopStreamRtp() {
        switch (this.connectedType) {
            case RTMP: {
                this.rtmpClient.disconnect();
                break;
            }
            case RTSP: {
                this.rtspClient.disconnect();
                break;
            }
            case SRT: {
                this.srtClient.disconnect();
                break;
            }
        }
        this.connectedType = ClientType.NONE;
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        switch (this.connectedType) {
            case RTMP: {
                this.rtmpClient.sendAudio(aacBuffer, info);
                break;
            }
            case RTSP: {
                this.rtspClient.sendAudio(aacBuffer, info);
                break;
            }
            case SRT: {
                this.srtClient.sendAudio(aacBuffer, info);
                break;
            }
        }
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        this.rtmpClient.setVideoInfo(sps, pps, vps);
        this.rtspClient.setVideoInfo(sps, pps, vps);
        this.srtClient.setVideoInfo(sps, pps, vps);
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        switch (this.connectedType) {
            case RTMP: {
                this.rtmpClient.sendVideo(h264Buffer, info);
                break;
            }
            case RTSP: {
                this.rtspClient.sendVideo(h264Buffer, info);
                break;
            }
            case SRT: {
                this.srtClient.sendVideo(h264Buffer, info);
                break;
            }
        }
    }
}

