/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.RequiresApi;
import com.pedro.common.AudioCodec;
import com.pedro.common.VideoCodec;
import com.pedro.encoder.EncoderErrorCallback;
import com.pedro.encoder.Frame;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.StreamBase;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.sources.audio.AudioSource;
import com.pedro.library.util.sources.video.NoVideoSource;
import com.pedro.library.util.sources.video.VideoSource;
import com.pedro.library.util.streamclient.StreamBaseClient;
import com.pedro.library.view.GlStreamInterface;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c9\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\u0016\b'\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001cH$J\u000e\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020\u0007J\u000e\u00102\u001a\u00020,2\u0006\u00101\u001a\u00020\u0005J\u0016\u00103\u001a\u00020,2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205J\u0018\u00107\u001a\u00020,2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H$J\u0006\u0010<\u001a\u00020\u001bJ\u0018\u0010=\u001a\u00020,2\u0006\u0010>\u001a\u0002092\u0006\u0010:\u001a\u00020;H$J\b\u0010?\u001a\u00020@H&J\u0006\u0010A\u001a\u00020BJ\b\u0010C\u001a\u00020.H\u0004J\b\u0010D\u001a\u00020EH\u0004J$\u0010F\u001a\u00020,2\u0006\u0010G\u001a\u0002092\b\u0010H\u001a\u0004\u0018\u0001092\b\u0010I\u001a\u0004\u0018\u000109H$J4\u0010J\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001c2\u0006\u0010K\u001a\u00020.2\b\b\u0002\u0010L\u001a\u00020\u001c2\b\b\u0002\u0010M\u001a\u00020\u001cH\u0007J\b\u0010N\u001a\u00020\u001cH\u0002JR\u0010O\u001a\u00020\u001c2\u0006\u0010P\u001a\u00020.2\u0006\u0010Q\u001a\u00020.2\u0006\u0010K\u001a\u00020.2\b\b\u0002\u0010R\u001a\u00020.2\b\b\u0002\u0010S\u001a\u00020.2\b\b\u0002\u0010T\u001a\u00020.2\b\b\u0002\u0010U\u001a\u00020.2\b\b\u0002\u0010V\u001a\u00020.H\u0007J\u0006\u0010W\u001a\u00020,J\u0006\u0010X\u001a\u00020,J\u0010\u0010Y\u001a\u00020,2\u0006\u0010Z\u001a\u00020[H$J\b\u0010\\\u001a\u00020,H$J\u000e\u0010]\u001a\u00020,2\u0006\u0010^\u001a\u00020_J\u0010\u0010`\u001a\u00020,2\u0006\u0010^\u001a\u00020_H$J\u0010\u0010a\u001a\u00020,2\b\u0010b\u001a\u0004\u0018\u00010cJ\u000e\u0010d\u001a\u00020,2\u0006\u0010e\u001a\u00020.J\u000e\u0010f\u001a\u00020,2\u0006\u0010!\u001a\u00020\"J\u000e\u0010g\u001a\u00020,2\u0006\u0010K\u001a\u00020.J\u000e\u0010h\u001a\u00020,2\u0006\u0010^\u001a\u00020iJ\u0010\u0010j\u001a\u00020,2\u0006\u0010^\u001a\u00020iH$J\u001e\u0010k\u001a\u00020,2\u0006\u0010l\u001a\u00020B2\u0006\u0010P\u001a\u00020.2\u0006\u0010Q\u001a\u00020.J\u001e\u0010k\u001a\u00020,2\u0006\u0010m\u001a\u00020n2\u0006\u0010P\u001a\u00020.2\u0006\u0010Q\u001a\u00020.J\u000e\u0010k\u001a\u00020,2\u0006\u0010o\u001a\u00020pJ\u000e\u0010k\u001a\u00020,2\u0006\u0010q\u001a\u00020rJ\u0016\u0010s\u001a\u00020,2\u0006\u0010t\u001a\u00020[2\u0006\u0010u\u001a\u00020vJ\b\u0010w\u001a\u00020,H\u0002J\u000e\u0010x\u001a\u00020,2\u0006\u0010Z\u001a\u00020[J\u0006\u0010y\u001a\u00020,J\u0006\u0010z\u001a\u00020\u001cJ\b\u0010{\u001a\u00020,H\u0002J\u0006\u0010|\u001a\u00020\u001cR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR\u001e\u0010 \u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u000e\u001a\u0004\b%\u0010&R\u001e\u0010(\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006}"}, d2={"Lcom/pedro/library/base/StreamBase;", "", "context", "Landroid/content/Context;", "vSource", "Lcom/pedro/library/util/sources/video/VideoSource;", "aSource", "Lcom/pedro/library/util/sources/audio/AudioSource;", "(Landroid/content/Context;Lcom/pedro/library/util/sources/video/VideoSource;Lcom/pedro/library/util/sources/audio/AudioSource;)V", "audioEncoder", "Lcom/pedro/encoder/audio/AudioEncoder;", "getAudioEncoder", "()Lcom/pedro/encoder/audio/AudioEncoder;", "audioEncoder$delegate", "Lkotlin/Lazy;", "<set-?>", "audioSource", "getAudioSource", "()Lcom/pedro/library/util/sources/audio/AudioSource;", "getAacData", "Lcom/pedro/encoder/audio/GetAacData;", "getMicrophoneData", "com/pedro/library/base/StreamBase$getMicrophoneData$1", "Lcom/pedro/library/base/StreamBase$getMicrophoneData$1;", "getVideoData", "Lcom/pedro/encoder/video/GetVideoData;", "glInterface", "Lcom/pedro/library/view/GlStreamInterface;", "", "isOnPreview", "()Z", "isRecording", "isStreaming", "recordController", "Lcom/pedro/library/base/recording/BaseRecordController;", "videoEncoder", "Lcom/pedro/encoder/video/VideoEncoder;", "getVideoEncoder", "()Lcom/pedro/encoder/video/VideoEncoder;", "videoEncoder$delegate", "videoSource", "getVideoSource", "()Lcom/pedro/library/util/sources/video/VideoSource;", "audioInfo", "", "sampleRate", "", "isStereo", "changeAudioSource", "source", "changeVideoSource", "forceCodecType", "codecTypeVideo", "Lcom/pedro/encoder/utils/CodecUtil$CodecType;", "codecTypeAudio", "getAacDataRtp", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "getGlInterface", "getH264DataRtp", "h264Buffer", "getStreamClient", "Lcom/pedro/library/util/streamclient/StreamBaseClient;", "getSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "getVideoFps", "getVideoResolution", "Landroid/util/Size;", "onSpsPpsVpsRtp", "sps", "pps", "vps", "prepareAudio", "bitrate", "echoCanceler", "noiseSuppressor", "prepareEncoders", "prepareVideo", "width", "height", "fps", "iFrameInterval", "rotation", "profile", "level", "release", "requestKeyframe", "rtpStartStream", "endPoint", "", "rtpStopStream", "setAudioCodec", "codec", "Lcom/pedro/common/AudioCodec;", "setAudioCodecImp", "setEncoderErrorCallback", "encoderErrorCallback", "Lcom/pedro/encoder/EncoderErrorCallback;", "setOrientation", "orientation", "setRecordController", "setVideoBitrateOnFly", "setVideoCodec", "Lcom/pedro/common/VideoCodec;", "setVideoCodecImp", "startPreview", "surfaceTexture", "surface", "Landroid/view/Surface;", "surfaceView", "Landroid/view/SurfaceView;", "textureView", "Landroid/view/TextureView;", "startRecord", "path", "listener", "Lcom/pedro/library/base/recording/RecordController$Listener;", "startSources", "startStream", "stopPreview", "stopRecord", "stopSources", "stopStream", "library_release"})
@RequiresApi(value=21)
public abstract class StreamBase {
    @NotNull
    private final getMicrophoneData.1 getMicrophoneData;
    @NotNull
    private final Lazy videoEncoder$delegate;
    @NotNull
    private final Lazy audioEncoder$delegate;
    @NotNull
    private final GlStreamInterface glInterface;
    @NotNull
    private BaseRecordController recordController;
    private boolean isStreaming;
    private boolean isOnPreview;
    @NotNull
    private VideoSource videoSource;
    @NotNull
    private AudioSource audioSource;
    @NotNull
    private final GetAacData getAacData;
    @NotNull
    private final GetVideoData getVideoData;

    public StreamBase(@NotNull Context context, @NotNull VideoSource vSource, @NotNull AudioSource aSource) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)vSource, (String)"vSource");
        Intrinsics.checkNotNullParameter((Object)aSource, (String)"aSource");
        this.getMicrophoneData = new GetMicrophoneData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void inputPCMData(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                StreamBase.access$getAudioEncoder(this.this$0).inputPCMData(frame);
            }
        };
        this.videoEncoder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VideoEncoder>(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VideoEncoder invoke() {
                return new VideoEncoder(StreamBase.access$getGetVideoData$p(this.this$0));
            }
        }));
        this.audioEncoder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AudioEncoder>(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AudioEncoder invoke() {
                return new AudioEncoder(StreamBase.access$getGetAacData$p(this.this$0));
            }
        }));
        this.glInterface = new GlStreamInterface(context);
        this.recordController = new AndroidMuxerRecordController();
        this.videoSource = vSource;
        this.audioSource = aSource;
        this.getAacData = new GetAacData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void getAacData(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                this.this$0.getAacDataRtp(aacBuffer, info);
                StreamBase.access$getRecordController$p(this.this$0).recordAudio(aacBuffer, info);
            }

            public void onAudioFormat(@NotNull MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
                StreamBase.access$getRecordController$p(this.this$0).setAudioFormat(mediaFormat);
            }
        };
        this.getVideoData = new GetVideoData(this){
            final /* synthetic */ StreamBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSpsPpsVps(@NotNull ByteBuffer sps, @Nullable ByteBuffer pps, @Nullable ByteBuffer vps) {
                Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
                ByteBuffer byteBuffer = sps.duplicate();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
                ByteBuffer byteBuffer2 = pps;
                ByteBuffer byteBuffer3 = vps;
                this.this$0.onSpsPpsVpsRtp(byteBuffer, byteBuffer2 != null ? byteBuffer2.duplicate() : null, byteBuffer3 != null ? byteBuffer3.duplicate() : null);
            }

            public void getVideoData(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                this.this$0.getH264DataRtp(h264Buffer, info);
                StreamBase.access$getRecordController$p(this.this$0).recordVideo(h264Buffer, info);
            }

            public void onVideoFormat(@NotNull MediaFormat mediaFormat) {
                Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
                StreamBase.access$getRecordController$p(this.this$0).setVideoFormat(mediaFormat);
            }
        };
    }

    private final VideoEncoder getVideoEncoder() {
        Lazy lazy = this.videoEncoder$delegate;
        return (VideoEncoder)lazy.getValue();
    }

    private final AudioEncoder getAudioEncoder() {
        Lazy lazy = this.audioEncoder$delegate;
        return (AudioEncoder)lazy.getValue();
    }

    public final boolean isStreaming() {
        return this.isStreaming;
    }

    public final boolean isOnPreview() {
        return this.isOnPreview;
    }

    public final boolean isRecording() {
        return this.recordController.isRunning();
    }

    @NotNull
    public final VideoSource getVideoSource() {
        return this.videoSource;
    }

    @NotNull
    public final AudioSource getAudioSource() {
        return this.audioSource;
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation, int profile, int level) {
        if (this.isStreaming || this.isRecording() || this.isOnPreview) {
            throw new IllegalStateException("Stream, record and preview must be stopped before prepareVideo");
        }
        boolean videoResult = this.videoSource.create(width, height, fps);
        if (videoResult) {
            switch (rotation) {
                case 90: 
                case 270: {
                    this.glInterface.setEncoderSize(height, width);
                    break;
                }
                default: {
                    this.glInterface.setEncoderSize(width, height);
                }
            }
            return this.getVideoEncoder().prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, profile, level);
        }
        return false;
    }

    public static /* synthetic */ boolean prepareVideo$default(StreamBase streamBase, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareVideo");
        }
        if ((n9 & 8) != 0) {
            n4 = 30;
        }
        if ((n9 & 0x10) != 0) {
            n5 = 2;
        }
        if ((n9 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n9 & 0x40) != 0) {
            n7 = -1;
        }
        if ((n9 & 0x80) != 0) {
            n8 = -1;
        }
        return streamBase.prepareVideo(n, n2, n3, n4, n5, n6, n7, n8);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate, boolean echoCanceler, boolean noiseSuppressor) {
        if (this.isStreaming || this.isRecording()) {
            throw new IllegalStateException("Stream and record must be stopped before prepareAudio");
        }
        boolean audioResult = this.audioSource.create(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        if (audioResult) {
            this.audioInfo(sampleRate, isStereo);
            return this.getAudioEncoder().prepareAudioEncoder(bitrate, sampleRate, isStereo, this.audioSource.getMaxInputSize());
        }
        return false;
    }

    public static /* synthetic */ boolean prepareAudio$default(StreamBase streamBase, int n, boolean bl, int n2, boolean bl2, boolean bl3, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prepareAudio");
        }
        if ((n3 & 8) != 0) {
            bl2 = false;
        }
        if ((n3 & 0x10) != 0) {
            bl3 = false;
        }
        return streamBase.prepareAudio(n, bl, n2, bl2, bl3);
    }

    public final void startStream(@NotNull String endPoint) {
        Intrinsics.checkNotNullParameter((Object)endPoint, (String)"endPoint");
        if (this.isStreaming) {
            throw new IllegalStateException("Stream already started, stopStream before startStream again");
        }
        this.isStreaming = true;
        this.rtpStartStream(endPoint);
        if (!this.isRecording()) {
            this.startSources();
        } else {
            this.requestKeyframe();
        }
    }

    public final void requestKeyframe() {
        if (this.getVideoEncoder().isRunning()) {
            this.getVideoEncoder().requestKeyframe();
        }
    }

    public final void setVideoBitrateOnFly(int bitrate) {
        this.getVideoEncoder().setVideoBitrateOnFly(bitrate);
    }

    public final void forceCodecType(@NotNull CodecUtil.CodecType codecTypeVideo, @NotNull CodecUtil.CodecType codecTypeAudio) {
        Intrinsics.checkNotNullParameter((Object)codecTypeVideo, (String)"codecTypeVideo");
        Intrinsics.checkNotNullParameter((Object)codecTypeAudio, (String)"codecTypeAudio");
        this.getVideoEncoder().forceCodecType(codecTypeVideo);
        this.getAudioEncoder().forceCodecType(codecTypeAudio);
    }

    public final boolean stopStream() {
        this.isStreaming = false;
        this.rtpStopStream();
        if (!this.isRecording()) {
            this.stopSources();
            return this.prepareEncoders();
        }
        return true;
    }

    public final void startRecord(@NotNull String path, @NotNull RecordController.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (this.isRecording()) {
            throw new IllegalStateException("Record already started, stopRecord before startRecord again");
        }
        this.recordController.startRecord(path, listener);
        if (!this.isStreaming) {
            this.startSources();
        } else {
            this.getVideoEncoder().requestKeyframe();
        }
    }

    public final boolean stopRecord() {
        this.recordController.stopRecord();
        if (!this.isStreaming) {
            this.stopSources();
            return this.prepareEncoders();
        }
        return true;
    }

    public final void startPreview(@NotNull TextureView textureView) {
        Intrinsics.checkNotNullParameter((Object)textureView, (String)"textureView");
        this.startPreview(new Surface(textureView.getSurfaceTexture()), textureView.getWidth(), textureView.getHeight());
    }

    public final void startPreview(@NotNull SurfaceView surfaceView) {
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        Surface surface = surfaceView.getHolder().getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
        this.startPreview(surface, surfaceView.getWidth(), surfaceView.getHeight());
    }

    public final void startPreview(@NotNull SurfaceTexture surfaceTexture, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.startPreview(new Surface(surfaceTexture), width, height);
    }

    public final void startPreview(@NotNull Surface surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        if (!surface.isValid()) {
            throw new IllegalArgumentException("Make sure the Surface is valid");
        }
        if (this.isOnPreview) {
            throw new IllegalStateException("Preview already started, stopPreview before startPreview again");
        }
        this.isOnPreview = true;
        if (!this.glInterface.getRunning()) {
            this.glInterface.start();
        }
        if (!this.videoSource.isRunning()) {
            this.videoSource.start(this.glInterface.getSurfaceTexture());
        }
        this.glInterface.attachPreview(surface);
        this.glInterface.setPreviewResolution(width, height);
    }

    public final void stopPreview() {
        this.isOnPreview = false;
        if (!this.isStreaming && !this.isRecording()) {
            this.videoSource.stop();
        }
        this.glInterface.deAttachPreview();
        if (!this.isStreaming && !this.isRecording()) {
            this.glInterface.stop();
        }
    }

    public final void changeVideoSource(@NotNull VideoSource source) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            boolean wasRunning = this.videoSource.isRunning();
            boolean wasCreated = this.videoSource.getCreated();
            this.videoSource.stop();
            this.videoSource.release();
            SurfaceTexture surfaceTexture = this.videoSource.getSurfaceTexture();
            if (surfaceTexture == null) break block2;
            SurfaceTexture it = surfaceTexture;
            boolean bl = false;
            if (wasCreated) {
                source.create(this.videoSource.getWidth(), this.videoSource.getHeight(), this.videoSource.getFps());
            }
            if (wasRunning) {
                source.start(it);
            }
            this.videoSource = source;
        }
    }

    public final void changeAudioSource(@NotNull AudioSource source) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            boolean wasRunning = this.audioSource.isRunning();
            boolean wasCreated = this.audioSource.getCreated();
            this.audioSource.stop();
            this.audioSource.release();
            if (wasCreated) {
                source.create(this.audioSource.getSampleRate(), this.audioSource.isStereo(), this.audioSource.getEchoCanceler(), this.audioSource.getNoiseSuppressor());
            }
            if (wasRunning) {
                source.start(this.getMicrophoneData);
            }
            this.audioSource = source;
            SurfaceTexture surfaceTexture = this.videoSource.getSurfaceTexture();
            if (surfaceTexture == null) break block2;
            SurfaceTexture it = surfaceTexture;
            boolean bl = false;
        }
    }

    public final void setEncoderErrorCallback(@Nullable EncoderErrorCallback encoderErrorCallback) {
        this.getVideoEncoder().setEncoderErrorCallback(encoderErrorCallback);
        this.getAudioEncoder().setEncoderErrorCallback(encoderErrorCallback);
    }

    public final void setOrientation(int orientation) {
        this.glInterface.setCameraOrientation(orientation);
    }

    @NotNull
    public final GlStreamInterface getGlInterface() {
        return this.glInterface;
    }

    public final void setRecordController(@NotNull BaseRecordController recordController) {
        Intrinsics.checkNotNullParameter((Object)recordController, (String)"recordController");
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }

    @NotNull
    public final SurfaceTexture getSurfaceTexture() {
        if (!(this.videoSource instanceof NoVideoSource)) {
            throw new IllegalStateException("getSurfaceTexture only available with VideoManager.Source.DISABLED");
        }
        return this.glInterface.getSurfaceTexture();
    }

    @NotNull
    protected final Size getVideoResolution() {
        return new Size(this.getVideoEncoder().getWidth(), this.getVideoEncoder().getHeight());
    }

    protected final int getVideoFps() {
        return this.getVideoEncoder().getFps();
    }

    private final void startSources() {
        if (!this.glInterface.getRunning()) {
            this.glInterface.start();
        }
        if (!this.videoSource.isRunning()) {
            this.videoSource.start(this.glInterface.getSurfaceTexture());
        }
        this.audioSource.start(this.getMicrophoneData);
        this.getVideoEncoder().start();
        this.getAudioEncoder().start();
        Surface surface = this.getVideoEncoder().getInputSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getInputSurface(...)");
        this.glInterface.addMediaCodecSurface(surface);
    }

    private final void stopSources() {
        if (!this.isOnPreview) {
            this.videoSource.stop();
        }
        this.audioSource.stop();
        this.getVideoEncoder().stop();
        this.getAudioEncoder().stop();
        this.glInterface.removeMediaCodecSurface();
        if (!this.isOnPreview) {
            this.glInterface.stop();
        }
        if (!this.isRecording()) {
            this.recordController.resetFormats();
        }
    }

    public final void release() {
        if (this.isStreaming) {
            this.stopStream();
        }
        if (this.isRecording()) {
            this.stopRecord();
        }
        if (this.isOnPreview) {
            this.stopPreview();
        }
        this.stopSources();
        this.videoSource.release();
    }

    private final boolean prepareEncoders() {
        return this.getVideoEncoder().prepareVideoEncoder() && this.getAudioEncoder().prepareAudioEncoder();
    }

    protected abstract void audioInfo(int var1, boolean var2);

    protected abstract void rtpStartStream(@NotNull String var1);

    protected abstract void rtpStopStream();

    protected abstract void onSpsPpsVpsRtp(@NotNull ByteBuffer var1, @Nullable ByteBuffer var2, @Nullable ByteBuffer var3);

    protected abstract void getH264DataRtp(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    protected abstract void getAacDataRtp(@NotNull ByteBuffer var1, @NotNull MediaCodec.BufferInfo var2);

    @NotNull
    public abstract StreamBaseClient getStreamClient();

    public final void setVideoCodec(@NotNull VideoCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.setVideoCodecImp(codec);
        this.recordController.setVideoCodec(codec);
        String type = switch (WhenMappings.$EnumSwitchMapping$0[codec.ordinal()]) {
            case 1 -> "video/avc";
            case 2 -> "video/hevc";
            case 3 -> "video/av01";
            default -> throw new NoWhenBranchMatchedException();
        };
        this.getVideoEncoder().setType(type);
    }

    public final void setAudioCodec(@NotNull AudioCodec codec) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.setAudioCodecImp(codec);
        this.recordController.setAudioCodec(codec);
        this.getAudioEncoder().setType(codec == AudioCodec.G711 ? "audio/g711-alaw" : "audio/mp4a-latm");
    }

    protected abstract void setVideoCodecImp(@NotNull VideoCodec var1);

    protected abstract void setAudioCodecImp(@NotNull AudioCodec var1);

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation, int profile) {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, rotation, profile, 0, 128, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval, int rotation) {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, rotation, 0, 0, 192, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps, int iFrameInterval) {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, iFrameInterval, 0, 0, 0, 224, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate, int fps) {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, fps, 0, 0, 0, 0, 240, null);
    }

    @JvmOverloads
    public final boolean prepareVideo(int width, int height, int bitrate) {
        return StreamBase.prepareVideo$default(this, width, height, bitrate, 0, 0, 0, 0, 0, 248, null);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate, boolean echoCanceler) {
        return StreamBase.prepareAudio$default(this, sampleRate, isStereo, bitrate, echoCanceler, false, 16, null);
    }

    @JvmOverloads
    public final boolean prepareAudio(int sampleRate, boolean isStereo, int bitrate) {
        return StreamBase.prepareAudio$default(this, sampleRate, isStereo, bitrate, false, false, 24, null);
    }

    public static final /* synthetic */ AudioEncoder access$getAudioEncoder(StreamBase $this) {
        return $this.getAudioEncoder();
    }

    public static final /* synthetic */ GetVideoData access$getGetVideoData$p(StreamBase $this) {
        return $this.getVideoData;
    }

    public static final /* synthetic */ GetAacData access$getGetAacData$p(StreamBase $this) {
        return $this.getAacData;
    }

    public static final /* synthetic */ BaseRecordController access$getRecordController$p(StreamBase $this) {
        return $this.recordController;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoCodec.values().length];
            try {
                nArray[VideoCodec.H264.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.H265.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoCodec.AV1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

