/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.library.base;

import android.content.Context;
import android.graphics.Point;
import android.hardware.camera2.CameraCharacteristics;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.EncoderErrorCallback;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.CustomAudioEffect;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.input.audio.MicrophoneManagerManual;
import com.pedro.encoder.input.audio.MicrophoneMode;
import com.pedro.encoder.input.video.Camera2ApiManager;
import com.pedro.encoder.input.video.CameraCallbacks;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.encoder.input.video.CameraOpenException;
import com.pedro.encoder.input.video.facedetector.FaceDetectorCallback;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.library.base.recording.BaseRecordController;
import com.pedro.library.base.recording.RecordController;
import com.pedro.library.util.AndroidMuxerRecordController;
import com.pedro.library.util.FpsListener;
import com.pedro.library.view.GlInterface;
import com.pedro.library.view.LightOpenGlView;
import com.pedro.library.view.OffScreenGlThread;
import com.pedro.library.view.OpenGlView;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public abstract class Camera2Base {
    private static final String TAG = "Camera2Base";
    private final Context context;
    private Camera2ApiManager cameraManager;
    protected VideoEncoder videoEncoder;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private GlInterface glInterface;
    protected boolean audioInitialized = false;
    private boolean onPreview = false;
    private boolean isBackground = false;
    protected BaseRecordController recordController;
    private int previewWidth;
    private int previewHeight;
    private final FpsListener fpsListener = new FpsListener();
    private final GetMicrophoneData getMicrophoneData = frame -> this.audioEncoder.inputPCMData(frame);
    private final GetAacData getAacData = new GetAacData(){

        public void getAacData(@NonNull ByteBuffer aacBuffer, @NonNull MediaCodec.BufferInfo info) {
            Camera2Base.this.recordController.recordAudio(aacBuffer, info);
            if (Camera2Base.this.streaming) {
                Camera2Base.this.getAacDataRtp(aacBuffer, info);
            }
        }

        public void onAudioFormat(@NonNull MediaFormat mediaFormat) {
            Camera2Base.this.recordController.setAudioFormat(mediaFormat);
        }
    };
    private final GetVideoData getVideoData = new GetVideoData(){

        public void onSpsPpsVps(@NonNull ByteBuffer sps, @NonNull ByteBuffer pps, @Nullable ByteBuffer vps) {
            Camera2Base.this.onSpsPpsVpsRtp(sps.duplicate(), pps.duplicate(), vps != null ? vps.duplicate() : null);
        }

        public void getVideoData(@NonNull ByteBuffer h264Buffer, @NonNull MediaCodec.BufferInfo info) {
            Camera2Base.this.fpsListener.calculateFps();
            Camera2Base.this.recordController.recordVideo(h264Buffer, info);
            if (Camera2Base.this.streaming) {
                Camera2Base.this.getH264DataRtp(h264Buffer, info);
            }
        }

        public void onVideoFormat(@NonNull MediaFormat mediaFormat) {
            Camera2Base.this.recordController.setVideoFormat(mediaFormat, !Camera2Base.this.audioInitialized);
        }
    };

    @Deprecated
    public Camera2Base(SurfaceView surfaceView) {
        this.surfaceView = surfaceView;
        this.context = surfaceView.getContext();
        this.init(this.context);
    }

    @Deprecated
    public Camera2Base(TextureView textureView) {
        this.textureView = textureView;
        this.context = textureView.getContext();
        this.init(this.context);
    }

    public Camera2Base(OpenGlView openGlView) {
        this.context = openGlView.getContext();
        this.glInterface = openGlView;
        this.glInterface.init();
        this.init(this.context);
    }

    public Camera2Base(LightOpenGlView lightOpenGlView) {
        this.context = lightOpenGlView.getContext();
        this.glInterface = lightOpenGlView;
        this.glInterface.init();
        this.init(this.context);
    }

    public Camera2Base(Context context, boolean useOpengl) {
        this.context = context;
        if (useOpengl) {
            this.glInterface = new OffScreenGlThread(context);
            this.glInterface.init();
        }
        this.isBackground = true;
        this.init(context);
    }

    private void init(Context context) {
        this.cameraManager = new Camera2ApiManager(context);
        this.videoEncoder = new VideoEncoder(this.getVideoData);
        this.setMicrophoneMode(MicrophoneMode.ASYNC);
        this.recordController = new AndroidMuxerRecordController();
    }

    public void setMicrophoneMode(MicrophoneMode microphoneMode) {
        switch (microphoneMode) {
            case SYNC: {
                this.microphoneManager = new MicrophoneManagerManual();
                this.audioEncoder = new AudioEncoder(this.getAacData);
                this.audioEncoder.setGetFrame(((MicrophoneManagerManual)this.microphoneManager).getGetFrame());
                this.audioEncoder.setTsModeBuffer(false);
                break;
            }
            case ASYNC: {
                this.microphoneManager = new MicrophoneManager(this.getMicrophoneData);
                this.audioEncoder = new AudioEncoder(this.getAacData);
                this.audioEncoder.setTsModeBuffer(false);
                break;
            }
            case BUFFER: {
                this.microphoneManager = new MicrophoneManager(this.getMicrophoneData);
                this.audioEncoder = new AudioEncoder(this.getAacData);
                this.audioEncoder.setTsModeBuffer(true);
            }
        }
    }

    public void setCameraCallbacks(CameraCallbacks callbacks) {
        this.cameraManager.setCameraCallbacks(callbacks);
    }

    public void setEncoderErrorCallback(EncoderErrorCallback encoderErrorCallback) {
        this.videoEncoder.setEncoderErrorCallback(encoderErrorCallback);
        this.audioEncoder.setEncoderErrorCallback(encoderErrorCallback);
    }

    public void setCustomAudioEffect(CustomAudioEffect customAudioEffect) {
        this.microphoneManager.setCustomAudioEffect(customAudioEffect);
    }

    public void setFpsListener(FpsListener.Callback callback2) {
        this.fpsListener.setCallback(callback2);
    }

    public boolean enableFaceDetection(FaceDetectorCallback faceDetectorCallback) {
        return this.cameraManager.enableFaceDetection(faceDetectorCallback);
    }

    public void disableFaceDetection() {
        this.cameraManager.disableFaceDetection();
    }

    public boolean isFaceDetectionEnabled() {
        return this.cameraManager.isFaceDetectionEnabled();
    }

    public boolean enableVideoStabilization() {
        return this.cameraManager.enableVideoStabilization();
    }

    public void disableVideoStabilization() {
        this.cameraManager.disableVideoStabilization();
    }

    public boolean isVideoStabilizationEnabled() {
        return this.cameraManager.isVideoStabilizationEnabled();
    }

    public boolean enableOpticalVideoStabilization() {
        return this.cameraManager.enableOpticalVideoStabilization();
    }

    public void disableOpticalVideoStabilization() {
        this.cameraManager.disableOpticalVideoStabilization();
    }

    public boolean isOpticalVideoStabilizationEnabled() {
        return this.cameraManager.isOpticalStabilizationEnabled();
    }

    @Deprecated
    public boolean isFrontCamera() {
        return this.cameraManager.getCameraFacing() == CameraHelper.Facing.FRONT;
    }

    public CameraHelper.Facing getCameraFacing() {
        return this.cameraManager.getCameraFacing();
    }

    public void enableLantern() throws Exception {
        this.cameraManager.enableLantern();
    }

    public void disableLantern() {
        this.cameraManager.disableLantern();
    }

    public boolean isLanternEnabled() {
        return this.cameraManager.isLanternEnabled();
    }

    public boolean isLanternSupported() {
        return this.cameraManager.isLanternSupported();
    }

    public void enableAutoFocus() {
        this.cameraManager.enableAutoFocus();
    }

    public void disableAutoFocus() {
        this.cameraManager.disableAutoFocus();
    }

    public boolean isAutoFocusEnabled() {
        return this.cameraManager.isAutoFocusEnabled();
    }

    public void setFocusDistance(float distance) {
        this.cameraManager.setFocusDistance(distance);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation, int avcProfile, int avcProfileLevel) {
        if (this.onPreview && this.glInterface != null && (width != this.previewWidth || height != this.previewHeight || fps != this.videoEncoder.getFps() || rotation != this.videoEncoder.getRotation())) {
            this.stopPreview();
            this.onPreview = true;
        }
        boolean result = this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, iFrameInterval, FormatVideoEncoder.SURFACE, avcProfile, avcProfileLevel);
        this.prepareCameraManager();
        return result;
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int iFrameInterval, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, iFrameInterval, rotation, -1, -1);
    }

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation) {
        return this.prepareVideo(width, height, fps, bitrate, 2, rotation);
    }

    public boolean prepareVideo(int width, int height, int bitrate) {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(width, height, 30, bitrate, 2, rotation);
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int audioSource, int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        if (!this.microphoneManager.createMicrophone(audioSource, sampleRate, isStereo, echoCanceler, noiseSuppressor)) {
            return false;
        }
        this.prepareAudioRtp(isStereo, sampleRate);
        this.audioInitialized = this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo, this.microphoneManager.getMaxInputSize());
        return this.audioInitialized;
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        return this.prepareAudio(0, bitrate, sampleRate, isStereo, echoCanceler, noiseSuppressor);
    }

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo) {
        return this.prepareAudio(bitrate, sampleRate, isStereo, false, false);
    }

    public boolean prepareVideo() {
        int rotation = CameraHelper.getCameraOrientation((Context)this.context);
        return this.prepareVideo(640, 480, 30, 1228800, rotation);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(@NonNull String path, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(path, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    public void startRecord(@NonNull String path) throws IOException {
        this.startRecord(path, null);
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd, @Nullable RecordController.Listener listener) throws IOException {
        this.recordController.startRecord(fd, listener);
        if (!this.streaming) {
            this.startEncoders();
        } else if (this.videoEncoder.isRunning()) {
            this.requestKeyFrame();
        }
    }

    @RequiresApi(api=26)
    public void startRecord(@NonNull FileDescriptor fd) throws IOException {
        this.startRecord(fd, null);
    }

    public void stopRecord() {
        this.recordController.stopRecord();
        if (!this.streaming) {
            this.stopStream();
        }
    }

    public void replaceView(Context context) {
        this.isBackground = true;
        this.replaceGlInterface(new OffScreenGlThread(context));
    }

    public void replaceView(OpenGlView openGlView) {
        this.isBackground = false;
        this.replaceGlInterface(openGlView);
    }

    public void replaceView(LightOpenGlView lightOpenGlView) {
        this.isBackground = false;
        this.replaceGlInterface(lightOpenGlView);
    }

    private void replaceGlInterface(GlInterface glInterface) {
        if (this.glInterface != null && Build.VERSION.SDK_INT >= 18) {
            if (this.isStreaming() || this.isRecording() || this.isOnPreview()) {
                Point size = this.glInterface.getEncoderSize();
                this.cameraManager.closeCamera();
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
                this.glInterface = glInterface;
                this.glInterface.init();
                this.glInterface.setEncoderSize(size.x, size.y);
                this.glInterface.setRotation(this.videoEncoder.getRotation() == 0 ? 270 : this.videoEncoder.getRotation() - 90);
                this.glInterface.start();
                if (this.isStreaming() || this.isRecording()) {
                    this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
                }
                this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps());
                this.cameraManager.openLastCamera();
            } else {
                this.glInterface = glInterface;
                this.glInterface.init();
            }
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int fps, int rotation) {
        this.startPreview(this.cameraManager.getCameraIdForFacing(cameraFacing), width, height, fps, rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height, int rotation) {
        this.startPreview(cameraFacing, width, height, this.videoEncoder.getFps(), rotation);
    }

    public void startPreview(String cameraId, int width, int height, int rotation) {
        this.startPreview(cameraId, width, height, this.videoEncoder.getFps(), rotation);
    }

    public void startPreview(String cameraId, int width, int height, int fps, int rotation) {
        if (!(this.isStreaming() || this.onPreview || this.isBackground)) {
            this.previewWidth = width;
            this.previewHeight = height;
            this.videoEncoder.setFps(fps);
            this.videoEncoder.setRotation(rotation);
            if (this.surfaceView != null) {
                this.cameraManager.prepareCamera(this.surfaceView.getHolder().getSurface(), this.videoEncoder.getFps());
            } else if (this.textureView != null) {
                this.cameraManager.prepareCamera(new Surface(this.textureView.getSurfaceTexture()), this.videoEncoder.getFps());
            } else if (this.glInterface != null) {
                if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                    this.glInterface.setEncoderSize(height, width);
                } else {
                    this.glInterface.setEncoderSize(width, height);
                }
                this.glInterface.setRotation(rotation == 0 ? 270 : rotation - 90);
                this.glInterface.setFps(this.videoEncoder.getFps());
                this.glInterface.start();
                this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), width, height, this.videoEncoder.getFps(), cameraId);
            }
            this.cameraManager.openCameraId(cameraId);
            this.onPreview = true;
        } else if (!this.isStreaming() && !this.onPreview && this.isBackground) {
            this.cameraManager.setCameraId(cameraId);
        } else {
            Log.e((String)TAG, (String)"Streaming or preview started, ignored");
        }
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int width, int height) {
        this.startPreview(this.cameraManager.getCameraIdForFacing(cameraFacing), width, height, CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview(String cameraId, int width, int height) {
        this.startPreview(cameraId, width, height, CameraHelper.getCameraOrientation((Context)this.context));
    }

    public void startPreview(String cameraId, int rotation) {
        this.startPreview(cameraId, this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), rotation);
    }

    public void startPreview(CameraHelper.Facing cameraFacing, int rotation) {
        this.startPreview(this.cameraManager.getCameraIdForFacing(cameraFacing), this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), rotation);
    }

    public void startPreview(String cameraId) {
        this.startPreview(cameraId, this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
    }

    public void startPreview(CameraHelper.Facing cameraFacing) {
        this.startPreview(this.cameraManager.getCameraIdForFacing(cameraFacing), this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
    }

    public void startPreview(int width, int height) {
        this.startPreview(this.getCameraFacing(), width, height);
    }

    public void startPreview() {
        this.startPreview(this.getCameraFacing());
    }

    public void stopPreview() {
        if (!this.isStreaming() && !this.isRecording() && this.onPreview && !this.isBackground) {
            if (this.glInterface != null) {
                this.glInterface.stop();
            }
            this.cameraManager.closeCamera();
            this.onPreview = false;
            this.previewWidth = 0;
            this.previewHeight = 0;
        } else {
            Log.e((String)TAG, (String)"Streaming or preview stopped, ignored");
        }
    }

    public void startStreamAndRecord(String url, String path, RecordController.Listener listener) throws IOException {
        this.startStream(url);
        this.recordController.startRecord(path, listener);
    }

    public void startStreamAndRecord(String url, String path) throws IOException {
        this.startStreamAndRecord(url, path, null);
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recordController.isRunning()) {
            this.startEncoders();
        } else {
            this.requestKeyFrame();
        }
        this.startStreamRtp(url);
        this.onPreview = true;
    }

    private void startEncoders() {
        this.videoEncoder.start();
        if (this.audioInitialized) {
            this.audioEncoder.start();
        }
        this.prepareGlView();
        if (this.audioInitialized) {
            this.microphoneManager.start();
        }
        if (this.glInterface == null && !this.cameraManager.isRunning() && this.videoEncoder.getWidth() != this.previewWidth || this.videoEncoder.getHeight() != this.previewHeight) {
            this.cameraManager.openLastCamera();
        }
        this.onPreview = true;
    }

    public void requestKeyFrame() {
        if (this.videoEncoder.isRunning()) {
            this.videoEncoder.requestKeyframe();
        }
    }

    private void prepareGlView() {
        if (this.glInterface != null) {
            this.glInterface.setFps(this.videoEncoder.getFps());
            if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
                this.glInterface.setEncoderSize(this.videoEncoder.getHeight(), this.videoEncoder.getWidth());
            } else {
                this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
            }
            int rotation = this.videoEncoder.getRotation();
            this.glInterface.setRotation(rotation == 0 ? 270 : rotation - 90);
            if (!this.cameraManager.isRunning() && this.videoEncoder.getWidth() != this.previewWidth || this.videoEncoder.getHeight() != this.previewHeight) {
                this.glInterface.start();
            }
            if (this.videoEncoder.getInputSurface() != null) {
                this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
            }
            this.cameraManager.prepareCamera(this.glInterface.getSurfaceTexture(), this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.videoEncoder.getFps());
        }
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recordController.isRecording()) {
            boolean bl = this.onPreview = !this.isBackground;
            if (this.audioInitialized) {
                this.microphoneManager.stop();
            }
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                if (this.glInterface instanceof OffScreenGlThread) {
                    this.glInterface.stop();
                    this.cameraManager.closeCamera();
                }
            } else if (this.isBackground) {
                this.cameraManager.closeCamera();
                this.onPreview = false;
            } else {
                this.cameraManager.stopRepeatingEncoder();
            }
            this.videoEncoder.stop();
            if (this.audioInitialized) {
                this.audioEncoder.stop();
            }
            this.recordController.resetFormats();
        }
    }

    public List<Size> getResolutionsBack() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsBack());
    }

    public List<Size> getResolutionsFront() {
        return Arrays.asList(this.cameraManager.getCameraResolutionsFront());
    }

    public List<Range<Integer>> getSupportedFps() {
        return this.cameraManager.getSupportedFps(null, CameraHelper.Facing.BACK);
    }

    public List<Range<Integer>> getSupportedFps(Size size, CameraHelper.Facing facing) {
        return this.cameraManager.getSupportedFps(size, facing);
    }

    public CameraCharacteristics getCameraCharacteristics() {
        return this.cameraManager.getCameraCharacteristics();
    }

    public void setAudioMaxInputSize(int size) {
        this.microphoneManager.setMaxInputSize(size);
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public Range<Float> getZoomRange() {
        return this.cameraManager.getZoomRange();
    }

    public float getZoom() {
        return this.cameraManager.getZoom().floatValue();
    }

    public void setZoom(float level) {
        this.cameraManager.setZoom(level);
    }

    public void setZoom(MotionEvent event) {
        this.cameraManager.setZoom(event);
    }

    public float[] getOpticalZooms() {
        return this.cameraManager.getOpticalZooms();
    }

    public void setOpticalZoom(float level) {
        this.cameraManager.setOpticalZoom(level);
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public String[] getCamerasAvailable() {
        return this.cameraManager.getCamerasAvailable();
    }

    public void switchCamera() throws CameraOpenException {
        if (this.isStreaming() || this.isRecording() || this.onPreview) {
            this.cameraManager.switchCamera();
        } else {
            this.cameraManager.setCameraFacing(this.getCameraFacing() == CameraHelper.Facing.FRONT ? CameraHelper.Facing.BACK : CameraHelper.Facing.FRONT);
        }
    }

    public void switchCamera(String cameraId) throws CameraOpenException {
        if (this.isStreaming() || this.onPreview) {
            this.cameraManager.reOpenCamera(cameraId);
        } else {
            this.cameraManager.setCameraId(cameraId);
        }
    }

    public void setExposure(int value) {
        this.cameraManager.setExposure(value);
    }

    public int getExposure() {
        return this.cameraManager.getExposure();
    }

    public int getMaxExposure() {
        return this.cameraManager.getMaxExposure();
    }

    public int getMinExposure() {
        return this.cameraManager.getMinExposure();
    }

    public void tapToFocus(MotionEvent event) {
        this.cameraManager.tapToFocus(event);
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    private void prepareCameraManager() {
        if (this.textureView != null) {
            this.cameraManager.prepareCamera(this.textureView, this.videoEncoder.getInputSurface(), this.videoEncoder.getFps());
        } else if (this.surfaceView != null) {
            this.cameraManager.prepareCamera(this.surfaceView, this.videoEncoder.getInputSurface(), this.videoEncoder.getFps());
        } else if (this.glInterface == null) {
            this.cameraManager.prepareCamera(this.videoEncoder.getInputSurface(), this.videoEncoder.getFps());
        }
    }

    public void setVideoBitrateOnFly(int bitrate) {
        this.videoEncoder.setVideoBitrateOnFly(bitrate);
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recordController.isRunning();
    }

    public void pauseRecord() {
        this.recordController.pauseRecord();
    }

    public void resumeRecord() {
        this.recordController.resumeRecord();
    }

    public RecordController.Status getRecordStatus() {
        return this.recordController.getStatus();
    }

    public void addImageListener(int width, int height, int format, int maxImages, Camera2ApiManager.ImageCallback listener) {
        this.cameraManager.addImageListener(width, height, format, maxImages, true, listener);
    }

    public void addImageListener(int width, int height, int format, int maxImages, boolean autoClose, Camera2ApiManager.ImageCallback listener) {
        this.cameraManager.addImageListener(width, height, format, maxImages, autoClose, listener);
    }

    public void addImageListener(int format, int maxImages, Camera2ApiManager.ImageCallback listener) {
        if (this.videoEncoder.getRotation() == 90 || this.videoEncoder.getRotation() == 270) {
            this.addImageListener(this.videoEncoder.getHeight(), this.videoEncoder.getWidth(), format, maxImages, listener);
        } else {
            this.addImageListener(this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), format, maxImages, listener);
        }
    }

    public void removeImageListener() {
        this.cameraManager.removeImageListener();
    }

    public boolean isOnPreview() {
        return this.onPreview;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void setRecordController(BaseRecordController recordController) {
        if (!this.isRecording()) {
            this.recordController = recordController;
        }
    }
}

