/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.utils.gl;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.util.Log;
import com.pedro.encoder.utils.gl.StreamObjectBase;

public class TextStreamObject
extends StreamObjectBase {
    private static final String TAG = "TextStreamObject";
    private int numFrames;
    private Bitmap imageBitmap;

    @Override
    public int getWidth() {
        return this.imageBitmap != null ? this.imageBitmap.getWidth() : 0;
    }

    @Override
    public int getHeight() {
        return this.imageBitmap != null ? this.imageBitmap.getHeight() : 0;
    }

    public void load(String text, float textSize, int textColor, Typeface typeface) {
        this.numFrames = 1;
        this.imageBitmap = this.textAsBitmap(text, textSize, textColor, typeface);
        Log.i((String)TAG, (String)"finish load text");
    }

    @Override
    public void recycle() {
        if (this.imageBitmap != null) {
            this.imageBitmap.recycle();
        }
    }

    private Bitmap textAsBitmap(String text, float textSize, int textColor, Typeface typeface) {
        Paint paint = new Paint(1);
        paint.setTextSize(textSize);
        paint.setColor(textColor);
        paint.setAlpha(255);
        if (typeface != null) {
            paint.setTypeface(typeface);
        }
        paint.setTextAlign(Paint.Align.LEFT);
        float baseline = -paint.ascent();
        int width = (int)(paint.measureText(text) + 0.5f);
        int height = (int)(baseline + paint.descent() + 0.5f);
        Bitmap image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(image);
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        canvas.drawText(text, 0.0f, baseline, paint);
        return image;
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    @Override
    public Bitmap[] getBitmaps() {
        return new Bitmap[]{this.imageBitmap};
    }

    @Override
    public int updateFrame() {
        return 0;
    }
}

