/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.encoder.input.decoder;

import android.media.MediaExtractor;
import android.util.Log;
import com.pedro.encoder.Frame;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.decoder.AudioDecoderInterface;
import com.pedro.encoder.input.decoder.BaseDecoder;
import com.pedro.encoder.input.decoder.LoopFileInterface;
import com.pedro.encoder.utils.PCMUtil;
import java.nio.ByteBuffer;

public class AudioDecoder
extends BaseDecoder {
    private AudioDecoderInterface audioDecoderInterface;
    private GetMicrophoneData getMicrophoneData;
    private int sampleRate;
    private boolean isStereo;
    private int channels = 1;
    private int size = 2048;
    private byte[] pcmBuffer = new byte[this.size];
    private byte[] pcmBufferMuted = new byte[11];
    private boolean muted = false;

    public AudioDecoder(GetMicrophoneData getMicrophoneData, AudioDecoderInterface audioDecoderInterface, LoopFileInterface loopFileInterface) {
        super(loopFileInterface);
        this.getMicrophoneData = getMicrophoneData;
        this.audioDecoderInterface = audioDecoderInterface;
    }

    @Override
    protected boolean extract(MediaExtractor audioExtractor) {
        this.size = 2048;
        this.running = false;
        for (int i = 0; i < audioExtractor.getTrackCount() && !this.mime.startsWith("audio/"); ++i) {
            this.mediaFormat = audioExtractor.getTrackFormat(i);
            this.mime = this.mediaFormat.getString("mime");
            if (this.mime.startsWith("audio/")) {
                audioExtractor.selectTrack(i);
                continue;
            }
            this.mediaFormat = null;
        }
        if (this.mediaFormat != null) {
            this.channels = this.mediaFormat.getInteger("channel-count");
            this.isStereo = this.channels >= 2;
            this.sampleRate = this.mediaFormat.getInteger("sample-rate");
            this.duration = this.mediaFormat.getLong("durationUs");
            this.fixBuffer();
            return true;
        }
        this.mime = "";
        this.mediaFormat = null;
        return false;
    }

    private void fixBuffer() {
        if (this.channels >= 2) {
            this.size *= this.channels;
        }
        this.pcmBuffer = new byte[this.size];
    }

    public boolean prepareAudio() {
        return this.prepare(null);
    }

    public void reset() {
        this.resetCodec(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode() {
        ByteBuffer[] inputBuffers = this.codec.getInputBuffers();
        ByteBuffer[] outputBuffers = this.codec.getOutputBuffers();
        this.startMs = System.currentTimeMillis();
        while (this.running) {
            Object object = this.lock;
            synchronized (object) {
                int inIndex = this.codec.dequeueInputBuffer(10000L);
                if (inIndex >= 0) {
                    ByteBuffer buffer = inputBuffers[inIndex];
                    int sampleSize = this.extractor.readSampleData(buffer, 0);
                    if (sampleSize < 0) {
                        this.codec.queueInputBuffer(inIndex, 0, 0, 0L, 4);
                    } else {
                        this.codec.queueInputBuffer(inIndex, 0, sampleSize, this.extractor.getSampleTime(), 0);
                        this.extractor.advance();
                    }
                    int outIndex = this.codec.dequeueOutputBuffer(this.bufferInfo, 10000L);
                    switch (outIndex) {
                        case -3: {
                            outputBuffers = this.codec.getOutputBuffers();
                            break;
                        }
                        case -2: 
                        case -1: {
                            break;
                        }
                        default: {
                            while (this.extractor.getSampleTime() / 1000L > System.currentTimeMillis() - this.startMs + this.seekTime) {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    return;
                                }
                            }
                            ByteBuffer outBuffer = outputBuffers[outIndex];
                            if (this.muted) {
                                outBuffer.get(this.pcmBufferMuted, 0, Math.min(outBuffer.remaining(), this.pcmBufferMuted.length));
                                this.getMicrophoneData.inputPCMData(new Frame(this.pcmBufferMuted, 0, this.pcmBufferMuted.length));
                            } else {
                                if (this.pcmBuffer.length < outBuffer.remaining()) {
                                    this.pcmBuffer = new byte[outBuffer.remaining()];
                                }
                                outBuffer.get(this.pcmBuffer, 0, Math.min(outBuffer.remaining(), this.pcmBuffer.length));
                                if (this.channels > 2) {
                                    byte[] bufferStereo = PCMUtil.pcmToStereo(this.pcmBuffer, this.channels);
                                    this.getMicrophoneData.inputPCMData(new Frame(bufferStereo, 0, bufferStereo.length));
                                } else {
                                    this.getMicrophoneData.inputPCMData(new Frame(this.pcmBuffer, 0, this.pcmBuffer.length));
                                }
                            }
                            this.codec.releaseOutputBuffer(outIndex, false);
                        }
                    }
                }
                if ((this.bufferInfo.flags & 4) != 0) {
                    this.seekTime = 0L;
                    Log.i((String)"BaseDecoder", (String)"end of file out");
                    if (this.loopMode) {
                        this.loopFileInterface.onReset(false);
                    } else {
                        this.audioDecoderInterface.onAudioDecoderFinished();
                    }
                }
            }
        }
    }

    public int getOutsize() {
        if (!(this.mime.equals("audio/mp4a-latm") || this.mime.equals("audio/opus") || this.mime.equals("audio/ogg"))) {
            Log.i((String)"BaseDecoder", (String)"fixing input size");
            try {
                if (this.running) {
                    return this.codec.getOutputBuffers()[0].remaining();
                }
                if (this.codec != null) {
                    this.codec.start();
                    int outSize = this.codec.getOutputBuffers()[0].remaining();
                    this.stopDecoder();
                    if (this.prepare(null)) {
                        return outSize;
                    }
                }
                return 0;
            }
            catch (Exception e) {
                return 0;
            }
        }
        Log.i((String)"BaseDecoder", (String)"default input size");
        return 0;
    }

    public void mute() {
        this.muted = true;
    }

    public void unMute() {
        this.muted = false;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isStereo() {
        return this.isStereo;
    }
}

