/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.util.WindowsRegistry;

public final class MailSender {
    private static final Logger logger = Logger.getLogger(MailSender.class.toString());

    private MailSender() {
    }

    private static void sendMailMailto(String string, String string2, Controller controller) {
        Frame frame = controller.getViewerFrame();
        ResourceBundle resourceBundle = controller.getMessageBundle();
        String string3 = "mailto:?attachment=" + string2;
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
                URI uRI = new URI(string3.replace(" ", "%20"));
                Desktop.getDesktop().mail(uRI);
            } else {
                String[] stringArray;
                Process process;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (string.contains("win")) {
                    arrayList.add("cmd.exe");
                    arrayList.add("/c");
                    arrayList.add("start");
                    arrayList.add(string3.replace(" ", "%20"));
                } else if (string.contains("osx")) {
                    arrayList.add("open");
                    arrayList.add(string3.replace(" ", "%20"));
                } else if (string.contains("nix") || string.contains("aix") || string.contains("nux")) {
                    arrayList.add("bash");
                    arrayList.add("-c");
                    arrayList.add("xdg-open " + string3.replace(" ", "%20"));
                } else {
                    logger.warning("Unsupported os : " + string);
                    MailSender.showErrorMessage(resourceBundle, frame, "unsupported");
                }
                if (!arrayList.isEmpty() && (process = new ProcessBuilder(stringArray = arrayList.toArray(new String[0])).start()).exitValue() != 0) {
                    MailSender.showErrorMessage(resourceBundle, frame, "error");
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            logger.log(Level.WARNING, "Error using " + string3, exception);
            MailSender.showErrorMessage(resourceBundle, frame, "error");
        }
    }

    private static void showErrorMessage(ResourceBundle resourceBundle, Component component, String string) {
        JOptionPane.showMessageDialog(component, resourceBundle.getString("viewer.dialog.sendmail." + string + ".msg"), resourceBundle.getString("viewer.dialog.sendmail." + string + ".title"), 0);
    }

    public static void sendMail(Controller controller) {
        String[] stringArray;
        Frame frame = controller.getViewerFrame();
        ResourceBundle resourceBundle = controller.getMessageBundle();
        Document document = controller.getDocument();
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = document.getDocumentLocation();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string.contains("win")) {
            try {
                stringArray = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Clients\\Mail";
                String[] stringArray2 = WindowsRegistry.readRegistry((String)stringArray, "");
                if (stringArray2[10].toLowerCase().contains("thunderbird")) {
                    String string3 = (String)stringArray + "\\Mozilla Thunderbird\\shell\\open\\command";
                    String[] stringArray3 = WindowsRegistry.readRegistry(string3, "");
                    arrayList.add(stringArray3[10]);
                    arrayList.add(stringArray3[11]);
                    arrayList.add("/compose");
                    arrayList.add("attachment='" + string2 + "'");
                } else if (stringArray2[10].toLowerCase().contains("outlook")) {
                    String string4 = (String)stringArray + "\\Microsoft Outlook\\shell\\open\\command";
                    String[] stringArray4 = WindowsRegistry.readRegistry(string4, "");
                    arrayList.add(stringArray4[10]);
                    arrayList.add("/a");
                    arrayList.add(string2);
                }
            }
            catch (Exception exception) {}
        } else if (string.contains("nix") || string.contains("aix") || string.contains("nux")) {
            try {
                stringArray = new String[]{"xdg-mime", "query", "default", "x-scheme-handler/mailto"};
                Process process = new ProcessBuilder(stringArray).start();
                Scanner scanner = new Scanner(process.getInputStream());
                String string5 = scanner.nextLine();
                if (string5.toLowerCase().contains("thunderbird")) {
                    arrayList.add("thunderbird");
                    arrayList.add("-compose");
                    arrayList.add("attachment='" + string2 + "'");
                }
                scanner.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (arrayList.isEmpty()) {
            MailSender.sendMailMailto(string, string2, controller);
        } else {
            try {
                stringArray = new ProcessBuilder(arrayList.toArray(new String[0])).start();
                stringArray.waitFor(1L, TimeUnit.SECONDS);
                if (!stringArray.isAlive() && stringArray.exitValue() != 0) {
                    MailSender.sendMailMailto(string, string2, controller);
                }
            }
            catch (IOException | InterruptedException exception) {
                MailSender.sendMailMailto(string, string2, controller);
            }
        }
    }
}

