/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.scratch;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TreeTransferHandler
extends TransferHandler {
    DataFlavor nodesFlavor;
    DataFlavor[] flavors = new DataFlavor[1];
    DefaultMutableTreeNode[] nodesToRemove;

    public TreeTransferHandler() {
        try {
            String string = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
            this.flavors[0] = this.nodesFlavor = new DataFlavor(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFound: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            return false;
        }
        transferSupport.setShowDropLocation(true);
        if (!transferSupport.isDataFlavorSupported(this.nodesFlavor)) {
            return false;
        }
        JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
        JTree jTree = (JTree)transferSupport.getComponent();
        int n = jTree.getRowForPath(dropLocation.getPath());
        int[] nArray = jTree.getSelectionRows();
        for (int n2 : Objects.requireNonNull(nArray)) {
            if (n2 == n) {
                return false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getPathForRow(n2).getLastPathComponent();
            for (TreeNode treeNode : Collections.list(defaultMutableTreeNode.depthFirstEnumeration())) {
                if (jTree.getRowForPath(new TreePath(((DefaultMutableTreeNode)treeNode).getPath())) != n) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        ArrayList<DefaultMutableTreeNode> arrayList2 = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
        LinkedHashSet<TreeNode> linkedHashSet = new LinkedHashSet<TreeNode>(treePathArray.length);
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.copy(defaultMutableTreeNode, linkedHashSet, jTree);
        arrayList.add(defaultMutableTreeNode2);
        arrayList2.add(defaultMutableTreeNode);
        for (int i = 1; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            if (linkedHashSet.contains(defaultMutableTreeNode3)) continue;
            if (defaultMutableTreeNode3.getLevel() < defaultMutableTreeNode.getLevel()) break;
            if (defaultMutableTreeNode3.getLevel() > defaultMutableTreeNode.getLevel()) {
                defaultMutableTreeNode2.add(this.copy(defaultMutableTreeNode3, linkedHashSet, jTree));
            } else {
                arrayList.add(this.copy(defaultMutableTreeNode3, linkedHashSet, jTree));
                arrayList2.add(defaultMutableTreeNode3);
            }
            linkedHashSet.add(defaultMutableTreeNode3);
        }
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = arrayList.toArray(new DefaultMutableTreeNode[0]);
        this.nodesToRemove = arrayList2.toArray(new DefaultMutableTreeNode[0]);
        return new NodesTransferable(defaultMutableTreeNodeArray);
    }

    private DefaultMutableTreeNode copy(DefaultMutableTreeNode defaultMutableTreeNode, HashSet<TreeNode> hashSet, JTree jTree) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(defaultMutableTreeNode);
        hashSet.add(defaultMutableTreeNode);
        for (n = 0; n < defaultMutableTreeNode.getChildCount(); ++n) {
            defaultMutableTreeNode2.add(this.copy((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n), hashSet, jTree));
        }
        n = jTree.getRowForPath(new TreePath(defaultMutableTreeNode2.getPath()));
        jTree.expandRow(n);
        return defaultMutableTreeNode2;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if ((n & 2) == 2) {
            JTree jTree = (JTree)jComponent;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
            for (DefaultMutableTreeNode defaultMutableTreeNode : this.nodesToRemove) {
                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
            }
        }
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Object object;
        if (!this.canImport(transferSupport)) {
            return false;
        }
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = null;
        try {
            object = transferSupport.getTransferable();
            defaultMutableTreeNodeArray = (DefaultMutableTreeNode[])object.getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.out.println("UnsupportedFlavor: " + unsupportedFlavorException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("I/O error: " + iOException.getMessage());
        }
        object = (JTree.DropLocation)transferSupport.getDropLocation();
        int n = ((JTree.DropLocation)object).getChildIndex();
        TreePath treePath = ((JTree.DropLocation)object).getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        JTree jTree = (JTree)transferSupport.getComponent();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        int n2 = n;
        if (n == -1) {
            n2 = defaultMutableTreeNode.getChildCount();
        }
        for (int i = 0; i < Objects.requireNonNull(defaultMutableTreeNodeArray).length; ++i) {
            defaultTreeModel.insertNodeInto(defaultMutableTreeNodeArray[i], defaultMutableTreeNode, n2++);
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public class NodesTransferable
    implements Transferable {
        DefaultMutableTreeNode[] nodes;

        public NodesTransferable(DefaultMutableTreeNode[] defaultMutableTreeNodeArray) {
            this.nodes = defaultMutableTreeNodeArray;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return TreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return TreeTransferHandler.this.nodesFlavor.equals(dataFlavor);
        }
    }
}

