/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class RgbColorChooser {
    private static final Logger logger = Logger.getLogger(RgbColorChooser.class.toString());

    public static Color showDialog(Component component, String string, Color color) throws HeadlessException {
        JColorChooser jColorChooser = new JColorChooser(color != null ? color : Color.white);
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = jColorChooser.getChooserPanels();
        for (AbstractColorChooserPanel object : abstractColorChooserPanelArray) {
            String string2;
            switch (string2 = object.getDisplayName()) {
                case "HSV": 
                case "CMYK": 
                case "HSL": {
                    jColorChooser.removeChooserPanel(object);
                }
            }
        }
        ColorTracker colorTracker = new ColorTracker(jColorChooser);
        ActionListener actionListener = actionEvent -> colorTracker.setColor(null);
        JDialog jDialog = JColorChooser.createDialog(component, string, true, jColorChooser, colorTracker, actionListener);
        jDialog.setLocationByPlatform(true);
        jDialog.setVisible(true);
        try {
            String exception = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(exception);
        }
        catch (Exception exception) {
            logger.warning("Could not set " + UIManager.getSystemLookAndFeelClassName());
        }
        return colorTracker.getColor();
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        private final JColorChooser chooser;
        private Color color;

        ColorTracker(JColorChooser jColorChooser) {
            this.chooser = jColorChooser;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.color = this.chooser.getColor();
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

