/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.widgets;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.AbstractButton;

public class PaintButtonBase {
    protected Color color = Color.YELLOW;
    protected Shape colorBound;
    protected float alpha = 0.35f;
    protected final float alphaDisabled = 0.1f;
    protected final AbstractButton button;
    protected boolean fill = true;
    protected boolean back = true;

    public PaintButtonBase(AbstractButton abstractButton) {
        this.button = abstractButton;
    }

    public PaintButtonBase(AbstractButton abstractButton, Color color, Shape shape, float f) {
        this.button = abstractButton;
        this.color = color;
        this.colorBound = shape;
        this.alpha = f;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColorBound(Shape shape) {
        this.colorBound = shape;
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public Color getColor() {
        return this.color;
    }

    public Shape getColorBound() {
        return this.colorBound;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setFill(boolean bl) {
        this.fill = bl;
    }

    public void setBack(boolean bl) {
        this.back = bl;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Composite composite = graphics2D.getComposite();
        if (this.button == null || this.button.isEnabled()) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
        } else {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
        }
        if (this.color != null) {
            graphics2D.setColor(this.color);
        }
        if (this.colorBound != null && this.fill) {
            graphics2D.fill(this.colorBound);
        } else if (this.colorBound != null) {
            graphics2D.draw(this.colorBound);
        }
        graphics2D.setComposite(composite);
    }
}

