/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.icepdf.ri.common.ListItemTransferHandler;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.ColorChooserButton;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class DragDropColorList
extends JList<ColorLabel> {
    private final DefaultListModel<ColorLabel> model;
    private final Preferences preferences;

    public DragDropColorList(Controller controller, Preferences preferences) {
        super(new DefaultListModel());
        this.preferences = preferences;
        this.model = (DefaultListModel)this.getModel();
        this.addPropertyChangeListener("annotationPropertyPanelChange", controller);
        this.setSelectionMode(0);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        ListItemTransferHandler listItemTransferHandler = new ListItemTransferHandler(){

            @Override
            protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
                super.exportDone(jComponent, transferable, n);
                ArrayList<ColorLabel> arrayList = new ArrayList<ColorLabel>();
                int n2 = DragDropColorList.this.model.getSize();
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(DragDropColorList.this.model.get(i));
                }
                DragDropColorList.this.storeColorLabels(arrayList);
            }
        };
        this.setTransferHandler(listItemTransferHandler);
        this.setCellRenderer(new ListCellRenderer<ColorLabel>(){
            private final JPanel panel = new JPanel(new BorderLayout(3, 3));
            private final ColorChooserButton colorButton = new ColorChooserButton(Color.lightGray);
            private final JLabel label = new JLabel("", 2);

            @Override
            public Component getListCellRendererComponent(JList<? extends ColorLabel> jList, ColorLabel colorLabel, int n, boolean bl, boolean bl2) {
                ColorChooserButton.setButtonBackgroundColor(colorLabel.color, this.colorButton);
                this.label.setText(colorLabel.label);
                this.label.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
                this.panel.add((Component)this.colorButton, "West");
                this.panel.add((Component)this.label, "Center");
                this.panel.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
                return this.panel;
            }
        });
        ArrayList<ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
        for (ColorLabel colorLabel : arrayList) {
            this.model.addElement(colorLabel);
        }
    }

    public void addNamedColor(Color color, String string) {
        string = this.cleanLabel(string);
        this.model.addElement(new ColorLabel(color, string));
        Object object = this.preferences.get("application.viewer.preference.annotation.recent.color.labels", "");
        object = ((String)object).length() == 0 ? color.getRGB() + "|" + string : (String)object + "|" + color.getRGB() + "|" + string;
        this.preferences.put("application.viewer.preference.annotation.recent.color.labels", (String)object);
    }

    public void updateNamedColor(Color color, String string) {
        int n = this.getSelectedIndex();
        string = this.cleanLabel(string);
        ColorLabel colorLabel = new ColorLabel(color, string);
        this.model.set(n, colorLabel);
        ArrayList<ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
        arrayList.set(n, colorLabel);
        this.storeColorLabels(arrayList);
    }

    private String cleanLabel(String string) {
        String string2 = string = string.isEmpty() ? " " : string;
        if (string.contains("|")) {
            string = string.replace("|", " ");
        }
        return string;
    }

    public void removeSelectedNamedColor() {
        int n = this.getSelectedIndex();
        this.model.removeElementAt(n);
        if (n > 0) {
            this.setSelectedIndex(n - 1);
        }
        ArrayList<ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
        arrayList.remove(n);
        this.storeColorLabels(arrayList);
    }

    public static ArrayList<ColorLabel> retrieveColorLabels() {
        String string = ViewerPropertiesManager.getInstance().getPreferences().get("application.viewer.preference.annotation.recent.color.labels", "");
        ArrayList<ColorLabel> arrayList = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            arrayList = new ArrayList<ColorLabel>();
            while (stringTokenizer.hasMoreTokens()) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                String string2 = stringTokenizer.nextToken();
                arrayList.add(new ColorLabel(new Color(n), string2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            ViewerPropertiesManager.getInstance().getPreferences().put("application.viewer.preference.annotation.recent.color.labels", "");
        }
        return arrayList;
    }

    private void storeColorLabels(ArrayList<ColorLabel> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = arrayList.size();
        int n2 = 0;
        for (ColorLabel colorLabel : arrayList) {
            stringBuilder.append(colorLabel.getColor().getRGB()).append("|").append(colorLabel.getLabel());
            if (++n2 == n) continue;
            stringBuilder.append("|");
        }
        this.preferences.put("application.viewer.preference.annotation.recent.color.labels", stringBuilder.toString());
        this.firePropertyChange("annotationPropertyPanelChange", null, (Object)true);
    }

    public static class ColorLabel
    implements Serializable {
        private final Color color;
        private final String label;

        ColorLabel(Color color, String string) {
            this.color = color;
            this.label = string;
        }

        public Color getColor() {
            return this.color;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

