/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.listeners;

import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.icepdf.core.events.PageImageEvent;
import org.icepdf.core.events.PageInitializingEvent;
import org.icepdf.core.events.PageLoadingEvent;
import org.icepdf.core.events.PagePaintingEvent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.listeners.PageViewLoadingListener;

public class DefaultPageViewLoadingListener
extends PageViewLoadingListener {
    private final JComponent pageComponent;
    private DocumentViewController documentViewController;
    private final Cursor previousCursor;

    public DefaultPageViewLoadingListener(JComponent jComponent, DocumentViewController documentViewController) {
        this.pageComponent = jComponent;
        this.previousCursor = this.pageComponent.getCursor();
        this.documentViewController = documentViewController;
    }

    @Override
    public void setDocumentViewController(DocumentViewController documentViewController) {
        this.documentViewController = documentViewController;
    }

    public void pageLoadingStarted(PageLoadingEvent pageLoadingEvent) {
        SwingUtilities.invokeLater(() -> {
            if (this.documentViewController != null) {
                this.pageComponent.setCursor(this.documentViewController.getViewCursor(6));
            }
        });
    }

    public void pageInitializationStarted(PageInitializingEvent pageInitializingEvent) {
        SwingUtilities.invokeLater(() -> {
            if (this.documentViewController != null) {
                this.pageComponent.setCursor(this.documentViewController.getViewCursor(6));
            }
        });
    }

    public void pagePaintingStarted(PagePaintingEvent pagePaintingEvent) {
        SwingUtilities.invokeLater(() -> {
            if (this.documentViewController != null) {
                this.pageComponent.setCursor(this.documentViewController.getViewCursor(6));
            }
        });
    }

    public void pageInitializationEnded(PageInitializingEvent pageInitializingEvent) {
        SwingUtilities.invokeLater(() -> this.pageComponent.setCursor(null));
    }

    public void pageImageLoaded(PageImageEvent pageImageEvent) {
        super.pageImageLoaded(pageImageEvent);
    }

    public void pagePaintingEnded(PagePaintingEvent pagePaintingEvent) {
        SwingUtilities.invokeLater(() -> this.pageComponent.setCursor(this.previousCursor));
    }

    public void pageLoadingEnded(PageLoadingEvent pageLoadingEvent) {
        SwingUtilities.invokeLater(() -> this.pageComponent.setCursor(null));
    }
}

