/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.summary;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.utility.annotation.properties.FontWidgetUtilities;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.summary.ColorLabelPanel;
import org.icepdf.ri.common.widgets.DragDropColorList;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class AnnotationSummaryPanel
extends JPanel
implements MutableDocument,
PropertyChangeListener,
MouseListener,
ComponentListener,
ItemListener {
    protected final Frame frame;
    protected final Controller controller;
    protected final ResourceBundle messageBundle;
    protected MarkupAnnotation lastSelectedMarkupAnnotation;
    protected final GridBagConstraints constraints;
    protected JPanel annotationsPanel;
    private JComboBox<ValueLabelItem> fontNameBox;
    private JComboBox<ValueLabelItem> fontSizeBox;
    protected JPanel statusToolbarPanel;
    private static final int DEFAULT_FONT_SIZE = 5;
    private static final int DEFAULT_FONT_FAMILY = 0;
    protected ArrayList<ColorLabelPanel> annotationNamedColorPanels;

    public AnnotationSummaryPanel(Frame frame, Controller controller) {
        this.frame = frame;
        this.controller = controller;
        this.messageBundle = controller.getMessageBundle();
        this.setLayout(new BorderLayout());
        this.setAlignmentY(0.0f);
        this.setFocusable(true);
        this.constraints = new GridBagConstraints();
        this.buildStatusToolBarPanel();
        ((DocumentViewControllerImpl)controller.getDocumentViewController()).addPropertyChangeListener(this);
        this.addComponentListener(this);
        this.addFontSizeBindings();
    }

    @Override
    public void refreshDocumentInstance() {
        if (this.controller.getDocument() != null) {
            int n;
            Document document = this.controller.getDocument();
            ArrayList<DragDropColorList.ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
            int n2 = n = arrayList != null ? arrayList.size() : 1;
            if (this.annotationNamedColorPanels != null) {
                this.annotationNamedColorPanels.clear();
            }
            this.annotationNamedColorPanels = new ArrayList(n);
            if (arrayList != null && arrayList.size() > 0) {
                for (DragDropColorList.ColorLabel colorLabel : arrayList) {
                    ColorLabelPanel colorLabelPanel = new ColorLabelPanel(this.frame, this.controller, colorLabel);
                    colorLabelPanel.addPropertyChangeListener("annotationSummaryBoxFontSizeChange", colorLabelPanel);
                    this.annotationNamedColorPanels.add(colorLabelPanel);
                    colorLabelPanel.addMouseListener(this);
                    int n3 = document.getNumberOfPages();
                    for (int i = 0; i < n3; ++i) {
                        List list = document.getPageTree().getPage(i).getAnnotations();
                        if (list == null) continue;
                        for (Annotation annotation : list) {
                            if (!(annotation instanceof MarkupAnnotation) || !colorLabel.getColor().equals(annotation.getColor())) continue;
                            colorLabelPanel.addAnnotation((MarkupAnnotation)annotation);
                        }
                    }
                }
            } else {
                ColorLabelPanel colorLabelPanel = new ColorLabelPanel(this.frame, this.controller, null);
                colorLabelPanel.addPropertyChangeListener("annotationSummaryBoxFontSizeChange", colorLabelPanel);
                this.annotationNamedColorPanels.add(colorLabelPanel);
                int n4 = document.getNumberOfPages();
                for (int i = 0; i < n4; ++i) {
                    List list = document.getPageTree().getPage(i).getAnnotations();
                    if (list == null) continue;
                    for (Annotation annotation : list) {
                        if (!(annotation instanceof MarkupAnnotation)) continue;
                        colorLabelPanel.addAnnotation((MarkupAnnotation)annotation);
                    }
                }
            }
        }
        this.refreshPanelLayout();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.fontSizeBox) {
            ViewerPropertiesManager viewerPropertiesManager = this.controller.getPropertiesManager();
            viewerPropertiesManager.getPreferences().putInt("application.viewer.annotation.summary.font.size", (Integer)((ValueLabelItem)this.fontSizeBox.getModel().getElementAt(this.fontSizeBox.getSelectedIndex())).getValue());
            ValueLabelItem valueLabelItem = (ValueLabelItem)this.fontSizeBox.getSelectedItem();
            this.updateSummaryFontSizes(0, (Integer)valueLabelItem.getValue());
        }
    }

    private void updateSummaryFontSizes(int n, int n2) {
        if (this.annotationNamedColorPanels != null) {
            for (ColorLabelPanel colorLabelPanel : this.annotationNamedColorPanels) {
                colorLabelPanel.firePropertyChange("annotationSummaryBoxFontSizeChange", n, n2);
            }
        }
    }

    private void addFontSizeBindings() {
        InputMap inputMap = this.getInputMap(0);
        ActionMap actionMap = this.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(61, 128);
        inputMap.put(keyStroke, "font-size-increase");
        actionMap.put("font-size-increase", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AnnotationSummaryPanel.this.fontSizeBox.getSelectedIndex() + 1 < AnnotationSummaryPanel.this.fontSizeBox.getItemCount()) {
                    AnnotationSummaryPanel.this.fontSizeBox.setSelectedIndex(AnnotationSummaryPanel.this.fontSizeBox.getSelectedIndex() + 1);
                }
            }
        });
        keyStroke = KeyStroke.getKeyStroke(48, 128);
        inputMap.put(keyStroke, "font-size-default");
        actionMap.put("font-size-default", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationSummaryPanel.this.fontSizeBox.setSelectedIndex(5);
            }
        });
        keyStroke = KeyStroke.getKeyStroke(45, 128);
        inputMap.put(keyStroke, "font-size-decrease");
        actionMap.put("font-size-decrease", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AnnotationSummaryPanel.this.fontSizeBox.getSelectedIndex() - 1 >= 0) {
                    AnnotationSummaryPanel.this.fontSizeBox.setSelectedIndex(AnnotationSummaryPanel.this.fontSizeBox.getSelectedIndex() - 1);
                }
            }
        });
    }

    protected void buildStatusToolBarPanel() {
        ViewerPropertiesManager viewerPropertiesManager = this.controller.getPropertiesManager();
        this.fontSizeBox = new JComboBox<ValueLabelItem>(FontWidgetUtilities.generateFontSizeNameList(this.messageBundle));
        this.applySelectedValue(this.fontSizeBox, viewerPropertiesManager.checkAndStoreIntProperty("application.viewer.annotation.summary.font.size", new JLabel().getFont().getSize()));
        this.fontSizeBox.addItemListener(this);
        this.statusToolbarPanel = new JPanel(new GridBagLayout());
        this.statusToolbarPanel.setAlignmentY(0.0f);
        this.constraints.fill = 0;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(5, 5, 5, 0);
        this.addGB(this.statusToolbarPanel, new JLabel(this.messageBundle.getString("viewer.annotationSummary.fontSize.label")), 0, 0, 1, 1);
        this.addGB(this.statusToolbarPanel, this.fontSizeBox, 1, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.addGB(this.statusToolbarPanel, new JLabel(), 2, 0, 1, 1);
    }

    public void refreshPanelLayout() {
        this.removeAll();
        this.annotationsPanel = new JPanel(new GridBagLayout());
        this.annotationsPanel.setAlignmentY(0.0f);
        this.add((Component)this.annotationsPanel, "Center");
        this.add((Component)this.statusToolbarPanel, "South");
        ArrayList<DragDropColorList.ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
        int n = arrayList != null && arrayList.size() > 0 ? arrayList.size() : 1;
        this.constraints.weightx = 1.0 / (double)n;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(0, 5, 0, 0);
        this.constraints.fill = 1;
        int n2 = 0;
        for (ColorLabelPanel colorLabelPanel : this.annotationNamedColorPanels) {
            if (colorLabelPanel.getNumberOfComponents() <= 0) continue;
            this.addGB(this.annotationsPanel, colorLabelPanel, ++n2, 0, 1, 1);
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        block9 : switch (string = propertyChangeEvent.getPropertyName()) {
            case "annotationDeleted": {
                if (!(object2 instanceof MarkupAnnotationComponent)) break;
                MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)object2;
                MarkupAnnotation markupAnnotation = (MarkupAnnotation)markupAnnotationComponent.getAnnotation();
                if (this.annotationNamedColorPanels == null) break;
                ArrayList<DragDropColorList.ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
                if (arrayList != null) {
                    for (ColorLabelPanel colorLabelPanel : this.annotationNamedColorPanels) {
                        if (colorLabelPanel.getColorLabel() == null || !colorLabelPanel.getColorLabel().getColor().equals(markupAnnotation.getColor())) continue;
                        colorLabelPanel.removeAnnotation(markupAnnotation);
                        this.refreshPanelLayout();
                        break block9;
                    }
                    break;
                }
                ColorLabelPanel colorLabelPanel = this.annotationNamedColorPanels.get(0);
                colorLabelPanel.removeAnnotation(markupAnnotation);
                this.refreshPanelLayout();
                break;
            }
            case "annotationUpdated": {
                PopupAnnotationComponent popupAnnotationComponent;
                MarkupAnnotation markupAnnotation;
                if (!(object instanceof PopupAnnotationComponent) || this.annotationNamedColorPanels == null || (markupAnnotation = ((PopupAnnotation)(popupAnnotationComponent = (PopupAnnotationComponent)object).getAnnotation()).getParent()) == null) break;
                ArrayList<DragDropColorList.ColorLabel> colorLabelPanel = DragDropColorList.retrieveColorLabels();
                if (colorLabelPanel != null) {
                    for (ColorLabelPanel colorLabelPanel2 : this.annotationNamedColorPanels) {
                        if (colorLabelPanel2.getColorLabel() == null || !colorLabelPanel2.getColorLabel().getColor().equals(markupAnnotation.getColor())) continue;
                        colorLabelPanel2.updateAnnotation(markupAnnotation);
                        break block9;
                    }
                    break;
                }
                ColorLabelPanel colorLabelPanel2 = this.annotationNamedColorPanels.get(0);
                colorLabelPanel2.updateAnnotation(markupAnnotation);
                break;
            }
            case "annotationAdded": {
                PopupAnnotationComponent popupAnnotationComponent;
                MarkupAnnotation markupAnnotation;
                if (!(object instanceof PopupAnnotationComponent) || this.annotationNamedColorPanels == null || (markupAnnotation = ((PopupAnnotation)(popupAnnotationComponent = (PopupAnnotationComponent)object).getAnnotation()).getParent()) == null) break;
                ArrayList<DragDropColorList.ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
                if (arrayList != null) {
                    for (ColorLabelPanel colorLabelPanel : this.annotationNamedColorPanels) {
                        if (colorLabelPanel.getColorLabel() == null || !colorLabelPanel.getColorLabel().getColor().equals(markupAnnotation.getColor())) continue;
                        colorLabelPanel.addAnnotation(markupAnnotation);
                        this.refreshPanelLayout();
                        break block9;
                    }
                    break;
                }
                ColorLabelPanel colorLabelPanel = this.annotationNamedColorPanels.get(0);
                colorLabelPanel.addAnnotation(markupAnnotation);
                this.refreshPanelLayout();
                break;
            }
            case "annotationQuikcColorPropertyChange": {
                if (this.lastSelectedMarkupAnnotation == null || this.annotationNamedColorPanels == null) break;
                for (ColorLabelPanel object32 : this.annotationNamedColorPanels) {
                    object32.removeAnnotation(this.lastSelectedMarkupAnnotation);
                    this.refreshPanelLayout();
                }
                ArrayList<DragDropColorList.ColorLabel> arrayList = DragDropColorList.retrieveColorLabels();
                if (arrayList != null) {
                    for (ColorLabelPanel colorLabelPanel : this.annotationNamedColorPanels) {
                        if (!colorLabelPanel.getColorLabel().getColor().equals(this.lastSelectedMarkupAnnotation.getColor())) continue;
                        colorLabelPanel.addAnnotation(this.lastSelectedMarkupAnnotation);
                        this.refreshPanelLayout();
                        break block9;
                    }
                    break;
                }
                ColorLabelPanel colorLabelPanel = this.annotationNamedColorPanels.get(0);
                colorLabelPanel.addAnnotation(this.lastSelectedMarkupAnnotation);
                this.refreshPanelLayout();
                break;
            }
            case "annotationPropertyPanelChange": {
                this.refreshDocumentInstance();
                break;
            }
            case "annotationSelected": 
            case "annotationFocusGained": {
                if (!(object instanceof MarkupAnnotationComponent)) break;
                this.lastSelectedMarkupAnnotation = (MarkupAnnotation)((MarkupAnnotationComponent)object).getAnnotation();
            }
        }
    }

    private void applySelectedValue(JComboBox jComboBox, Object object) {
        jComboBox.removeItemListener(this);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)jComboBox.getItemAt(i);
            if (!valueLabelItem.getValue().equals(object)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        jComboBox.addItemListener(this);
    }

    @Override
    public void disposeDocument() {
        this.annotationNamedColorPanels.clear();
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            Component component = (Component)mouseEvent.getSource();
            if (this.annotationNamedColorPanels != null) {
                double d = 1.0 / (double)this.annotationNamedColorPanels.size();
                GridBagLayout gridBagLayout = (GridBagLayout)this.annotationsPanel.getLayout();
                for (ColorLabelPanel colorLabelPanel : this.annotationNamedColorPanels) {
                    GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(colorLabelPanel);
                    gridBagConstraints.weightx = colorLabelPanel.equals(component) ? 0.9 : d;
                    gridBagLayout.setConstraints(colorLabelPanel, gridBagConstraints);
                    colorLabelPanel.invalidate();
                }
                this.revalidate();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.annotationNamedColorPanels != null) {
            double d = 1.0 / (double)this.annotationNamedColorPanels.size();
            GridBagLayout gridBagLayout = (GridBagLayout)this.annotationsPanel.getLayout();
            for (ColorLabelPanel colorLabelPanel : this.annotationNamedColorPanels) {
                GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(colorLabelPanel);
                gridBagConstraints.weightx = d;
                gridBagLayout.setConstraints(colorLabelPanel, gridBagConstraints);
            }
            this.invalidate();
            this.revalidate();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

