/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.signature.appearance.SignatureAppearanceCallback;
import org.icepdf.core.pobjects.acroform.signature.appearance.SignatureAppearanceModel;
import org.icepdf.core.pobjects.acroform.signature.appearance.SignatureType;
import org.icepdf.core.pobjects.acroform.signature.handlers.SignerHandler;
import org.icepdf.core.pobjects.acroform.signature.utils.SignatureUtilities;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SignatureManager;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.utility.annotation.properties.FontWidgetUtilities;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.annotations.acroform.SignatureComponent;
import org.icepdf.ri.common.views.annotations.signing.CertificateTableModel;
import org.icepdf.ri.common.views.annotations.signing.PasswordDialogCallbackHandler;
import org.icepdf.ri.common.views.annotations.signing.PkcsSignerFactory;
import org.icepdf.ri.common.views.annotations.signing.SignatureAppearanceModelImpl;

public class SignatureCreationDialog
extends EscapeJDialog
implements ActionListener,
ListSelectionListener,
ItemListener,
FocusListener,
ChangeListener {
    private static final Logger logger = Logger.getLogger(SignatureCreationDialog.class.toString());
    private static final Locale[] supportedLocales = new Locale[]{new Locale("da"), new Locale("de"), new Locale("en"), new Locale("es"), new Locale("fi"), new Locale("fr"), new Locale("it"), new Locale("nl"), new Locale("no"), new Locale("pt"), new Locale("sv")};
    private GridBagConstraints constraints;
    private JTable certificateTable;
    private JRadioButton signerRadioButton;
    private JRadioButton certifyRadioButton;
    private JCheckBox signerVisibilityCheckBox;
    private JTextField locationTextField;
    private JTextField nameTextField;
    private JTextField contactTextField;
    private JComboBox<ValueLabelItem> fontNameBox;
    private JComboBox<ValueLabelItem> fontSizeBox;
    private JCheckBox showTextCheckBox;
    private JCheckBox showSignatureCheckBox;
    private JTextField imagePathTextField;
    private JButton imagePathBrowseButton;
    private JSlider imageScaleSlider;
    private JComboBox<Locale> languagesComboBox;
    private JButton signButton;
    private JButton closeButton;
    private SignerHandler signerHandler;
    private final SignatureAppearanceCallback signatureAppearanceCallback;
    private final SignatureAppearanceModelImpl signatureAppearanceModel;
    protected static ResourceBundle messageBundle;
    protected final SignatureComponent signatureWidgetComponent;
    protected final SignatureWidgetAnnotation signatureWidgetAnnotation;

    public SignatureCreationDialog(Controller controller, ResourceBundle resourceBundle, SignatureComponent signatureComponent) throws KeyStoreException {
        super(controller.getViewerFrame(), true);
        messageBundle = resourceBundle;
        this.signatureWidgetComponent = signatureComponent;
        this.signatureWidgetAnnotation = (SignatureWidgetAnnotation)signatureComponent.getAnnotation();
        this.signatureAppearanceCallback = controller.getDocumentViewController().getSignatureAppearanceCallback();
        this.signatureAppearanceModel = new SignatureAppearanceModelImpl(((SignatureWidgetAnnotation)signatureComponent.getAnnotation()).getLibrary());
        this.signatureAppearanceModel.setSelectedCertificate(false);
        this.signatureAppearanceCallback.setSignatureAppearanceModel((SignatureAppearanceModel)this.signatureAppearanceModel);
        this.signatureWidgetAnnotation.setAppearanceCallback(this.signatureAppearanceCallback);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SignatureCreationDialog.this.cancelOrCloseSignatureCleanup();
            }
        });
        this.buildUI();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.signButton) {
            SignatureDictionary signatureDictionary;
            Library library = this.signatureWidgetAnnotation.getLibrary();
            SignatureManager signatureManager = library.getSignatureDictionaries();
            if (this.signerRadioButton.isSelected()) {
                signatureDictionary = SignatureDictionary.getInstance((SignatureWidgetAnnotation)this.signatureWidgetAnnotation, (SignatureType)SignatureType.SIGNER);
            } else {
                if (signatureManager.hasExistingCertifier(library)) {
                    JOptionPane.showMessageDialog(this, messageBundle.getString("viewer.annotation.signature.creation.dialog.certify.error.msg"), messageBundle.getString("viewer.annotation.signature.creation.dialog.certify.error.title"), 0);
                    return;
                }
                signatureDictionary = SignatureDictionary.getInstance((SignatureWidgetAnnotation)this.signatureWidgetAnnotation, (SignatureType)SignatureType.CERTIFIER);
            }
            signatureDictionary.setSignerHandler(this.signerHandler);
            signatureManager.addSignature(signatureDictionary, this.signatureWidgetAnnotation);
            signatureDictionary.setName(this.nameTextField.getText());
            signatureDictionary.setContactInfo(this.contactTextField.getText());
            signatureDictionary.setLocation(this.locationTextField.getText());
            signatureDictionary.setReason(this.signerRadioButton.isSelected() ? SignatureType.SIGNER.toString().toLowerCase() : SignatureType.CERTIFIER.toString().toLowerCase());
            this.buildAppearanceStream();
            this.setVisible(false);
            this.dispose();
        } else if (object == this.closeButton) {
            this.cancelOrCloseSignatureCleanup();
            this.setVisible(false);
            this.dispose();
        } else if (object == this.imagePathTextField) {
            this.setSignatureImage();
            this.buildAppearanceStream();
        } else if (object == this.signerRadioButton) {
            this.signatureAppearanceModel.setSignatureType(SignatureType.SIGNER);
            this.buildAppearanceStream();
        } else if (object == this.certifyRadioButton) {
            this.signatureAppearanceModel.setSignatureType(SignatureType.CERTIFIER);
            this.buildAppearanceStream();
        } else if (object == this.signerVisibilityCheckBox) {
            this.signatureAppearanceModel.setSignatureVisible(this.signerVisibilityCheckBox.isSelected());
            this.buildAppearanceStream();
        } else if (object == this.showTextCheckBox) {
            this.signatureAppearanceModel.setSignatureTextVisible(this.showTextCheckBox.isSelected());
            this.buildAppearanceStream();
        } else if (object == this.showSignatureCheckBox) {
            this.signatureAppearanceModel.setSignatureImageVisible(this.showSignatureCheckBox.isSelected());
            this.buildAppearanceStream();
        } else if (object == this.imagePathBrowseButton) {
            String string = this.signatureAppearanceModel.getSignatureImagePath();
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle(messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.selection.title"));
            int n = jFileChooser.showDialog(this, messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.selection.accept.label"));
            if (n == 0) {
                this.imagePathTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                this.setSignatureImage();
                this.buildAppearanceStream();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        if (itemEvent.getSource() == this.fontSizeBox) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)this.fontSizeBox.getSelectedItem();
            if (valueLabelItem != null) {
                int n = (Integer)valueLabelItem.getValue();
                this.signatureAppearanceModel.setFontSize(n);
                this.buildAppearanceStream();
            }
        } else if (itemEvent.getSource() == this.fontNameBox) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)this.fontNameBox.getSelectedItem();
            if (valueLabelItem != null) {
                String string = valueLabelItem.getValue().toString();
                this.signatureAppearanceModel.setFontName(string);
                this.buildAppearanceStream();
            }
        } else if (itemEvent.getSource() == this.languagesComboBox) {
            this.signatureAppearanceModel.setLocale((Locale)this.languagesComboBox.getSelectedItem());
            this.buildAppearanceStream();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            int n = jSlider.getValue();
            this.signatureAppearanceModel.setImageScale(n);
            this.buildAppearanceStream();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.certificateTable.convertRowIndexToModel(this.certificateTable.getSelectedRow());
        CertificateTableModel certificateTableModel = (CertificateTableModel)this.certificateTable.getModel();
        this.signerHandler.setCertAlias(certificateTableModel.getAliasAt(n));
        this.setSelectedCertificate(certificateTableModel.getCertificateAt(n));
        this.buildAppearanceStream();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        boolean bl = false;
        if (object == this.locationTextField) {
            this.signatureAppearanceModel.setLocation(this.locationTextField.getText());
            bl = true;
        } else if (object == this.contactTextField) {
            this.signatureAppearanceModel.setContact(this.contactTextField.getText());
            bl = true;
        } else if (object == this.nameTextField) {
            this.signatureAppearanceModel.setName(this.nameTextField.getText());
            bl = true;
        } else if (object == this.imagePathTextField) {
            this.setSignatureImage();
            bl = true;
        }
        if (bl) {
            this.buildAppearanceStream();
        }
    }

    private void cancelOrCloseSignatureCleanup() {
        this.signatureAppearanceCallback.removeAppearanceStream(this.signatureWidgetAnnotation, new AffineTransform(), true);
        this.signatureWidgetAnnotation.setAppearanceCallback(null);
    }

    private void updateModelAppearanceState() {
        this.signatureAppearanceModel.setLocation(this.locationTextField.getText());
        this.signatureAppearanceModel.setContact(this.contactTextField.getText());
        this.signatureAppearanceModel.setName(this.nameTextField.getText());
        this.signatureAppearanceModel.setSignatureType(this.signerRadioButton.isSelected() ? SignatureType.SIGNER : SignatureType.CERTIFIER);
        this.signatureAppearanceModel.setFontName(Objects.requireNonNull(this.fontNameBox.getSelectedItem()).toString());
        this.signatureAppearanceModel.setFontSize((Integer)((ValueLabelItem)Objects.requireNonNull(this.fontSizeBox.getSelectedItem())).getValue());
        this.signatureAppearanceModel.setSignatureImagePath(this.imagePathTextField.getText());
        this.signatureAppearanceModel.setImageScale(this.imageScaleSlider.getValue());
        this.setSignatureImage();
    }

    private void setSignatureImage() {
        this.signatureAppearanceModel.setSignatureImagePath(this.imagePathTextField.getText());
    }

    private void buildAppearanceStream() {
        this.signatureWidgetAnnotation.resetAppearanceStream(new AffineTransform());
        this.signatureWidgetComponent.repaint();
    }

    private void setSelectedCertificate(X509Certificate x509Certificate) {
        this.signatureAppearanceModel.setSelectedCertificate(x509Certificate != null);
        if (x509Certificate == null) {
            this.nameTextField.setText("");
            this.contactTextField.setText("");
            this.locationTextField.setText("");
            this.enableInputComponents(false);
            this.signerHandler.setCertAlias(null);
        } else {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            X500Name x500Name = new X500Name(x500Principal.getName());
            this.enableInputComponents(true);
            if (x500Name.getRDNs() != null) {
                String string;
                Object object;
                this.nameTextField.setText(SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.CN));
                this.contactTextField.setText(SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.EmailAddress));
                String string2 = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.POSTAL_ADDRESS);
                if (string2 != null) {
                    this.locationTextField.setText(SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.POSTAL_ADDRESS));
                } else {
                    object = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.ST);
                    if (object != null) {
                        this.locationTextField.setText(SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.ST));
                    }
                }
                object = new ArrayList(2);
                String string3 = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.ST);
                if (string3 != null) {
                    ((ArrayList)object).add(string3);
                }
                if ((string = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.C)) != null) {
                    ((ArrayList)object).add(string);
                }
                if (!((ArrayList)object).isEmpty()) {
                    this.locationTextField.setText(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)object));
                }
            }
        }
        this.updateModelAppearanceState();
    }

    private void buildUI() throws KeyStoreException {
        PasswordDialogCallbackHandler passwordDialogCallbackHandler = new PasswordDialogCallbackHandler(this, messageBundle);
        this.signerHandler = PkcsSignerFactory.getInstance(passwordDialogCallbackHandler);
        this.setTitle(messageBundle.getString("viewer.annotation.signature.creation.dialog.title"));
        JPanel jPanel = this.buildCertificateSelectionPanel();
        JPanel jPanel2 = this.buildSignatureBuilderPanel();
        JPanel jPanel3 = this.buildSignatureControlPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.tab.title"), jPanel);
        jTabbedPane.addTab(messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.tab.title"), jPanel2);
        this.enableInputComponents(false);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jTabbedPane, "Center");
        jPanel4.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel4);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setResizable(true);
    }

    private JPanel buildSignatureBuilderPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(2, 10, 2, 10);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.appearance.title")));
        String string = this.signatureAppearanceModel.getFontName();
        ValueLabelItem[] valueLabelItemArray = FontWidgetUtilities.generateFontNameList(messageBundle);
        this.fontNameBox = new JComboBox<ValueLabelItem>(valueLabelItemArray);
        this.fontNameBox.setSelectedItem(Arrays.stream(valueLabelItemArray).filter(valueLabelItem -> valueLabelItem.getValue() == string).findAny().orElse(valueLabelItemArray[0]));
        this.fontNameBox.addItemListener(this);
        int n = this.signatureAppearanceModel.getFontSize();
        ValueLabelItem[] valueLabelItemArray2 = FontWidgetUtilities.generateFontSizeNameList(messageBundle);
        this.fontSizeBox = new JComboBox<ValueLabelItem>(valueLabelItemArray2);
        this.fontSizeBox.setSelectedItem(Arrays.stream(valueLabelItemArray2).filter(valueLabelItem -> (Integer)valueLabelItem.getValue() == n).findAny().orElse(valueLabelItemArray2[0]));
        this.fontSizeBox.addItemListener(this);
        boolean bl = this.signatureAppearanceModel.isSignatureTextVisible();
        this.showTextCheckBox = new JCheckBox(messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.appearance.showText.label"), bl);
        this.showTextCheckBox.addActionListener(this);
        boolean bl2 = this.signatureAppearanceModel.isSignatureImageVisible();
        this.showSignatureCheckBox = new JCheckBox(messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.appearance.showSignature.label"), bl2);
        this.showSignatureCheckBox.addActionListener(this);
        JLabel jLabel = new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.imagePath.label"));
        this.imagePathTextField = new JTextField();
        String string2 = this.signatureAppearanceModel.getSignatureImagePath();
        this.imagePathTextField.setText(string2);
        if (!string2.isEmpty()) {
            this.signatureAppearanceModel.setSignatureImagePath(string2);
        }
        this.imagePathTextField.addFocusListener(this);
        this.imagePathBrowseButton = new JButton(messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.selection.browse.label"));
        this.imagePathBrowseButton.addActionListener(this);
        int n2 = this.signatureAppearanceModel.getImageScale();
        JLabel jLabel2 = new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.imageScale.label"));
        this.imageScaleSlider = new JSlider(0, 0, 300, n2);
        this.imageScaleSlider.setMajorTickSpacing(50);
        this.imageScaleSlider.setPaintLabels(true);
        this.imageScaleSlider.setPaintTicks(true);
        this.imageScaleSlider.addChangeListener(this);
        this.addGB(jPanel2, new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.appearance.font.label")), 0, 0, 1, 1);
        this.addGB(jPanel2, this.fontNameBox, 1, 0, 1, 1);
        this.addGB(jPanel2, new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.appearance.fontSize.label")), 2, 0, 1, 1);
        this.addGB(jPanel2, this.fontSizeBox, 3, 0, 1, 1);
        this.addGB(jPanel2, this.showTextCheckBox, 0, 1, 1, 2);
        this.addGB(jPanel2, this.showSignatureCheckBox, 2, 1, 1, 2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), messageBundle.getString("viewer.annotation.signature.creation.dialog.signature.canvas.title")));
        this.addGB(jPanel3, jLabel, 0, 0, 1, 1);
        this.addGB(jPanel3, this.imagePathTextField, 1, 0, 1, 1);
        this.addGB(jPanel3, this.imagePathBrowseButton, 2, 0, 1, 1);
        this.addGB(jPanel3, jLabel2, 0, 1, 1, 1);
        this.addGB(jPanel3, this.imageScaleSlider, 1, 1, 1, 2);
        this.constraints.insets = new Insets(2, 10, 2, 10);
        this.addGB(jPanel, jPanel2, 0, 0, 1, 1);
        this.addGB(jPanel, jPanel3, 0, 1, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(jPanel, new Label(" "), 0, 9, 1, 1);
        return jPanel;
    }

    private JPanel buildSignatureControlPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(1.0f);
        this.closeButton = new JButton(messageBundle.getString("viewer.annotation.signature.creation.dialog.close.button.label"));
        this.closeButton.setMnemonic(messageBundle.getString("viewer.button.cancel.mnemonic").charAt(0));
        this.closeButton.addActionListener(this);
        this.signButton = new JButton(messageBundle.getString("viewer.annotation.signature.creation.dialog.sign.button.label"));
        this.signButton.addActionListener(this);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(5, 10, 5, 10);
        this.constraints.anchor = 17;
        this.addGB(jPanel, this.closeButton, 0, 0, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel, this.signButton, 1, 0, 1, 1);
        return jPanel;
    }

    private JPanel buildCertificateSelectionPanel() throws KeyStoreException {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        if (this.signerHandler == null) {
            throw new IllegalStateException("Signer handler is null");
        }
        Enumeration<String> enumeration = this.signerHandler.buildKeyStore().aliases();
        CertificateTableModel certificateTableModel = new CertificateTableModel(this.signerHandler, enumeration, messageBundle);
        this.certificateTable = new JTable(certificateTableModel);
        this.certificateTable.getSelectionModel().addListSelectionListener(this);
        this.certificateTable.setPreferredScrollableViewportSize(new Dimension(600, 100));
        this.certificateTable.setFillsViewportHeight(true);
        this.signerRadioButton = new JRadioButton(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.type.signer.label"));
        this.signerRadioButton.setSelected(true);
        this.signerRadioButton.addActionListener(this);
        this.signerRadioButton.setActionCommand(SignatureType.SIGNER.toString());
        this.certifyRadioButton = new JRadioButton(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.type.certify.label"));
        this.certifyRadioButton.addActionListener(this);
        this.signerRadioButton.setActionCommand(SignatureType.CERTIFIER.toString());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.signerRadioButton);
        buttonGroup.add(this.certifyRadioButton);
        this.signerVisibilityCheckBox = new JCheckBox(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.visibility.certify.label"));
        this.signerVisibilityCheckBox.setSelected(true);
        this.signerVisibilityCheckBox.addActionListener(this);
        this.locationTextField = new JTextField();
        this.locationTextField.addFocusListener(this);
        JTextField jTextField = new JTextField();
        jTextField.setEnabled(false);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(new Date());
        jTextField.setText(string);
        this.nameTextField = new JTextField();
        this.nameTextField.addFocusListener(this);
        this.contactTextField = new JTextField();
        this.contactTextField.addFocusListener(this);
        this.languagesComboBox = new JComboBox<Locale>(supportedLocales);
        Locale locale = new Locale(Locale.getDefault().getLanguage());
        this.languagesComboBox.setSelectedItem(new Locale(Locale.getDefault().getLanguage()));
        this.languagesComboBox.addItemListener(this);
        this.signatureAppearanceModel.setLocale(locale);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(2, 10, 2, 10);
        this.addGB(jPanel, new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.selection.label")), 0, 0, 1, 3);
        this.addGB(jPanel, new JScrollPane(this.certificateTable), 0, 1, 1, 4);
        this.addGB(jPanel, new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.type.description.label")), 0, 2, 1, 1);
        this.addGB(jPanel, this.signerRadioButton, 1, 2, 1, 1);
        this.addGB(jPanel, this.certifyRadioButton, 2, 2, 1, 1);
        this.addGB(jPanel, this.signerVisibilityCheckBox, 3, 2, 1, 1);
        this.addGB(jPanel, new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.location.date.label")), 0, 3, 1, 1);
        this.addGB(jPanel, this.locationTextField, 1, 3, 1, 1);
        this.addGB(jPanel, jTextField, 2, 3, 1, 1);
        this.addGB(jPanel, new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.name.label")), 0, 5, 1, 1);
        this.addGB(jPanel, this.nameTextField, 1, 5, 1, 3);
        this.addGB(jPanel, new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.contact.label")), 0, 6, 1, 1);
        this.addGB(jPanel, this.contactTextField, 1, 6, 1, 3);
        this.constraints.anchor = 21;
        this.addGB(jPanel, new JLabel(messageBundle.getString("viewer.annotation.signature.creation.dialog.certificate.i18n.label")), 0, 8, 1, 1);
        this.addGB(jPanel, this.languagesComboBox, 1, 8, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(jPanel, new Label(" "), 0, 9, 1, 1);
        return jPanel;
    }

    private void enableInputComponents(boolean bl) {
        this.nameTextField.setEnabled(bl);
        this.contactTextField.setEnabled(bl);
        this.locationTextField.setEnabled(bl);
        this.signerRadioButton.setEnabled(bl);
        this.certifyRadioButton.setEnabled(bl);
        this.signerVisibilityCheckBox.setEnabled(bl);
        this.languagesComboBox.setEnabled(bl);
        this.fontNameBox.setEnabled(bl);
        this.fontSizeBox.setEnabled(bl);
        this.showTextCheckBox.setEnabled(bl);
        this.showSignatureCheckBox.setEnabled(bl);
        this.imagePathTextField.setEnabled(bl);
        this.signButton.setEnabled(bl);
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n4;
        this.constraints.gridheight = n3;
        jPanel.add(component, this.constraints);
    }
}

