/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signing;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.acroform.signature.appearance.SignatureAppearanceModel;
import org.icepdf.core.pobjects.acroform.signature.appearance.SignatureType;
import org.icepdf.core.pobjects.acroform.signature.utils.SignatureUtilities;
import org.icepdf.core.util.Library;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class SignatureAppearanceModelImpl
implements SignatureAppearanceModel {
    private BufferedImage signatureImage;
    private Name imageXObjectName;
    private Reference imageXObjectReference;
    private Color fontColor = Color.BLACK;
    private SignatureType signatureType;
    private boolean signatureVisible = true;
    private boolean isSelectedCertificate = true;
    private String location;
    private String contact;
    private String name;
    private ResourceBundle messageBundle;
    private Locale locale;
    private final Preferences preferences;

    public SignatureAppearanceModelImpl(Library library) {
        this.imageXObjectName = new Name("sig_img_" + library.getStateManager().getNextImageNumber());
        this.preferences = ViewerPropertiesManager.getInstance().getPreferences();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.messageBundle = ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle", locale);
    }

    public Name getImageXObjectName() {
        return this.imageXObjectName;
    }

    public Reference getImageXObjectReference() {
        return this.imageXObjectReference;
    }

    public void setImageXObjectReference(Reference reference) {
        this.imageXObjectReference = reference;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public boolean isSignatureVisible() {
        return this.signatureVisible;
    }

    public boolean isSelectedCertificate() {
        return this.isSelectedCertificate;
    }

    public void setSelectedCertificate(boolean bl) {
        this.isSelectedCertificate = bl;
    }

    public void setSignatureVisible(boolean bl) {
        this.signatureVisible = bl;
    }

    public BufferedImage getSignatureImage() {
        return this.signatureImage;
    }

    public void setSignatureImage(BufferedImage bufferedImage) {
        this.signatureImage = bufferedImage;
    }

    public String getFontName() {
        return this.preferences.get("org.icepdf.core.signatures.font.name", "Helvetica");
    }

    public void setFontName(String string) {
        this.preferences.put("org.icepdf.core.signatures.font.name", string);
    }

    public int getFontSize() {
        return this.preferences.getInt("org.icepdf.core.signatures.font.size", 6);
    }

    public void setFontSize(int n) {
        this.preferences.putInt("org.icepdf.core.signatures.font.size", n);
    }

    public boolean isSignatureTextVisible() {
        return this.preferences.getBoolean("org.icepdf.core.signatures.show.txt", true);
    }

    public void setSignatureTextVisible(boolean bl) {
        this.preferences.putBoolean("org.icepdf.core.signatures.show.txt", bl);
    }

    public boolean isSignatureImageVisible() {
        return this.preferences.getBoolean("org.icepdf.core.signatures.show.image", true);
    }

    public void setSignatureImageVisible(boolean bl) {
        this.preferences.putBoolean("org.icepdf.core.signatures.show.image", bl);
    }

    public int getImageScale() {
        return this.preferences.getInt("org.icepdf.core.signatures.show.imageScale", 100);
    }

    public void setImageScale(int n) {
        this.preferences.putInt("org.icepdf.core.signatures.show.imageScale", n);
    }

    public void setSignatureImagePath(String string) {
        this.preferences.put("org.icepdf.core.signatures.image.path", string);
        this.signatureImage = SignatureUtilities.loadSignatureImage((String)string);
    }

    public String getSignatureImagePath() {
        return this.preferences.get("org.icepdf.core.signatures.image.path", "");
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String string) {
        this.contact = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ResourceBundle getMessageBundle() {
        return this.messageBundle;
    }
}

