/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signing;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.icepdf.core.pobjects.acroform.signature.handlers.PasswordCallbackHandler;

public class PasswordDialogCallbackHandler
extends PasswordCallbackHandler {
    private static final Logger logger = Logger.getLogger(PasswordDialogCallbackHandler.class.getName());
    private JDialog parentComponent;
    private ResourceBundle messageBundle;
    private String dialogType;

    public PasswordDialogCallbackHandler(JDialog jDialog, ResourceBundle resourceBundle) {
        super("");
        this.parentComponent = jDialog;
        this.messageBundle = resourceBundle;
    }

    public void setType(String string) {
        this.dialogType = string;
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            Callback callback2;
            if (callback instanceof PasswordCallback) {
                JComponent jComponent;
                String string;
                callback2 = (PasswordCallback)callback;
                JPanel jPanel = new JPanel();
                Object[] objectArray = new String[]{this.messageBundle.getString("viewer.button.ok.label"), this.messageBundle.getString("viewer.button.cancel.label")};
                if (this.dialogType.equals("PKCS#11")) {
                    string = this.messageBundle.getString("viewer.annotation.signature.creation.keystore.pkcs11.dialog.title");
                    jComponent = new JLabel(this.messageBundle.getString("viewer.annotation.signature.creation.keystore.pkcs11.dialog.label"));
                    jPanel.add(jComponent);
                } else {
                    string = this.messageBundle.getString("viewer.annotation.signature.creation.keystore.pkcs12.dialog.title");
                    jComponent = new JLabel(this.messageBundle.getString("viewer.annotation.signature.creation.keystore.pkcs12.dialog.label"));
                    jPanel.add(jComponent);
                }
                jComponent = new JPasswordField(15);
                jPanel.add(jComponent);
                int n = JOptionPane.showOptionDialog(this.parentComponent, jPanel, string, 0, -1, null, objectArray, objectArray[0]);
                if (n == 0) {
                    char[] cArray = ((JPasswordField)jComponent).getPassword();
                    this.password = cArray;
                    ((PasswordCallback)callback2).setPassword(cArray);
                    continue;
                }
                if (n != -1) continue;
                System.out.println("closed");
                continue;
            }
            if (callback instanceof TextOutputCallback) {
                callback2 = (TextOutputCallback)callback;
                logger.log(Level.WARNING, "TextOutputCallback type {0} message: {1}", new Object[]{((TextOutputCallback)callback2).getMessageType(), ((TextOutputCallback)callback2).getMessage()});
                throw new UnsupportedCallbackException(callback);
            }
            if (callback instanceof NameCallback) {
                throw new UnsupportedCallbackException(callback);
            }
            logger.log(Level.WARNING, "Unknown callback type {0}", callback.getClass().getName());
            throw new UnsupportedCallbackException(callback);
        }
    }
}

