/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signatures;

import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import javax.swing.Icon;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.acroform.signature.utils.SignatureUtilities;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.ri.images.IconPack;
import org.icepdf.ri.images.Images;

public class SignatureValidationStatus {
    private String validity = "viewer.annotation.signature.validation.common.invalid.label";
    private String singedBy;
    private String documentModified;
    private String certificateTrusted;
    private String signatureTime;
    private String emailAddress;
    private String organization;
    private String commonName;
    private final Icon validityIcon;
    private final String dictionaryName;
    private final String dictionaryLocation;
    private final String dictionaryReason;
    private final String dictionaryContact;
    private final String dictionaryDate;

    public SignatureValidationStatus(ResourceBundle resourceBundle, SignatureWidgetAnnotation signatureWidgetAnnotation, SignatureValidator signatureValidator) {
        if (!signatureValidator.isSignedDataModified() && signatureValidator.isCertificateChainTrusted()) {
            this.validity = "viewer.annotation.signature.validation.common.unknown.label";
        } else if (!signatureValidator.isSignedDataModified() && !signatureValidator.isCertificateChainTrusted()) {
            this.validity = "viewer.annotation.signature.validation.common.valid.label";
        }
        this.validity = resourceBundle.getString(this.validity);
        this.singedBy = resourceBundle.getString("viewer.annotation.signature.validation.common.notAvailable.label");
        this.validateSignatureNode(signatureWidgetAnnotation, signatureValidator);
        MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("viewer.annotation.signature.validation.common.signedBy.label"));
        this.singedBy = messageFormat.format(new Object[]{this.commonName != null ? this.commonName + " " : " ", this.emailAddress != null ? "<" + this.emailAddress + ">" : ""});
        this.documentModified = "viewer.annotation.signature.validation.common.doc.modified.label";
        if (!signatureValidator.isSignedDataModified() && !signatureValidator.isDocumentDataModified()) {
            this.documentModified = "viewer.annotation.signature.validation.common.doc.unmodified.label";
        } else if (!signatureValidator.isSignedDataModified() && signatureValidator.isDocumentDataModified() && signatureValidator.isSignaturesCoverDocumentLength()) {
            this.documentModified = "viewer.annotation.signature.validation.common.doc.modified.label";
        } else if (signatureValidator.isSignaturesCoverDocumentLength() && signatureValidator.isSignedDataModified()) {
            this.documentModified = "viewer.annotation.signature.validation.common.doc.major.label";
        }
        this.documentModified = resourceBundle.getString(this.documentModified);
        this.certificateTrusted = "viewer.annotation.signature.validation.common.identity.unknown.label";
        if (signatureValidator.isCertificateChainTrusted()) {
            this.certificateTrusted = signatureValidator.isRevocation() ? "viewer.annotation.signature.validation.common.identity.unchecked.label" : "viewer.annotation.signature.validation.common.identity.valid.label";
        }
        this.certificateTrusted = resourceBundle.getString(this.certificateTrusted);
        this.signatureTime = "viewer.annotation.signature.validation.common.time.local.label";
        if (signatureValidator.isSignerTimeValid()) {
            this.signatureTime = "viewer.annotation.signature.validation.common.time.embedded.label";
        }
        this.signatureTime = resourceBundle.getString(this.signatureTime);
        this.validityIcon = this.getLargeValidityIcon(signatureValidator);
        SignatureDictionary signatureDictionary = signatureWidgetAnnotation.getSignatureDictionary();
        this.dictionaryName = signatureDictionary.getName();
        this.dictionaryLocation = signatureDictionary.getLocation();
        this.dictionaryReason = signatureDictionary.getReason();
        this.dictionaryContact = signatureDictionary.getContactInfo();
        this.dictionaryDate = signatureDictionary.getDate();
    }

    private void validateSignatureNode(SignatureWidgetAnnotation signatureWidgetAnnotation, SignatureValidator signatureValidator) {
        X509Certificate x509Certificate;
        X500Principal x500Principal;
        X500Name x500Name;
        SignatureFieldDictionary signatureFieldDictionary = signatureWidgetAnnotation.getFieldDictionary();
        if (signatureFieldDictionary != null && (x500Name = new X500Name((x500Principal = (x509Certificate = signatureValidator.getSignerCertificate()).getSubjectX500Principal()).getName())).getRDNs() != null) {
            this.commonName = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.CN);
            this.organization = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.O);
            this.emailAddress = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.EmailAddress);
        }
    }

    protected Icon getLargeValidityIcon(SignatureValidator signatureValidator) {
        if (!signatureValidator.isSignedDataModified() && signatureValidator.isCertificateChainTrusted() && signatureValidator.isSignaturesCoverDocumentLength()) {
            return Images.getSingleIcon("signature_valid", IconPack.Variant.NONE, Images.IconSize.HUGE);
        }
        if (!signatureValidator.isSignedDataModified() && signatureValidator.isSignaturesCoverDocumentLength()) {
            return Images.getSingleIcon("signature_caution", IconPack.Variant.NONE, Images.IconSize.HUGE);
        }
        return Images.getSingleIcon("signature_invalid", IconPack.Variant.NONE, Images.IconSize.HUGE);
    }

    public Icon getValidityIcon() {
        return this.validityIcon;
    }

    public String getValidity() {
        return this.validity;
    }

    public String getSingedBy() {
        return this.singedBy;
    }

    public String getDocumentModified() {
        return this.documentModified;
    }

    public String getCertificateTrusted() {
        return this.certificateTrusted;
    }

    public String getSignatureTime() {
        return this.signatureTime;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getDictionaryName() {
        return this.dictionaryName;
    }

    public String getDictionaryLocation() {
        return this.dictionaryLocation;
    }

    public String getDictionaryReason() {
        return this.dictionaryReason;
    }

    public String getDictionaryContact() {
        return this.dictionaryContact;
    }

    public String getDictionaryDate() {
        return this.dictionaryDate;
    }
}

