/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signatures;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.views.annotations.signatures.CertificatePropertiesDialog;
import org.icepdf.ri.common.views.annotations.signatures.SignatureValidationPanel;
import org.icepdf.ri.common.views.annotations.signatures.SignatureValidationStatus;
import org.icepdf.ri.common.views.annotations.signatures.SignerInfoPanel;
import org.icepdf.ri.common.views.annotations.signatures.SignerSummaryPanel;

public class SignaturePropertiesDialog
extends EscapeJDialog {
    private static final Logger logger = Logger.getLogger(SignaturePropertiesDialog.class.toString());
    private GridBagConstraints constraints;
    private final SignatureValidator signatureValidator;
    protected static ResourceBundle messageBundle;
    protected final SignatureWidgetAnnotation signatureWidgetAnnotation;

    public SignaturePropertiesDialog(Dialog dialog, ResourceBundle resourceBundle, SignatureWidgetAnnotation signatureWidgetAnnotation) {
        super(dialog, true);
        messageBundle = resourceBundle;
        this.signatureValidator = signatureWidgetAnnotation.getSignatureValidator();
        this.signatureWidgetAnnotation = signatureWidgetAnnotation;
        this.buildUI();
    }

    public SignaturePropertiesDialog(Frame frame, ResourceBundle resourceBundle, SignatureWidgetAnnotation signatureWidgetAnnotation) {
        super(frame, true);
        messageBundle = resourceBundle;
        this.signatureValidator = signatureWidgetAnnotation.getSignatureValidator();
        this.signatureWidgetAnnotation = signatureWidgetAnnotation;
        this.buildUI();
    }

    private void buildUI() {
        SignatureValidationStatus signatureValidationStatus = new SignatureValidationStatus(messageBundle, this.signatureWidgetAnnotation, this.signatureValidator);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add((Component)jPanel, "North");
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(5, 10, 10, 10);
        SignerSummaryPanel signerSummaryPanel = new SignerSummaryPanel(signatureValidationStatus, messageBundle, this.signatureWidgetAnnotation, this.signatureValidator, true);
        this.addGB(jPanel, signerSummaryPanel, 0, 0, 2, 1);
        SignatureValidationPanel signatureValidationPanel = new SignatureValidationPanel(signatureValidationStatus, messageBundle, this.signatureWidgetAnnotation, this.signatureValidator, false, true);
        this.addGB(jPanel, signatureValidationPanel, 0, 1, 2, 1);
        SignerInfoPanel signerInfoPanel = new SignerInfoPanel(signatureValidationStatus, messageBundle, this.signatureWidgetAnnotation, this.signatureValidator);
        this.addGB(jPanel, signerInfoPanel, 0, 2, 2, 1);
        JButton jButton = new JButton(messageBundle.getString("viewer.annotation.signature.validation.dialog.close.button.label"));
        jButton.setMnemonic(messageBundle.getString("viewer.button.cancel.mnemonic").charAt(0));
        jButton.addActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
        });
        JButton jButton2 = new JButton(messageBundle.getString("viewer.annotation.signature.properties.dialog.showCertificates.label"));
        SignaturePropertiesDialog signaturePropertiesDialog = this;
        jButton2.addActionListener(actionEvent -> new CertificatePropertiesDialog(signaturePropertiesDialog, messageBundle, (Collection<? extends Certificate>)this.signatureValidator.getCertificateChain()).setVisible(true));
        this.constraints.anchor = 17;
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.addGB(jPanel, jButton2, 0, 3, 1, 1);
        this.constraints.anchor = 13;
        this.constraints.weightx = 1.0;
        this.addGB(jPanel, jButton, 1, 3, 1, 1);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setResizable(false);
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

