/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Date;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.tools.TextAnnotationHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationPopupMenu;
import org.icepdf.ri.common.views.annotations.MarkupGlueComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupListener;

public abstract class MarkupAnnotationComponent<T extends MarkupAnnotation>
extends AbstractAnnotationComponent<T> {
    protected static final Logger logger = Logger.getLogger(MarkupAnnotationComponent.class.toString());
    protected static final boolean isInteractivePopupAnnotationsEnabled = Defs.sysPropertyBoolean((String)"org.icepdf.core.annotations.interactive.popup.enabled", (boolean)true);
    private PopupAnnotationComponent popupAnnotationComponent;

    public MarkupAnnotationComponent(T t, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(t, documentViewController, abstractPageViewComponent);
        this.buildContextMenu();
    }

    public void buildContextMenu() {
        this.contextMenu = new MarkupAnnotationPopupMenu(this, this.documentViewController.getParentController(), this.getPageViewComponent(), true);
        PopupListener popupListener = new PopupListener(this.contextMenu);
        this.addMouseListener(popupListener);
    }

    @Override
    public void resetAppearanceShapes() {
        if (this.annotation != null) {
            PopupAnnotationComponent popupAnnotationComponent;
            PopupAnnotation popupAnnotation = ((MarkupAnnotation)this.annotation).getPopupAnnotation();
            if (popupAnnotation != null && (popupAnnotationComponent = this.getPopupAnnotationComponent()) != null) {
                popupAnnotationComponent.resetAppearanceShapes();
            }
            ((MarkupAnnotationPopupMenu)this.contextMenu).refreshColorMenu();
        }
    }

    public PopupAnnotationComponent getPopupAnnotationComponent() {
        if (this.annotation != null) {
            PopupAnnotation popupAnnotation = ((MarkupAnnotation)this.annotation).getPopupAnnotation();
            if (popupAnnotation == null) {
                PopupAnnotationComponent popupAnnotationComponent = this.createPopupAnnotationComponent(false);
                ((MarkupAnnotation)this.annotation).setPopupAnnotation((PopupAnnotation)popupAnnotationComponent.getAnnotation());
                ((PopupAnnotation)popupAnnotationComponent.getAnnotation()).setOpen(false);
                popupAnnotationComponent.setVisible(false);
                return popupAnnotationComponent;
            }
            AnnotationComponent annotationComponent = this.pageViewComponent.getComponentFor((Annotation)popupAnnotation);
            if (annotationComponent instanceof PopupAnnotationComponent) {
                this.popupAnnotationComponent = (PopupAnnotationComponent)annotationComponent;
            }
            return this.popupAnnotationComponent;
        }
        return null;
    }

    public PopupAnnotationComponent createPopupAnnotationComponent(boolean bl) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 215, 150);
        Rectangle rectangle3 = this.convertToPageSpace(rectangle2).getBounds();
        if (this.annotation != null && bl) {
            if (((MarkupAnnotation)this.annotation).getCreationDate() == null) {
                ((MarkupAnnotation)this.annotation).setCreationDate(PDate.formatDateTime((Date)new Date()));
            }
            if (((MarkupAnnotation)this.annotation).getTitleText() == null) {
                ((MarkupAnnotation)this.annotation).setTitleText(SystemProperties.USER_NAME);
            }
            if (((MarkupAnnotation)this.annotation).getContents() == null) {
                ((MarkupAnnotation)this.annotation).setContents("");
            }
        }
        PopupAnnotation popupAnnotation = null;
        if (this.annotation != null && ((MarkupAnnotation)this.annotation).getPopupAnnotation() == null) {
            popupAnnotation = TextAnnotationHandler.createPopupAnnotation(this.documentViewController.getDocument().getPageTree().getLibrary(), rectangle3, (MarkupAnnotation)this.annotation, this.getToPageSpaceTransform(), bl);
            ((MarkupAnnotation)this.annotation).setPopupAnnotation(popupAnnotation);
        } else if (this.annotation != null) {
            popupAnnotation = ((MarkupAnnotation)this.annotation).getPopupAnnotation();
        }
        if (popupAnnotation != null) {
            PopupAnnotationComponent popupAnnotationComponent = (PopupAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)popupAnnotation, this.documentViewController, this.pageViewComponent);
            popupAnnotationComponent.setParentPageComponent(this.pageViewComponent);
            popupAnnotationComponent.refreshDirtyBounds();
            popupAnnotationComponent.refreshAnnotationRect();
            popupAnnotationComponent.setSynthetic(!bl);
            this.documentViewController.addNewAnnotation(popupAnnotationComponent);
            this.pageViewComponent.revalidate();
            this.popupAnnotationComponent = popupAnnotationComponent;
            return popupAnnotationComponent;
        }
        return null;
    }

    @Override
    public boolean contains(int n, int n2) {
        boolean bl = super.contains(n, n2);
        if (bl && this.annotation != null && ((MarkupAnnotation)this.annotation).getMarkupPath() != null) {
            AffineTransform affineTransform = this.getPageSpaceTransform();
            Shape shape = ((MarkupAnnotation)this.annotation).getMarkupPath().createTransformedShape(affineTransform);
            Rectangle rectangle = this.getBounds();
            AffineTransform affineTransform2 = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -rectangle.x, -rectangle.y);
            Rectangle rectangle2 = (shape = affineTransform2.createTransformedShape(shape)).getBounds();
            if (!rectangle2.intersects(new Rectangle(0, 0, rectangle.width, rectangle.height))) {
                return true;
            }
            boolean bl2 = shape.contains(n, n2);
            return bl2;
        }
        return bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (isInteractivePopupAnnotationsEnabled && mouseEvent.getClickCount() == 2) {
            this.togglePopupAnnotationVisibility();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        PopupAnnotationComponent popupAnnotationComponent;
        super.mouseDragged(mouseEvent);
        PopupAnnotation popupAnnotation = ((MarkupAnnotation)this.annotation).getPopupAnnotation();
        if (popupAnnotation != null && (popupAnnotationComponent = this.getPopupAnnotationComponent()) != null) {
            MarkupGlueComponent markupGlueComponent = popupAnnotationComponent.getMarkupGlueComponent();
            markupGlueComponent.refreshDirtyBounds();
        }
    }

    public void togglePopupAnnotationVisibility() {
        if (this.annotation != null) {
            PopupAnnotation popupAnnotation = ((MarkupAnnotation)this.annotation).getPopupAnnotation();
            if (popupAnnotation != null) {
                popupAnnotation.setOpen(!popupAnnotation.isOpen());
                PopupAnnotationComponent popupAnnotationComponent = this.getPopupAnnotationComponent();
                popupAnnotationComponent.setVisible(popupAnnotation.isOpen());
                if (popupAnnotationComponent.isVisible()) {
                    popupAnnotationComponent.focusTextArea();
                }
            } else {
                this.createPopupAnnotationComponent(true);
            }
        }
    }

    @Override
    public boolean isActive() {
        return false;
    }
}

