/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JTextArea;
import javax.swing.plaf.LayerUI;

public class FreeTextArea
extends JTextArea {
    private final ZoomProvider zoomProvider;
    private boolean active;

    public FreeTextArea(ZoomProvider zoomProvider) {
        this.zoomProvider = zoomProvider;
        this.getDocument().putProperty("i18n", Boolean.TRUE.toString());
        this.putClientProperty("i18n", Boolean.TRUE.toString());
        LayerUI<JComponent> layerUI = new LayerUI<JComponent>(){

            @Override
            public void installUI(JComponent jComponent) {
                super.installUI(jComponent);
                ((JLayer)jComponent).setLayerEventMask(48L);
            }

            @Override
            public void uninstallUI(JComponent jComponent) {
                super.uninstallUI(jComponent);
                ((JLayer)jComponent).setLayerEventMask(0L);
            }

            @Override
            public void eventDispatched(AWTEvent aWTEvent, JLayer<? extends JComponent> jLayer) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                float f = FreeTextArea.this.zoomProvider.getZoom();
                MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiersEx(), (int)((float)mouseEvent.getX() / f), (int)((float)mouseEvent.getY() / f), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                mouseEvent.consume();
                FreeTextArea.this.processMouseEvent(mouseEvent2);
                FreeTextArea.this.processMouseMotionEvent(mouseEvent2);
            }
        };
        new JLayer<JComponent>(this, layerUI);
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        if (!this.active) {
            return;
        }
        super.paintBorder(graphics);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.active) {
            return;
        }
        float f = this.zoomProvider.getZoom();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.scale(f, f);
        super.paintComponent(graphics2D);
        graphics2D.setTransform(affineTransform);
    }

    @Override
    public void repaint(int n, int n2, int n3, int n4) {
        super.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public static interface ZoomProvider {
        public float getZoom();
    }
}

