/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.icepdf.core.Memento;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.PageViewComponentImpl;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupState;

public class AnnotationState
implements Memento {
    private final Rectangle2D.Float userSpaceRectangle;
    private final Operation operation;
    private final AnnotationComponent annotationComponent;
    private final PopupState popupState;

    public AnnotationState(AnnotationComponent annotationComponent, Operation operation) {
        this.annotationComponent = Objects.requireNonNull(annotationComponent);
        this.operation = Objects.requireNonNull(operation);
        this.userSpaceRectangle = annotationComponent.getAnnotation().getUserSpaceRectangle();
        this.popupState = annotationComponent instanceof MarkupAnnotationComponent ? new PopupState(((MarkupAnnotationComponent)annotationComponent).getPopupAnnotationComponent()) : null;
    }

    public AnnotationComponent getAnnotationComponent() {
        return this.annotationComponent;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void restore() {
        if (this.annotationComponent != null && this.annotationComponent.getAnnotation() != null) {
            Annotation annotation = this.annotationComponent.getAnnotation();
            if (annotation.getBorderStyle() == null) {
                annotation.setBorderStyle(new BorderStyle());
            }
            annotation.setUserSpaceRectangle(this.userSpaceRectangle);
            this.synchronizeState();
        }
    }

    public void synchronizeState() {
        int n = this.annotationComponent.getPageIndex();
        Document document = this.annotationComponent.getDocument();
        Annotation annotation = this.annotationComponent.getAnnotation();
        PageTree pageTree = document.getPageTree();
        Page page = pageTree.getPage(n);
        if (this.operation == Operation.ADD) {
            annotation.setDeleted(false);
            page.addAnnotation(annotation, true);
            PageViewComponentImpl pageViewComponentImpl = (PageViewComponentImpl)this.annotationComponent.getPageViewComponent();
            if (!pageViewComponentImpl.getAnnotationComponents().contains(this.annotationComponent)) {
                pageViewComponentImpl.addAnnotation(this.annotationComponent);
            }
            if (this.annotationComponent instanceof MarkupAnnotationComponent) {
                PopupAnnotationComponent popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent();
                if (popupAnnotationComponent == null) {
                    popupAnnotationComponent = ((MarkupAnnotationComponent)this.annotationComponent).createPopupAnnotationComponent(true);
                } else if (!pageViewComponentImpl.getAnnotationComponents().contains(popupAnnotationComponent)) {
                    pageViewComponentImpl.addAnnotation(popupAnnotationComponent);
                }
                if (this.popupState != null) {
                    PopupAnnotation popupAnnotation = (PopupAnnotation)popupAnnotationComponent.getAnnotation();
                    popupAnnotation.setOpen(this.popupState.isVisible());
                    popupAnnotationComponent.setVisible(this.popupState.isVisible());
                    popupAnnotationComponent.setTextAreaFontSize(this.popupState.getTextAreaFontSize());
                    popupAnnotationComponent.setHeaderLabelsFontSize(this.popupState.getHeaderTextSize());
                }
            }
            ((Component)((Object)this.annotationComponent)).setVisible(true);
        } else if (this.operation == Operation.DELETE) {
            page.deleteAnnotation(annotation);
            ((Component)((Object)this.annotationComponent)).setVisible(false);
            if (this.annotationComponent instanceof MarkupAnnotationComponent) {
                ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent().setVisible(false);
            }
        } else if (this.operation == Operation.MOVE) {
            page.updateAnnotation(annotation);
            if (this.annotationComponent instanceof MarkupAnnotationComponent) {
                ((MarkupAnnotationComponent)this.annotationComponent).getPopupAnnotationComponent().getMarkupGlueComponent().refreshDirtyBounds();
            }
        }
        this.annotationComponent.refreshDirtyBounds();
    }

    public static enum Operation {
        ADD,
        DELETE,
        MOVE;

    }
}

