/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.icepdf.ri.common.CurrentPageChanger;
import org.icepdf.ri.common.KeyListenerPageChanger;
import org.icepdf.ri.common.MouseWheelListenerPageChanger;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.PageViewDecorator;
import org.icepdf.ri.common.views.TwoPageViewLayout;

public class TwoPageView
extends AbstractDocumentView {
    protected final int viewAlignment;
    protected final Object pageChangerListener;
    protected final KeyListenerPageChanger keyListenerPageChanger;
    protected final CurrentPageChanger currentPageChanger;

    public TwoPageView(DocumentViewController documentViewController, JScrollPane jScrollPane, DocumentViewModel documentViewModel, int n) {
        super(documentViewController, jScrollPane, documentViewModel);
        this.viewAlignment = n;
        this.buildGUI();
        this.pageChangerListener = MouseWheelListenerPageChanger.install(this.documentViewController.getParentController(), jScrollPane, this);
        this.keyListenerPageChanger = KeyListenerPageChanger.install(this.documentViewController.getParentController(), jScrollPane, this);
        this.currentPageChanger = new CurrentPageChanger(jScrollPane, this, documentViewModel.getPageComponents(), false);
    }

    private void buildGUI() {
        this.setLayout(new TwoPageViewLayout(this.viewAlignment, this.documentViewModel));
        this.setBackground(backgroundColour);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.updateDocumentView();
    }

    @Override
    public void updateDocumentView() {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        List<AbstractPageViewComponent> list = documentViewModel.getPageComponents();
        if (list != null) {
            this.removeAll();
            int n = 0;
            int n2 = documentViewModel.getViewCurrentPageIndex();
            int n3 = list.size();
            if (this.viewAlignment == 1 && (n2 > 0 && n2 % 2 == 0 || n2 > 0 && n3 == 2)) {
                --n2;
            } else if (this.viewAlignment == 0 && n2 > 0 && n2 % 2 != 0 || n2 > 0 && n3 == 2) {
                --n2;
            }
            for (int i = n2; i < n3 && n < 2; ++i) {
                AbstractPageViewComponent abstractPageViewComponent;
                if (i == 0 && n3 > 2 && this.viewAlignment == 1) {
                    ++n;
                }
                if ((abstractPageViewComponent = list.get(i)) == null) continue;
                PageViewDecorator object = new PageViewDecorator(abstractPageViewComponent);
                this.setLayer(object, JLayeredPane.DEFAULT_LAYER);
                this.add(object);
                this.addPopupAnnotationAndGlue(abstractPageViewComponent);
                ++n;
            }
            this.revalidate();
            this.repaint();
            for (PageViewComponent pageViewComponent : list) {
                if (pageViewComponent == null) continue;
                pageViewComponent.setDocumentViewCallback(this);
            }
        }
    }

    @Override
    public int getNextPageIncrement() {
        return 2;
    }

    @Override
    public int getPreviousPageIncrement() {
        return 2;
    }

    @Override
    public void dispose() {
        if (this.pageChangerListener != null) {
            JScrollPane jScrollPane = this.documentViewModel.getDocumentViewScrollPane();
            MouseWheelListenerPageChanger.uninstall(jScrollPane, this.pageChangerListener);
        }
        if (this.keyListenerPageChanger != null) {
            this.keyListenerPageChanger.uninstall();
        }
        if (this.currentPageChanger != null) {
            this.currentPageChanger.dispose();
        }
        this.removeAll();
        this.invalidate();
        super.dispose();
    }

    @Override
    public Dimension getDocumentSize() {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof PageViewDecorator)) continue;
            PageViewDecorator pageViewDecorator = (PageViewDecorator)component;
            Dimension dimension = pageViewDecorator.getPreferredSize();
            f = dimension.width;
            f2 = dimension.height;
            break;
        }
        float f3 = this.documentViewController.getDocumentViewModel().getViewZoom();
        f = Math.abs(f / f3);
        f2 = Math.abs(f2 / f3);
        f *= 2.0f;
        return new Dimension((int)(f += 2.0f), (int)(f2 += 4.0f));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(backgroundColour);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paintComponent(graphics);
    }
}

