/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.icepdf.ri.common.CurrentPageChanger;
import org.icepdf.ri.common.KeyListenerPageColumnChanger;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.PageViewDecorator;
import org.icepdf.ri.common.views.TwoColumnPageViewLayout;

public class TwoColumnPageView
extends AbstractDocumentView {
    protected final int viewAlignment;
    protected final CurrentPageChanger currentPageChanger;
    protected final KeyListenerPageColumnChanger keyListenerPageChanger;

    public TwoColumnPageView(DocumentViewController documentViewController, JScrollPane jScrollPane, DocumentViewModel documentViewModel, int n) {
        super(documentViewController, jScrollPane, documentViewModel);
        this.viewAlignment = n;
        this.buildGUI();
        this.currentPageChanger = new CurrentPageChanger(jScrollPane, this, documentViewModel.getPageComponents());
        this.keyListenerPageChanger = KeyListenerPageColumnChanger.install(this.documentViewController.getParentController(), jScrollPane, this, this.currentPageChanger);
    }

    private void buildGUI() {
        this.setLayout(new TwoColumnPageViewLayout(this.viewAlignment, this.documentViewModel));
        this.setBackground(backgroundColour);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.removeAll();
        List<AbstractPageViewComponent> list = this.documentViewController.getDocumentViewModel().getPageComponents();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AbstractPageViewComponent abstractPageViewComponent = list.get(i);
                if (abstractPageViewComponent == null) continue;
                abstractPageViewComponent.setDocumentViewCallback(this);
                PageViewDecorator pageViewDecorator = new PageViewDecorator(abstractPageViewComponent);
                this.setLayer(pageViewDecorator, JLayeredPane.DEFAULT_LAYER);
                this.add(pageViewDecorator);
                this.addPopupAnnotationAndGlue(abstractPageViewComponent);
            }
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void updateDocumentView() {
    }

    @Override
    public int getNextPageIncrement() {
        return 2;
    }

    @Override
    public int getPreviousPageIncrement() {
        return 2;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.currentPageChanger.mouseReleased(mouseEvent);
    }

    @Override
    public void dispose() {
        if (this.currentPageChanger != null) {
            this.currentPageChanger.dispose();
        }
        if (this.keyListenerPageChanger != null) {
            this.keyListenerPageChanger.uninstall();
        }
        this.removeAll();
        this.invalidate();
        super.dispose();
    }

    @Override
    public Dimension getDocumentSize() {
        int n;
        int n2;
        float f = 0.0f;
        float f2 = 0.0f;
        int n3 = this.getComponentCount();
        boolean bl = false;
        for (n2 = n = this.documentViewController.getCurrentPageIndex(); n2 >= 0 && n2 < n3; ++n2) {
            PageViewDecorator pageViewDecorator;
            PageViewComponent pageViewComponent;
            Component component = this.getComponent(n2);
            if (!(component instanceof PageViewDecorator) || (pageViewComponent = (pageViewDecorator = (PageViewDecorator)component).getPageViewComponent()).getPageIndex() != n) continue;
            Dimension dimension = pageViewDecorator.getPreferredSize();
            f = dimension.width;
            f2 = dimension.height;
            bl = true;
            break;
        }
        if (bl) {
            Component component;
            int n4;
            boolean bl2 = (n & 1) == 0;
            boolean bl3 = n2 != n;
            boolean bl4 = bl2 ^ bl3;
            int n5 = n4 = bl4 ? n2 + 1 : n2 - 1;
            if (n4 >= 0 && n4 < n3 && (component = this.getComponent(n4)) instanceof PageViewDecorator) {
                PageViewDecorator pageViewDecorator = (PageViewDecorator)component;
                Dimension dimension = pageViewDecorator.getPreferredSize();
                f = dimension.width;
                f2 = dimension.height;
            }
        }
        float f3 = this.documentViewController.getDocumentViewModel().getViewZoom();
        f = Math.abs(f / f3);
        f2 = Math.abs(f2 / f3);
        f *= 2.0f;
        return new Dimension((int)(f += 4.0f), (int)(f2 += 4.0f));
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(backgroundColour);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paintComponent(graphics);
    }
}

