/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.core.events.PageLoadingListener;
import org.icepdf.core.events.PaintPageEvent;
import org.icepdf.core.events.PaintPageListener;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.GraphicsRenderingHints;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.views.DocumentView;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.listeners.DefaultPageViewLoadingListener;

public abstract class AbstractPageViewComponent
extends JLayeredPane
implements PageViewComponent {
    private static final Logger logger = Logger.getLogger(AbstractPageViewComponent.class.toString());
    protected static final int PAGE_BOUNDARY_BOX = 2;
    private static Color pageColor;
    protected static int pageBufferPadding;
    protected static boolean progressivePaint;
    protected boolean paintAnnotations = true;
    protected final boolean paintSearchHighlight = false;
    protected DocumentView parentDocumentView;
    protected DocumentViewModel documentViewModel;
    protected DocumentViewController documentViewController;
    protected PageTree pageTree;
    protected int pageIndex;
    protected Rectangle pageSize;
    protected float pageZoom;
    protected float pageRotation;
    protected int pageBoundaryBox;
    protected PageBufferStore pageBufferStore;
    protected GraphicsConfiguration graphicsConfiguration;
    protected FutureTask<Object> pageImageCaptureTask;

    public AbstractPageViewComponent(DocumentViewModel documentViewModel, PageTree pageTree, int n, int n2, int n3) {
        this.documentViewModel = documentViewModel;
        this.pageTree = pageTree;
        this.pageIndex = n;
        if (documentViewModel != null) {
            this.pageZoom = documentViewModel.getViewZoom();
            this.pageRotation = documentViewModel.getViewRotation();
            this.pageBoundaryBox = documentViewModel.getPageBoundary();
        } else {
            this.pageZoom = 1.0f;
            this.pageRotation = 0.0f;
            this.pageBoundaryBox = 2;
        }
        this.pageBufferStore = new PageBufferStore();
        this.pageSize = new Rectangle();
        if (documentViewModel != null && n2 == 0 && n3 == 0) {
            this.calculatePageSize(this.pageSize, documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
        } else {
            this.pageSize.setSize(n2, n3);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.pageSize.getSize();
    }

    @Override
    public Dimension getSize() {
        return this.pageSize.getSize();
    }

    public void clearSelectedText() {
        Page page = this.getPage();
        if (page.isInitiated()) {
            try {
                if (page.getViewText() != null) {
                    page.getViewText().clearSelected();
                }
            }
            catch (InterruptedException interruptedException) {
                logger.finer("Text selection clear interrupted");
            }
        }
    }

    public void setSelectionRectangle(Point point, Rectangle rectangle) {
    }

    public void clearSelectionRectangle() {
    }

    public void reinitialize() {
        Page page = this.getPage();
        page.resetInitializedState();
        this.pageBufferStore.setDirty(true);
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    public Page getPage() {
        return this.pageTree.getPage(this.pageIndex);
    }

    @Override
    public void setDocumentViewCallback(DocumentView documentView) {
        this.parentDocumentView = documentView;
        this.documentViewController = this.parentDocumentView.getParentViewController();
    }

    public DocumentView getParentDocumentView() {
        return this.parentDocumentView;
    }

    public static boolean isAnnotationTool(int n) {
        return n == 6 || n == 7 || n == 8 || n == 10 || n == 11 || n == 9;
    }

    @Override
    public void updateView(String string, Object object, Object object2) {
        if (this.pageImageCaptureTask != null && !this.pageImageCaptureTask.isDone()) {
            this.pageImageCaptureTask.cancel(true);
        }
        if ("documentViewRotationChange".equals(string)) {
            this.pageRotation = ((Float)object2).floatValue();
        } else if ("documentViewZoomChange".equals(string)) {
            this.pageZoom = ((Float)object2).floatValue();
        } else if ("documentViewRefreshChange".equals(string)) {
            // empty if block
        }
        this.calculatePageSize(this.pageSize, this.pageRotation, this.pageZoom);
        this.pageBufferStore.setDirty(true);
    }

    private boolean isPageIntersectViewport() {
        Rectangle rectangle = this.documentViewModel != null && this.documentViewModel.getPageComponents() != null ? this.documentViewModel.getPageBounds(this.pageIndex) : this.getBounds();
        JScrollPane jScrollPane = this.documentViewModel.getDocumentViewScrollPane();
        return rectangle != null && this.isShowing() && rectangle.intersects(jScrollPane.getViewport().getViewRect());
    }

    protected void calculatePageSize(Rectangle rectangle, float f, float f2) {
        Page page;
        if (this.pageTree != null && (page = this.pageTree.getPage(this.pageIndex)) != null) {
            rectangle.setSize(page.getSize(this.pageBoundaryBox, f, f2).toDimension());
        }
    }

    protected static double calculateScaleForDefaultScreen() {
        try {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform().getScaleX();
        }
        catch (Exception exception) {
            return 1.0;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create(0, 0, this.pageSize.width, this.pageSize.height);
        GraphicsRenderingHints graphicsRenderingHints = GraphicsRenderingHints.getDefault();
        graphics2D.setRenderingHints(graphicsRenderingHints.getRenderingHints(1));
        this.calculateBufferLocation();
        graphics2D.setColor(pageColor);
        graphics2D.fillRect(0, 0, this.pageSize.width, this.pageSize.height);
        BufferedImage bufferedImage = this.pageBufferStore.getImageReference();
        if (bufferedImage != null) {
            Rectangle rectangle = this.pageBufferStore.getImageLocation();
            if (this.pageZoom != this.pageBufferStore.getPageZoom() || this.pageRotation != this.pageBufferStore.getPageRotation()) {
                graphics2D.transform(this.calculateBufferAffineTransform());
                this.pageBufferStore.setDirty(true);
                this.repaint();
            }
            graphics2D.drawImage(bufferedImage, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
        }
        graphics2D.dispose();
    }

    protected void calculateBufferLocation() {
        Rectangle rectangle;
        Rectangle rectangle2;
        JScrollPane jScrollPane = this.documentViewModel.getDocumentViewScrollPane();
        this.graphicsConfiguration = jScrollPane.getGraphicsConfiguration();
        this.calculatePageSize(this.pageSize, this.pageRotation, this.pageZoom);
        Rectangle rectangle3 = this.documentViewModel != null ? this.documentViewModel.getPageBounds(this.pageIndex) : new Rectangle(this.pageSize);
        Rectangle rectangle4 = jScrollPane.getViewport().getViewRect();
        if (rectangle3.width < rectangle4.width || rectangle3.height < rectangle4.height) {
            rectangle2 = new Rectangle(0, 0, rectangle3.width, rectangle3.height);
            rectangle = new Rectangle(rectangle2);
        } else {
            rectangle = rectangle4.intersection(rectangle3);
            rectangle.setLocation(rectangle.x - rectangle3.x, rectangle.y - rectangle3.y);
            rectangle2 = new Rectangle(rectangle.x - pageBufferPadding, rectangle.y - pageBufferPadding, rectangle.width + pageBufferPadding * 2, rectangle.height + pageBufferPadding * 2);
            if (this.pageImageCaptureTask != null && this.pageBufferStore.getImageLocation() != null) {
                Rectangle rectangle5 = new Rectangle(this.pageBufferStore.getImageLocation());
                rectangle5.setLocation(rectangle5.x + rectangle3.x, rectangle5.y + rectangle3.y);
                if (!rectangle5.contains(rectangle4.intersection(rectangle3))) {
                    this.pageBufferStore.setDirty(true);
                }
            }
        }
        if ((this.pageBufferStore.isDirty() || this.pageBufferStore.getImageReference() == null) && (this.pageImageCaptureTask == null || this.pageImageCaptureTask.isDone() || this.pageImageCaptureTask.isCancelled())) {
            this.pageImageCaptureTask = new FutureTask<Object>(new PageImageCaptureTask(this, rectangle2, rectangle, this.pageZoom, this.pageRotation));
            Library.execute(this.pageImageCaptureTask);
        }
    }

    private AffineTransform calculateBufferAffineTransform() {
        double d;
        AffineTransform affineTransform = new AffineTransform();
        if (this.pageZoom != this.pageBufferStore.getPageZoom()) {
            d = (double)this.pageZoom / (double)this.pageBufferStore.getPageZoom();
            affineTransform.scale(d, d);
        }
        if (this.pageRotation != this.pageBufferStore.getPageRotation()) {
            d = this.pageBufferStore.getPageRotation() - this.pageRotation;
            if (d < 0.0) {
                d += 360.0;
            }
            Rectangle rectangle = this.pageBufferStore.getPageSize();
            if (d == 90.0) {
                affineTransform.translate(rectangle.height, 0.0);
            } else if (d == 180.0) {
                affineTransform.translate(rectangle.width, 0.0);
            } else if (d == 270.0) {
                affineTransform.translate(rectangle.height, -rectangle.width);
            }
            double d2 = d * Math.PI / 180.0;
            affineTransform.rotate(d2);
        }
        return affineTransform;
    }

    static {
        try {
            String string = Defs.sysProperty((String)"org.icepdf.core.views.page.paper.color", (String)"#FFFFFF");
            int n = ColorUtil.convertColor((String)string);
            pageColor = new Color(n >= 0 ? n : Integer.parseInt("FFFFFF", 16));
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("Error reading page paper color.");
        }
        pageBufferPadding = Defs.intProperty((String)"org.icepdf.core.views.bufferpadding", (int)250);
        progressivePaint = Defs.booleanProperty((String)"org.icepdf.core.views.page.progressivePaint", (boolean)true);
    }

    protected static class PageBufferStore {
        private SoftReference<BufferedImage> imageReference;
        private Rectangle imageLocation;
        private Rectangle imageClipLocation;
        private float pageZoom;
        private float pageRotation;
        private Rectangle pageSize;
        private boolean isDirty;
        private final Object objectLock = new Object();

        PageBufferStore() {
            this.imageReference = new SoftReference<Object>(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setState(BufferedImage bufferedImage, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, float f, float f2, boolean bl) {
            Object object = this.objectLock;
            synchronized (object) {
                this.imageReference = new SoftReference<BufferedImage>(bufferedImage);
                this.imageLocation = rectangle;
                this.imageClipLocation = rectangle2;
                this.pageSize = rectangle3;
                this.pageZoom = f;
                this.pageRotation = f2;
                this.isDirty = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setImageReference(BufferedImage bufferedImage) {
            Object object = this.objectLock;
            synchronized (object) {
                this.imageReference = new SoftReference<BufferedImage>(bufferedImage);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage getImageReference() {
            Object object = this.objectLock;
            synchronized (object) {
                return this.imageReference.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Rectangle getImageLocation() {
            Object object = this.objectLock;
            synchronized (object) {
                return this.imageLocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Rectangle getImageClipLocation() {
            Object object = this.objectLock;
            synchronized (object) {
                return this.imageClipLocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Rectangle getPageSize() {
            Object object = this.objectLock;
            synchronized (object) {
                return this.pageSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        float getPageZoom() {
            Object object = this.objectLock;
            synchronized (object) {
                return this.pageZoom;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        float getPageRotation() {
            Object object = this.objectLock;
            synchronized (object) {
                return this.pageRotation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDirty() {
            Object object = this.objectLock;
            synchronized (object) {
                return this.isDirty;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDirty(boolean bl) {
            Object object = this.objectLock;
            synchronized (object) {
                this.isDirty = bl;
            }
        }
    }

    public class PageImageCaptureTask
    implements Callable<Object>,
    PaintPageListener {
        private final float zoom;
        private final float rotation;
        private final Rectangle imageLocation;
        private final Rectangle imageClipLocation;
        private final JComponent parent;

        public PageImageCaptureTask(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2, float f, float f2) {
            this.zoom = f;
            this.rotation = f2;
            this.parent = jComponent;
            this.imageLocation = rectangle;
            this.imageClipLocation = rectangle2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() {
            if (!AbstractPageViewComponent.this.isPageIntersectViewport()) {
                AbstractPageViewComponent.this.pageTeardownCallback();
                return null;
            }
            Page page = AbstractPageViewComponent.this.pageTree.getPage(AbstractPageViewComponent.this.pageIndex);
            DefaultPageViewLoadingListener defaultPageViewLoadingListener = new DefaultPageViewLoadingListener(this.parent, AbstractPageViewComponent.this.documentViewController);
            boolean bl = false;
            try {
                if (AbstractPageViewComponent.this.documentViewController != null && AbstractPageViewComponent.this.documentViewController.getDocumentViewModel() == null) {
                    Object var4_4 = null;
                    return var4_4;
                }
                if (AbstractPageViewComponent.this.documentViewController != null) {
                    page.addPageProcessingListener((PageLoadingListener)defaultPageViewLoadingListener);
                }
                page.init();
                AbstractPageViewComponent.this.pageInitializedCallback(page);
                double d = AbstractPageViewComponent.calculateScaleForDefaultScreen();
                BufferedImage bufferedImage = AbstractPageViewComponent.this.graphicsConfiguration.createCompatibleImage((int)((double)this.imageLocation.width * d), (int)((double)this.imageLocation.height * d), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.scale(d, d);
                if (progressivePaint && AbstractPageViewComponent.this.pageBufferStore.getImageReference() == null) {
                    page.addPaintPageListener((PaintPageListener)this);
                    bl = true;
                    AbstractPageViewComponent.this.pageBufferStore.setState(bufferedImage, this.imageLocation, this.imageClipLocation, AbstractPageViewComponent.this.pageSize, this.zoom, this.rotation, true);
                }
                graphics2D.setClip(0, 0, this.imageLocation.width, this.imageLocation.height);
                graphics2D.translate(-this.imageLocation.x, -this.imageLocation.y);
                page.paint((Graphics)graphics2D, 1, AbstractPageViewComponent.this.pageBoundaryBox, this.rotation, this.zoom, AbstractPageViewComponent.this.paintAnnotations, false);
                graphics2D.dispose();
                AbstractPageViewComponent.this.pageBufferStore.setState(bufferedImage, this.imageLocation, this.imageClipLocation, AbstractPageViewComponent.this.pageSize, this.zoom, this.rotation, false);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                logger.finer("Interrupted page capture task: " + interruptedException.getMessage() + " " + AbstractPageViewComponent.this.pageIndex);
                if (bl) {
                    AbstractPageViewComponent.this.pageBufferStore.setImageReference(null);
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Error during page capture task: " + exception.getMessage() + " " + AbstractPageViewComponent.this.pageIndex, exception);
            }
            finally {
                page.removePaintPageListener((PaintPageListener)this);
                page.removePageProcessingListener((PageLoadingListener)defaultPageViewLoadingListener);
            }
            SwingUtilities.invokeLater(AbstractPageViewComponent.this::repaint);
            this.notifyAll();
            return null;
        }

        public void paintPage(PaintPageEvent paintPageEvent) {
            SwingUtilities.invokeLater(AbstractPageViewComponent.this::repaint);
        }
    }
}

