/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.thumbs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.PageThumbnailComponent;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.ModifiedFlowLayout;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class ThumbnailsPanel
extends JPanel
implements MutableDocument {
    protected final ViewerPropertiesManager propertiesManager;
    protected float thumbNailZoom = 0.1f;
    protected static final int MAX_PAGE_SIZE_READ_AHEAD = 10;
    private final Controller controller;

    public ThumbnailsPanel(Controller controller, ViewerPropertiesManager viewerPropertiesManager) {
        this.controller = controller;
        this.propertiesManager = viewerPropertiesManager;
        if (viewerPropertiesManager != null) {
            this.thumbNailZoom = viewerPropertiesManager.getPreferences().getFloat("application.utilitypane.thumbnail.zoom", 1.0f);
        }
    }

    @Override
    public void refreshDocumentInstance() {
        Document document = this.controller.getDocument();
        if (document != null) {
            this.buildUI();
        } else {
            this.removeAll();
        }
    }

    @Override
    public void disposeDocument() {
        this.removeAll();
    }

    private void buildUI() {
        ModifiedFlowLayout modifiedFlowLayout = new ModifiedFlowLayout();
        JPanel jPanel = new JPanel(modifiedFlowLayout);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel, 22, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().addChangeListener(changeEvent -> {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            Dimension dimension = modifiedFlowLayout.computeSize(jViewport.getWidth(), jPanel);
            jPanel.setPreferredSize(dimension);
        });
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentEvent -> {
            if (!adjustmentEvent.getValueIsAdjusting()) {
                this.repaint();
            }
        });
        Document document = this.controller.getDocument();
        PageTree pageTree = document.getPageTree();
        int n = document.getNumberOfPages();
        int n2 = 0;
        int n3 = 0;
        DocumentViewControllerImpl documentViewControllerImpl = new DocumentViewControllerImpl((SwingController)this.controller);
        documentViewControllerImpl.setDocument(null);
        DocumentViewModel documentViewModel = documentViewControllerImpl.getDocumentViewModel();
        documentViewModel.setDocumentViewScrollPane(jScrollPane);
        for (int i = 0; i < n; ++i) {
            PageThumbnailComponent pageThumbnailComponent;
            if (i < 10) {
                pageThumbnailComponent = new PageThumbnailComponent(documentViewControllerImpl, documentViewModel, pageTree, i, this.thumbNailZoom);
                n2 += pageThumbnailComponent.getPreferredSize().width;
                n3 += pageThumbnailComponent.getPreferredSize().height;
            } else {
                pageThumbnailComponent = i > 10 ? new PageThumbnailComponent(documentViewControllerImpl, documentViewModel, pageTree, i, n2, n3, this.thumbNailZoom) : new PageThumbnailComponent(documentViewControllerImpl, documentViewModel, pageTree, i, n2 /= 10, n3 /= 10, this.thumbNailZoom);
            }
            jPanel.add(pageThumbnailComponent);
        }
        jPanel.revalidate();
        jScrollPane.validate();
    }
}

