/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.search;

import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.RedactionAnnotation;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.search.DocumentSearchController;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.utility.search.BaseRedactModel;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.RedactionAnnotationComponent;

public class RedactSearchTask
extends SwingWorker<Void, RedactResult> {
    private final int lengthOfTask;
    private int current;
    private String dialogMessage;
    private int redactionCount;
    private final Controller controller;
    private final Container viewContainer;
    private final BaseRedactModel redactModel;
    private MessageFormat redactingMessageForm;
    private MessageFormat redactCompletionMessageForm;

    public RedactSearchTask(Controller controller, BaseRedactModel baseRedactModel) {
        this.controller = controller;
        this.viewContainer = controller.getDocumentViewController().getViewContainer();
        this.lengthOfTask = controller.getDocument().getNumberOfPages();
        this.redactModel = baseRedactModel;
        if (baseRedactModel != null) {
            this.redactingMessageForm = baseRedactModel.setupRedactingMessageForm();
            this.redactCompletionMessageForm = baseRedactModel.setupRedactCompletionMessageForm();
        }
    }

    @Override
    protected Void doInBackground() {
        DocumentViewController documentViewController = this.controller.getDocumentViewController();
        DocumentSearchController documentSearchController = this.controller.getDocumentSearchController();
        Document document = this.controller.getDocument();
        int n = document.getNumberOfPages();
        this.redactionCount = 0;
        List<AbstractPageViewComponent> list = this.controller.getDocumentViewController().getDocumentViewModel().getPageComponents();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList;
            if (this.isCancelled()) {
                this.setDialogMessage();
                break;
            }
            this.current = i;
            Object[] objectArray = new Object[]{String.valueOf(this.current + 1), this.lengthOfTask, this.lengthOfTask};
            if (this.redactingMessageForm != null) {
                this.dialogMessage = this.redactingMessageForm.format(objectArray);
            }
            if ((arrayList = documentSearchController.searchPage(i)) == null) continue;
            AbstractPageViewComponent abstractPageViewComponent = list.get(i);
            for (WordText wordText : arrayList) {
                ++this.redactionCount;
                this.publish(new RedactResult());
                Rectangle rectangle = wordText.getBounds().getBounds();
                RedactionAnnotation redactionAnnotation = (RedactionAnnotation)AnnotationFactory.buildAnnotation((Library)document.getPageTree().getLibrary(), (Name)Annotation.SUBTYPE_REDACT, (Rectangle)rectangle);
                if (redactionAnnotation == null) continue;
                ArrayList<Rectangle> arrayList2 = new ArrayList<Rectangle>();
                arrayList2.add(rectangle);
                redactionAnnotation.setColor(Color.BLACK);
                redactionAnnotation.setMarkupBounds(arrayList2);
                redactionAnnotation.setMarkupPath(new GeneralPath(rectangle));
                redactionAnnotation.setBBox(rectangle);
                redactionAnnotation.resetAppearanceStream(new AffineTransform());
                if (abstractPageViewComponent.getPage().isInitiated()) {
                    SwingUtilities.invokeLater(() -> {
                        RedactionAnnotationComponent redactionAnnotationComponent = (RedactionAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)redactionAnnotation, documentViewController, abstractPageViewComponent);
                        redactionAnnotationComponent.refreshDirtyBounds();
                        documentViewController.addNewAnnotation(redactionAnnotationComponent);
                        abstractPageViewComponent.repaint();
                    });
                    continue;
                }
                abstractPageViewComponent.getPage().addAnnotation((Annotation)redactionAnnotation, true);
            }
        }
        this.setDialogMessage();
        return null;
    }

    private void setDialogMessage() {
        Object[] objectArray = new Object[]{String.valueOf(this.current + 1), this.current + 1, this.redactionCount};
        if (this.redactCompletionMessageForm != null) {
            this.dialogMessage = this.redactCompletionMessageForm.format(objectArray);
        }
    }

    @Override
    protected void done() {
        if (this.redactModel != null) {
            this.redactModel.updateProgressControls(this.dialogMessage);
        }
        this.viewContainer.validate();
    }

    @Override
    protected void process(List<RedactResult> list) {
        if (this.redactModel != null) {
            this.redactModel.updateProgressControls(this.dialogMessage);
        }
        this.viewContainer.repaint();
    }

    public static class RedactResult {
    }
}

