/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.outline;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.icepdf.ri.common.utility.outline.OutlineItemTreeNode;

class TreeTransferHandler
extends TransferHandler {
    protected static final Logger logger = Logger.getLogger(TreeTransferHandler.class.toString());
    DataFlavor nodesFlavor;
    DataFlavor[] flavors = new DataFlavor[1];
    OutlineItemTreeNode[] nodesToRemove;

    public TreeTransferHandler() {
        try {
            String string = "application/x-java-jvm-local-objectref;class=\"" + OutlineItemTreeNode[].class.getName() + "\"";
            this.flavors[0] = this.nodesFlavor = new DataFlavor(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.warning("ClassNotFound: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            return false;
        }
        transferSupport.setShowDropLocation(true);
        if (!transferSupport.isDataFlavorSupported(this.nodesFlavor)) {
            return false;
        }
        JTree.DropLocation dropLocation = (JTree.DropLocation)transferSupport.getDropLocation();
        JTree jTree = (JTree)transferSupport.getComponent();
        int n = jTree.getRowForPath(dropLocation.getPath());
        int[] nArray = jTree.getSelectionRows();
        for (int n2 : Objects.requireNonNull(nArray)) {
            if (n2 == n) {
                return false;
            }
            OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)jTree.getPathForRow(n2).getLastPathComponent();
            for (TreeNode treeNode : Collections.list(outlineItemTreeNode.depthFirstEnumeration())) {
                int n3 = jTree.getRowForPath(new TreePath(((OutlineItemTreeNode)treeNode).getPath()));
                if (n3 < 0 || n3 != n) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        ArrayList<OutlineItemTreeNode> arrayList = new ArrayList<OutlineItemTreeNode>();
        ArrayList<OutlineItemTreeNode> arrayList2 = new ArrayList<OutlineItemTreeNode>();
        OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)treePathArray[0].getLastPathComponent();
        LinkedHashSet<TreeNode> linkedHashSet = new LinkedHashSet<TreeNode>(treePathArray.length);
        OutlineItemTreeNode outlineItemTreeNode2 = this.copy(outlineItemTreeNode, linkedHashSet, jTree);
        arrayList.add(outlineItemTreeNode2);
        arrayList2.add(outlineItemTreeNode);
        for (int i = 1; i < treePathArray.length; ++i) {
            OutlineItemTreeNode outlineItemTreeNode3 = (OutlineItemTreeNode)treePathArray[i].getLastPathComponent();
            if (linkedHashSet.contains(outlineItemTreeNode3)) continue;
            if (outlineItemTreeNode3.getLevel() < outlineItemTreeNode.getLevel()) break;
            if (outlineItemTreeNode3.getLevel() > outlineItemTreeNode.getLevel()) {
                outlineItemTreeNode2.add(this.copy(outlineItemTreeNode3, linkedHashSet, jTree));
            } else {
                arrayList.add(this.copy(outlineItemTreeNode3, linkedHashSet, jTree));
                arrayList2.add(outlineItemTreeNode3);
            }
            linkedHashSet.add(outlineItemTreeNode3);
        }
        OutlineItemTreeNode[] outlineItemTreeNodeArray = arrayList.toArray(new OutlineItemTreeNode[0]);
        this.nodesToRemove = arrayList2.toArray(new OutlineItemTreeNode[0]);
        return new NodesTransferable(outlineItemTreeNodeArray);
    }

    private OutlineItemTreeNode copy(OutlineItemTreeNode outlineItemTreeNode, HashSet<TreeNode> hashSet, JTree jTree) {
        int n;
        OutlineItemTreeNode outlineItemTreeNode2 = new OutlineItemTreeNode(outlineItemTreeNode);
        hashSet.add(outlineItemTreeNode);
        for (n = 0; n < outlineItemTreeNode.getChildCount(); ++n) {
            outlineItemTreeNode2.add(this.copy((OutlineItemTreeNode)outlineItemTreeNode.getChildAt(n), hashSet, jTree));
        }
        n = jTree.getRowForPath(new TreePath(outlineItemTreeNode2.getPath()));
        jTree.expandRow(n);
        return outlineItemTreeNode2;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if ((n & 2) == 2) {
            JTree jTree = (JTree)jComponent;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
            for (OutlineItemTreeNode outlineItemTreeNode : this.nodesToRemove) {
                defaultTreeModel.removeNodeFromParent(outlineItemTreeNode);
            }
        }
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Object object;
        if (!this.canImport(transferSupport)) {
            return false;
        }
        OutlineItemTreeNode[] outlineItemTreeNodeArray = null;
        try {
            object = transferSupport.getTransferable();
            outlineItemTreeNodeArray = (OutlineItemTreeNode[])object.getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            logger.warning("UnsupportedFlavor: " + unsupportedFlavorException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            logger.warning("I/O error: " + iOException.getMessage());
            return false;
        }
        object = (JTree.DropLocation)transferSupport.getDropLocation();
        int n = ((JTree.DropLocation)object).getChildIndex();
        TreePath treePath = ((JTree.DropLocation)object).getPath();
        OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)treePath.getLastPathComponent();
        JTree jTree = (JTree)transferSupport.getComponent();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        int n2 = n;
        if (n == -1) {
            n2 = outlineItemTreeNode.getChildCount();
        }
        for (int i = 0; i < Objects.requireNonNull(outlineItemTreeNodeArray).length; ++i) {
            defaultTreeModel.insertNodeInto(outlineItemTreeNodeArray[i], outlineItemTreeNode, n2++);
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public class NodesTransferable
    implements Transferable {
        OutlineItemTreeNode[] nodes;

        public NodesTransferable(OutlineItemTreeNode[] outlineItemTreeNodeArray) {
            this.nodes = outlineItemTreeNodeArray;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return TreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return TreeTransferHandler.this.nodesFlavor.equals(dataFlavor);
        }
    }
}

