/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.outline;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.icepdf.core.pobjects.OutlineItem;
import org.icepdf.core.pobjects.Outlines;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.outline.OutlineDialog;
import org.icepdf.ri.common.utility.outline.OutlineItemTreeNode;

public class OutlinesPopupMenu
extends JPopupMenu
implements ActionListener {
    private final ResourceBundle messageBundle;
    private final JTree parentTree;
    private final OutlineItemTreeNode node;
    private JMenuItem addMenuItem;
    private JMenuItem editMenuItem;
    private JMenuItem deleteMenuItem;
    private SwingController controller;

    public OutlinesPopupMenu(SwingController swingController, JTree jTree, OutlineItemTreeNode outlineItemTreeNode) {
        this.parentTree = jTree;
        this.node = outlineItemTreeNode;
        this.controller = swingController;
        this.messageBundle = this.controller.getMessageBundle();
        this.buildGui();
    }

    private void buildGui() {
        this.addMenuItem = new JMenuItem(this.messageBundle.getString("viewer.utilityPane.outline.contextMenu.add.label"));
        this.addMenuItem.addActionListener(this);
        this.add(this.addMenuItem);
        this.editMenuItem = new JMenuItem(this.messageBundle.getString("viewer.utilityPane.outline.contextMenu.edit.label"));
        this.editMenuItem.addActionListener(this);
        this.add(this.editMenuItem);
        this.deleteMenuItem = new JMenuItem(this.messageBundle.getString("viewer.utilityPane.outline.contextMenu.delete.label"));
        this.deleteMenuItem.addActionListener(this);
        this.add(this.deleteMenuItem);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.addMenuItem) {
            OutlineItem outlineItem = Outlines.createNewOutlineItem((Library)this.controller.getDocument().getCatalog().getLibrary());
            outlineItem.setTitle(this.messageBundle.getString("viewer.utilityPane.outline.contextMenu.new.label"));
            OutlineItemTreeNode outlineItemTreeNode = new OutlineItemTreeNode(outlineItem);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.parentTree.getModel();
            OutlineItemTreeNode outlineItemTreeNode2 = (OutlineItemTreeNode)this.node.getParent();
            defaultTreeModel.insertNodeInto(outlineItemTreeNode, outlineItemTreeNode2, outlineItemTreeNode2.getIndex(this.node) + 1);
            new OutlineDialog(this.controller, this.parentTree, outlineItemTreeNode, true).setVisible(true);
        } else if (object == this.editMenuItem) {
            new OutlineDialog(this.controller, this.parentTree, this.node).setVisible(true);
        } else if (object == this.deleteMenuItem) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.parentTree.getModel();
            defaultTreeModel.removeNodeFromParent(this.node);
            this.markNodeForDeletion(this.node);
        }
    }

    public void markNodeForDeletion(OutlineItemTreeNode outlineItemTreeNode) {
        OutlineItem outlineItem = outlineItemTreeNode.getOutlineItem();
        outlineItem.setDeleted(true);
        for (int i = 0; i < outlineItemTreeNode.getChildCount(); ++i) {
            this.markNodeForDeletion((OutlineItemTreeNode)outlineItemTreeNode.getChildAt(i));
        }
    }
}

