/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.RgbColorChooser;

public class LineAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener,
ChangeListener {
    private static final int DEFAULT_START_END_TYPE = 0;
    private static final int DEFAULT_END_END_TYPE = 0;
    private static final int DEFAULT_LINE_THICKNESS = 0;
    private static final int DEFAULT_LINE_STYLE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.DARK_GRAY;
    private static final Color DEFAULT_FILL_COLOR = Color.DARK_GRAY;
    private static ValueLabelItem[] END_TYPE_LIST;
    private JComboBox<ValueLabelItem> startEndTypeBox;
    private JComboBox<ValueLabelItem> endEndTypeBox;
    private JComboBox<ValueLabelItem> lineThicknessBox;
    private JComboBox<ValueLabelItem> lineStyleBox;
    private JButton colorButton;
    private JButton internalColorButton;
    private JSlider transparencySlider;
    private LineAnnotation annotation;

    public LineAnnotationPanel(Controller controller) {
        super(controller);
        this.setLayout(new GridBagLayout());
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (annotationComponent == null || annotationComponent.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = annotationComponent;
        this.annotation = (LineAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.startEndTypeBox, this.annotation.getStartArrow());
        this.applySelectedValue(this.endEndTypeBox, this.annotation.getEndArrow());
        this.applySelectedValue(this.lineThicknessBox, Float.valueOf(this.annotation.getLineThickness()));
        this.applySelectedValue(this.lineStyleBox, this.annotation.getLineStyle());
        this.setButtonBackgroundColor(this.colorButton, this.annotation.getColor());
        this.setButtonBackgroundColor(this.internalColorButton, this.annotation.getInteriorColor());
        this.transparencySlider.setValue(Math.round(this.annotation.getOpacity() * 255.0f));
        this.safeEnable(this.startEndTypeBox, true);
        this.safeEnable(this.endEndTypeBox, true);
        this.safeEnable(this.lineThicknessBox, true);
        this.safeEnable(this.lineStyleBox, true);
        this.safeEnable(this.colorButton, true);
        this.safeEnable(this.internalColorButton, true);
        this.safeEnable(this.transparencySlider, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ValueLabelItem valueLabelItem = (ValueLabelItem)itemEvent.getItem();
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.startEndTypeBox) {
                this.annotation.setStartArrow((Name)valueLabelItem.getValue());
            } else if (itemEvent.getSource() == this.endEndTypeBox) {
                this.annotation.setEndArrow((Name)valueLabelItem.getValue());
            } else if (itemEvent.getSource() == this.lineThicknessBox) {
                this.annotation.getBorderStyle().setStrokeWidth(((Float)valueLabelItem.getValue()).floatValue());
            } else if (itemEvent.getSource() == this.lineStyleBox) {
                this.annotation.getBorderStyle().setBorderStyle((Name)valueLabelItem.getValue());
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getSource() == this.colorButton) {
            Color color2 = RgbColorChooser.showDialog(this.colorButton, this.messageBundle.getString("viewer.utilityPane.annotation.line.colorChooserTitle"), this.colorButton.getBackground());
            if (color2 != null) {
                this.colorButton.setBackground(color2);
                this.annotation.setColor(color2);
                this.updateCurrentAnnotation();
                this.currentAnnotationComponent.resetAppearanceShapes();
                this.currentAnnotationComponent.repaint();
                this.preferences.putInt("application.viewer.preference.annotation.line.color", color2.getRGB());
            }
        } else if (actionEvent.getSource() == this.internalColorButton && (color = RgbColorChooser.showDialog(this.internalColorButton, this.messageBundle.getString("viewer.utilityPane.annotation.line.colorInternalChooserTitle"), this.internalColorButton.getBackground())) != null) {
            this.internalColorButton.setBackground(color);
            this.annotation.setInteriorColor(color);
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
            this.preferences.putInt("application.viewer.preference.annotation.line.fill.color", color.getRGB());
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.alphaSliderChange(changeEvent, (MarkupAnnotation)this.annotation, "application.viewer.preference.annotation.line.fill.opcity");
    }

    private void createGUI() {
        if (END_TYPE_LIST == null) {
            END_TYPE_LIST = new ValueLabelItem[]{new ValueLabelItem(LineAnnotation.LINE_END_NONE, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.none")), new ValueLabelItem(LineAnnotation.LINE_END_OPEN_ARROW, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.openArrow")), new ValueLabelItem(LineAnnotation.LINE_END_CLOSED_ARROW, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.closedArrow")), new ValueLabelItem(LineAnnotation.LINE_END_DIAMOND, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.diamond")), new ValueLabelItem(LineAnnotation.LINE_END_SQUARE, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.square")), new ValueLabelItem(LineAnnotation.LINE_END_CIRCLE, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.circle"))};
        }
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.line.appearance.title"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 2, 1, 2);
        this.startEndTypeBox = new JComboBox<ValueLabelItem>(END_TYPE_LIST);
        this.startEndTypeBox.setSelectedIndex(0);
        this.startEndTypeBox.addItemListener(this);
        JLabel jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.startStyle"));
        this.addGB(this, jLabel, 0, 0, 1, 1);
        this.addGB(this, this.startEndTypeBox, 1, 0, 1, 1);
        this.endEndTypeBox = new JComboBox<ValueLabelItem>(END_TYPE_LIST);
        this.endEndTypeBox.setSelectedIndex(0);
        this.endEndTypeBox.addItemListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.endStyle"));
        this.addGB(this, jLabel, 0, 1, 1, 1);
        this.addGB(this, this.endEndTypeBox, 1, 1, 1, 1);
        this.lineThicknessBox = new JComboBox<ValueLabelItem>(LINE_THICKNESS_LIST);
        this.lineThicknessBox.setSelectedIndex(0);
        this.lineThicknessBox.addItemListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.lineThickness"));
        this.addGB(this, jLabel, 0, 2, 1, 1);
        this.addGB(this, this.lineThicknessBox, 1, 2, 1, 1);
        this.lineStyleBox = new JComboBox<ValueLabelItem>(LINE_STYLE_LIST);
        this.lineStyleBox.setSelectedIndex(0);
        this.lineStyleBox.addItemListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.lineStyle"));
        this.addGB(this, jLabel, 0, 3, 1, 1);
        this.addGB(this, this.lineStyleBox, 1, 3, 1, 1);
        this.colorButton = new JButton(" ");
        this.colorButton.addActionListener(this);
        this.colorButton.setOpaque(true);
        this.colorButton.setBackground(DEFAULT_BORDER_COLOR);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.colorLabel"));
        this.addGB(this, jLabel, 0, 4, 1, 1);
        this.addGB(this, this.colorButton, 1, 4, 1, 1);
        this.internalColorButton = new JButton(" ");
        this.internalColorButton.addActionListener(this);
        this.internalColorButton.setOpaque(true);
        this.internalColorButton.setBackground(DEFAULT_FILL_COLOR);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.colorInternalLabel"));
        this.addGB(this, jLabel, 0, 5, 1, 1);
        this.addGB(this, this.internalColorButton, 1, 5, 1, 1);
        this.transparencySlider = this.buildAlphaSlider();
        this.transparencySlider.setMajorTickSpacing(255);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.addChangeListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.transparencyLabel"));
        this.addGB(this, jLabel, 0, 6, 1, 1);
        this.addGB(this, this.transparencySlider, 1, 6, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 7, 1, 1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.safeEnable(this.startEndTypeBox, bl);
        this.safeEnable(this.endEndTypeBox, bl);
        this.safeEnable(this.lineThicknessBox, bl);
        this.safeEnable(this.lineStyleBox, bl);
        this.safeEnable(this.colorButton, bl);
        this.safeEnable(this.internalColorButton, bl);
        this.safeEnable(this.transparencySlider, bl);
    }

    protected boolean safeEnable(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            jComponent.setEnabled(bl);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox jComboBox, Object object) {
        jComboBox.removeItemListener(this);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)jComboBox.getItemAt(i);
            if (!valueLabelItem.getValue().equals(object)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        jComboBox.addItemListener(this);
    }
}

