/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.RgbColorChooser;

public class InkAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener,
ChangeListener {
    private static final int DEFAULT_LINE_THICKNESS = 0;
    private static final int DEFAULT_LINE_STYLE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.RED;
    private JComboBox<ValueLabelItem> lineThicknessBox;
    private JComboBox<ValueLabelItem> lineStyleBox;
    private JButton colorBorderButton;
    private JSlider transparencySlider;
    private InkAnnotation annotation;

    public InkAnnotationPanel(Controller controller) {
        super(controller);
        this.setLayout(new GridBagLayout());
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (annotationComponent == null || annotationComponent.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = annotationComponent;
        this.annotation = (InkAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.lineThicknessBox, Float.valueOf(this.annotation.getLineThickness()));
        this.applySelectedValue(this.lineStyleBox, this.annotation.getLineStyle());
        this.setButtonBackgroundColor(this.colorBorderButton, this.annotation.getColor());
        this.transparencySlider.setValue(Math.round(this.annotation.getOpacity() * 255.0f));
        this.safeEnable(this.lineThicknessBox, true);
        this.safeEnable(this.lineStyleBox, true);
        this.safeEnable(this.colorBorderButton, true);
        this.safeEnable(this.transparencySlider, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ValueLabelItem valueLabelItem = (ValueLabelItem)itemEvent.getItem();
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.lineThicknessBox) {
                this.annotation.getBorderStyle().setStrokeWidth(((Float)valueLabelItem.getValue()).floatValue());
            } else if (itemEvent.getSource() == this.lineStyleBox) {
                this.annotation.getBorderStyle().setBorderStyle((Name)valueLabelItem.getValue());
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getSource() == this.colorBorderButton && (color = RgbColorChooser.showDialog(this.colorBorderButton, this.messageBundle.getString("viewer.utilityPane.annotation.ink.colorBorderChooserTitle"), this.colorBorderButton.getBackground())) != null) {
            this.colorBorderButton.setBackground(color);
            this.annotation.setColor(color);
            this.preferences.putInt("application.viewer.preference.annotation.ink.color", color.getRGB());
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.alphaSliderChange(changeEvent, (MarkupAnnotation)this.annotation, "application.viewer.preference.annotation.ink.opacity");
    }

    private void createGUI() {
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.ink.appearance.title"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 2, 1, 2);
        this.lineThicknessBox = new JComboBox<ValueLabelItem>(LINE_THICKNESS_LIST);
        this.lineThicknessBox.setSelectedIndex(0);
        this.lineThicknessBox.addItemListener(this);
        JLabel jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.ink.lineThickness"));
        this.addGB(this, jLabel, 0, 0, 1, 1);
        this.addGB(this, this.lineThicknessBox, 1, 0, 1, 1);
        this.lineStyleBox = new JComboBox<ValueLabelItem>(LINE_STYLE_LIST);
        this.lineStyleBox.setSelectedIndex(0);
        this.lineStyleBox.addItemListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.ink.lineStyle"));
        this.addGB(this, jLabel, 0, 1, 1, 1);
        this.addGB(this, this.lineStyleBox, 1, 1, 1, 1);
        this.colorBorderButton = new JButton(" ");
        this.colorBorderButton.addActionListener(this);
        this.colorBorderButton.setOpaque(true);
        this.colorBorderButton.setBackground(DEFAULT_BORDER_COLOR);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.ink.colorBorderLabel"));
        this.addGB(this, jLabel, 0, 2, 1, 1);
        this.addGB(this, this.colorBorderButton, 1, 2, 1, 1);
        this.transparencySlider = this.buildAlphaSlider();
        this.transparencySlider.setMajorTickSpacing(255);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.addChangeListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.ink.transparencyLabel"));
        this.addGB(this, jLabel, 0, 3, 1, 1);
        this.addGB(this, this.transparencySlider, 1, 3, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 4, 1, 1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.safeEnable(this.lineThicknessBox, bl);
        this.safeEnable(this.lineStyleBox, bl);
        this.safeEnable(this.colorBorderButton, bl);
        this.safeEnable(this.transparencySlider, bl);
    }

    protected boolean safeEnable(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            jComponent.setEnabled(bl);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox jComboBox, Object object) {
        jComboBox.removeItemListener(this);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)jComboBox.getItemAt(i);
            if (!valueLabelItem.getValue().equals(object)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        jComboBox.addItemListener(this);
    }
}

