/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.actions.ActionFactory;
import org.icepdf.core.pobjects.actions.GoToAction;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.utility.annotation.destinations.ImplicitDestinationPanel;
import org.icepdf.ri.common.utility.annotation.properties.ActionsPanel;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationDialogAdapter;
import org.icepdf.ri.common.utility.annotation.properties.NameTreeDialog;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;

public class GoToActionDialog
extends AnnotationDialogAdapter
implements ActionListener,
ItemListener {
    public static final String EMPTY_DESTINATION = "      ";
    private final Controller controller;
    private final ResourceBundle messageBundle;
    private AnnotationComponent currentAnnotation;
    private final ActionsPanel actionsPanel;
    private GridBagConstraints constraints;
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton implicitDestination;
    private JRadioButton namedDestination;
    private JLabel destinationName;
    private JButton viewNamedDesButton;
    private NameTreeDialog nameTreeDialog;
    private ImplicitDestinationPanel implicitDestinationPanel;

    public GoToActionDialog(Controller controller, ActionsPanel actionsPanel) {
        super(controller.getViewerFrame(), true);
        this.controller = controller;
        this.messageBundle = this.controller.getMessageBundle();
        this.actionsPanel = actionsPanel;
        this.setTitle(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.title"));
        this.setGui();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        this.currentAnnotation = annotationComponent;
        Action action = this.currentAnnotation.getAnnotation().getAction();
        Destination destination = null;
        if (action instanceof GoToAction) {
            destination = ((GoToAction)action).getDestination();
        } else if (action == null && this.currentAnnotation.getAnnotation() instanceof LinkAnnotation) {
            LinkAnnotation linkAnnotation = (LinkAnnotation)this.currentAnnotation.getAnnotation();
            destination = linkAnnotation.getDestination();
        }
        if (this.controller.getDocument().getCatalog().getNames() == null || this.controller.getDocument().getCatalog().getNames().getDestsNameTree() == null) {
            this.implicitDestinationFieldsEnabled(true);
            this.clearImplicitDestinations(true);
            this.namedDestination.setEnabled(false);
        } else {
            this.namedDestination.setEnabled(true);
        }
        if (destination != null) {
            this.clearImplicitDestinations(false);
            this.clearImplicitDestinations(true);
            if (destination.getNamedDestination() == null) {
                this.implicitDestinationPanel.setAnnotationComponent(annotationComponent);
            } else {
                this.implicitDestinationFieldsEnabled(false);
                this.destinationName.setText(destination.getNamedDestination());
            }
        }
    }

    private void saveActionState() {
        Annotation annotation = this.currentAnnotation.getAnnotation();
        Destination destination = this.implicitDestination.isSelected() ? this.implicitDestinationPanel.getDestination(annotation.getLibrary()) : new Destination(annotation.getLibrary(), (Object)new LiteralStringObject(this.destinationName.getText()));
        GoToAction goToAction = (GoToAction)annotation.getAction();
        if (goToAction == null) {
            goToAction = (GoToAction)ActionFactory.buildAction((Library)annotation.getLibrary(), (int)1);
            if (goToAction != null) {
                goToAction.setDestination(destination);
                annotation.addAction((Action)goToAction);
                this.actionsPanel.clearActionList();
                this.actionsPanel.addActionToList((Action)goToAction);
            }
        } else {
            goToAction.setDestination(destination);
            annotation.updateAction((Action)goToAction);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.saveActionState();
            this.dispose();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.dispose();
        } else if (actionEvent.getSource() == this.viewNamedDesButton) {
            this.namedDestination.setSelected(true);
            NameTree nameTree = this.controller.getDocument().getCatalog().getNames().getDestsNameTree();
            if (nameTree != null) {
                this.nameTreeDialog = new NameTreeDialog(this.controller, true, nameTree);
                this.nameTreeDialog.setDestinationName(this.destinationName.getText());
                this.nameTreeDialog.setVisible(true);
                this.nameTreeDialog.dispose();
            }
        }
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        super.dispose();
        if (this.nameTreeDialog != null) {
            this.nameTreeDialog.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if ((itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) && itemEvent.getSource() == this.implicitDestination) {
            this.implicitDestinationFieldsEnabled(itemEvent.getStateChange() == 1);
            if (this.implicitDestination.isSelected()) {
                this.implicitDestinationPanel.setDefaultState();
            }
        }
    }

    private void setGui() {
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentY(0.0f);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 13;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.implicitDestinationPanel = new ImplicitDestinationPanel(this.controller);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        this.implicitDestination = new JRadioButton(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.explicitDestination.title"), true);
        this.implicitDestination.addItemListener(this);
        jPanel2.add((Component)this.implicitDestination, "North");
        jPanel2.add((Component)this.implicitDestinationPanel, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel3.setBorder(new EmptyBorder(0, 40, 0, 0));
        jPanel3.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.name.label")));
        this.destinationName = new JLabel(EMPTY_DESTINATION);
        jPanel3.add(this.destinationName);
        this.viewNamedDesButton = new JButton(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.browse"));
        this.viewNamedDesButton.addActionListener(this);
        jPanel3.add(this.viewNamedDesButton);
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        this.namedDestination = new JRadioButton(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.nameDestination.title"), false);
        jPanel4.add((Component)this.namedDestination, "North");
        jPanel4.add((Component)jPanel3, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.implicitDestination);
        buttonGroup.add(this.namedDestination);
        this.okButton = new JButton(this.messageBundle.getString("viewer.button.ok.label"));
        this.okButton.setMnemonic(this.messageBundle.getString("viewer.button.ok.mnemonic").charAt(0));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(this.messageBundle.getString("viewer.button.cancel.label"));
        this.cancelButton.setMnemonic(this.messageBundle.getString("viewer.button.cancel.mnemonic").charAt(0));
        this.cancelButton.addActionListener(this);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.add(this.okButton);
        jPanel5.add(this.cancelButton);
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.anchor = 17;
        this.addGB(jPanel, jPanel2, 0, 0, 1, 1);
        this.addGB(jPanel, jPanel4, 0, 1, 1, 1);
        this.constraints.insets = new Insets(15, 5, 5, 5);
        this.constraints.anchor = 10;
        this.addGB(jPanel, jPanel5, 0, 2, 1, 1);
        this.getContentPane().add(jPanel);
        this.setSize(new Dimension(500, 325));
        this.setLocationRelativeTo(this.controller.getViewerFrame());
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    private void implicitDestinationFieldsEnabled(boolean bl) {
        this.implicitDestination.setSelected(bl);
        this.namedDestination.setSelected(!bl);
        this.implicitDestinationPanel.setEnabled(bl);
        this.destinationName.setEnabled(!bl);
        this.viewNamedDesButton.setEnabled(!bl);
    }

    private void clearImplicitDestinations(boolean bl) {
        if (!bl) {
            this.implicitDestinationPanel.clearImplicitDestinations();
        } else {
            this.destinationName.setText(EMPTY_DESTINATION);
        }
    }
}

