/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.destinations;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.actions.GoToAction;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.FloatTextFieldInputVerifier;
import org.icepdf.ri.common.FloatTextFieldKeyListener;
import org.icepdf.ri.common.PageNumberTextFieldInputVerifier;
import org.icepdf.ri.common.PageNumberTextFieldKeyListener;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationProperties;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;

public class ImplicitDestinationPanel
extends JPanel
implements ItemListener,
AnnotationProperties {
    private final Controller controller;
    private final ResourceBundle messageBundle;
    private JComboBox implicitDestTypeComboBox;
    private JTextField pageNumberTextField;
    private JTextField topTextField;
    private JTextField bottomTextField;
    private JTextField leftTextField;
    private JTextField rightTextField;
    private JTextField zoomTextField;
    private GridBagConstraints constraints;

    public ImplicitDestinationPanel(Controller controller) {
        this.controller = controller;
        this.messageBundle = this.controller.getMessageBundle();
        this.setGui();
    }

    private void setGui() {
        this.setAlignmentY(0.0f);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 13;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.setLayout(new GridLayout(4, 4, 10, 5));
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.label")));
        this.implicitDestTypeComboBox = this.buildImplicitDestTypes();
        this.implicitDestTypeComboBox.addItemListener(this);
        this.add(this.implicitDestTypeComboBox);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.page.label")));
        this.pageNumberTextField = this.buildDocumentPageNumbers();
        this.add(this.pageNumberTextField);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.top.label")));
        this.topTextField = this.buildFloatTextField();
        this.add(this.topTextField);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.bottom.label")));
        this.bottomTextField = this.buildFloatTextField();
        this.add(this.bottomTextField);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.left.label")));
        this.leftTextField = this.buildFloatTextField();
        this.add(this.leftTextField);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.right.label")));
        this.rightTextField = this.buildFloatTextField();
        this.add(this.rightTextField);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.zoom.label")));
        this.zoomTextField = this.buildFloatTextField();
        this.add(this.zoomTextField);
        this.add(new JLabel());
        this.add(new JLabel());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.implicitDestTypeComboBox) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)itemEvent.getItem();
            Name name = (Name)valueLabelItem.getValue();
            this.enableFitTypeFields(name);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.implicitDestinationFieldsEnabled(bl);
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        LinkAnnotation linkAnnotation;
        Action action = annotationComponent.getAnnotation().getAction();
        Destination destination = null;
        if (action instanceof GoToAction) {
            destination = ((GoToAction)action).getDestination();
        } else if (action == null && annotationComponent.getAnnotation() instanceof LinkAnnotation) {
            linkAnnotation = (LinkAnnotation)annotationComponent.getAnnotation();
            destination = linkAnnotation.getDestination();
        }
        if (destination != null) {
            this.clearImplicitDestinations();
            if (destination.getNamedDestination() == null) {
                this.implicitDestinationFieldsEnabled(true);
                linkAnnotation = destination.getType();
                this.applySelectedValue(this.implicitDestTypeComboBox, linkAnnotation);
                this.enableFitTypeFields((Name)linkAnnotation);
                this.applyTypeValues(destination, (Name)linkAnnotation);
                this.pageNumberTextField.setText(String.valueOf(this.controller.getDocument().getPageTree().getPageNumber(destination.getPageReference()) + 1));
            }
        }
    }

    public void setDefaultState() {
        if (this.implicitDestTypeComboBox.getSelectedItem() == null) {
            this.applySelectedValue(this.implicitDestTypeComboBox, Destination.TYPE_FIT);
            this.enableFitTypeFields(Destination.TYPE_FIT);
        } else {
            Name name = (Name)((ValueLabelItem)this.implicitDestTypeComboBox.getSelectedItem()).getValue();
            this.enableFitTypeFields(name);
        }
    }

    public void setDestination(Destination destination) {
        if (destination == null) {
            return;
        }
        this.applyTypeValues(destination, null);
        Name name = destination.getType();
        if (name == null) {
            name = Destination.TYPE_XYZ;
        }
        this.enableFitTypeFields(name);
        Reference reference = destination.getPageReference();
        if (reference != null) {
            int n = this.controller.getDocument().getPageTree().getPageNumber(reference) + 1;
            this.pageNumberTextField.setText(String.valueOf(n));
        }
    }

    public Destination getDestination(Library library) {
        Name name = (Name)((ValueLabelItem)this.implicitDestTypeComboBox.getSelectedItem()).getValue();
        int n = Integer.parseInt(this.pageNumberTextField.getText());
        Reference reference = this.controller.getDocument().getPageTree().getPageReference(n - 1);
        List list = null;
        if (name.equals(Destination.TYPE_FIT) || name.equals(Destination.TYPE_FITB)) {
            list = Destination.destinationSyntax((Reference)reference, (Name)name);
        } else if (name.equals(Destination.TYPE_FITH) || name.equals(Destination.TYPE_FITBH) || name.equals(Destination.TYPE_FITV) || name.equals(Destination.TYPE_FITBV)) {
            Object object = this.parseDestCoordinate(this.topTextField.getText());
            list = Destination.destinationSyntax((Reference)reference, (Name)name, (Object)object);
        } else if (name.equals(Destination.TYPE_XYZ)) {
            Object object = this.parseDestCoordinate(this.leftTextField.getText());
            Object object2 = this.parseDestCoordinate(this.topTextField.getText());
            Object object3 = this.parseDestCoordinate(this.zoomTextField.getText());
            list = Destination.destinationSyntax((Reference)reference, (Object)name, (Object)object, (Object)object2, (Object)object3);
        } else if (name.equals(Destination.TYPE_FITR)) {
            Object object = this.parseDestCoordinate(this.leftTextField.getText());
            Object object4 = this.parseDestCoordinate(this.leftTextField.getText());
            Object object5 = this.parseDestCoordinate(this.leftTextField.getText());
            Object object6 = this.parseDestCoordinate(this.leftTextField.getText());
            list = Destination.destinationSyntax((Reference)reference, (Object)name, (Object)object, (Object)object4, (Object)object5, (Object)object6);
        }
        return new Destination(library, (Object)list);
    }

    private void applyTypeValues(Destination destination, Name name) {
        if (name == null) {
            name = destination.getType();
        }
        if (Destination.TYPE_XYZ.equals(name)) {
            this.leftTextField.setText(this.getDestCoordinate(destination.getLeft()));
            this.topTextField.setText(this.getDestCoordinate(destination.getTop()));
            this.zoomTextField.setText(this.getDestCoordinate(destination.getZoom()));
        } else if (!Destination.TYPE_FIT.equals(name)) {
            if (Destination.TYPE_FITH.equals(name)) {
                this.topTextField.setText(this.getDestCoordinate(destination.getTop()));
            } else if (Destination.TYPE_FITV.equals(name)) {
                this.leftTextField.setText(this.getDestCoordinate(destination.getLeft()));
            } else if (Destination.TYPE_FITR.equals(name)) {
                this.leftTextField.setText(this.getDestCoordinate(destination.getLeft()));
                this.rightTextField.setText(this.getDestCoordinate(destination.getRight()));
                this.topTextField.setText(this.getDestCoordinate(destination.getTop()));
                this.bottomTextField.setText(this.getDestCoordinate(destination.getBottom()));
            } else if (!Destination.TYPE_FITB.equals(name)) {
                if (Destination.TYPE_FITH.equals(name)) {
                    this.topTextField.setText(this.getDestCoordinate(destination.getTop()));
                } else if (Destination.TYPE_FITBV.equals(name)) {
                    this.leftTextField.setText(this.getDestCoordinate(destination.getLeft()));
                }
            }
        }
    }

    private void enableFitTypeFields(Name name) {
        if (name.equals(Destination.TYPE_FIT) || name.equals(Destination.TYPE_FITB)) {
            this.setFitTypesEnabled(false, false, false, false, false);
        } else if (name.equals(Destination.TYPE_FITH) || name.equals(Destination.TYPE_FITBH)) {
            this.setFitTypesEnabled(true, false, false, false, false);
        } else if (name.equals(Destination.TYPE_FITV) || name.equals(Destination.TYPE_FITBV)) {
            this.setFitTypesEnabled(false, false, true, false, false);
        } else if (name.equals(Destination.TYPE_XYZ)) {
            this.setFitTypesEnabled(true, false, true, false, true);
        } else if (name.equals(Destination.TYPE_FITR)) {
            this.setFitTypesEnabled(true, true, true, true, false);
        }
    }

    private void setFitTypesEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.topTextField.setEnabled(bl);
        this.bottomTextField.setEnabled(bl2);
        this.leftTextField.setEnabled(bl3);
        this.rightTextField.setEnabled(bl4);
        this.zoomTextField.setEnabled(bl5);
    }

    private JComboBox<ValueLabelItem> buildImplicitDestTypes() {
        ValueLabelItem[] valueLabelItemArray = new ValueLabelItem[]{new ValueLabelItem(Destination.TYPE_XYZ, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.xyz.label")), new ValueLabelItem(Destination.TYPE_FITH, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fith.label")), new ValueLabelItem(Destination.TYPE_FITR, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitr.label")), new ValueLabelItem(Destination.TYPE_FIT, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fit.label")), new ValueLabelItem(Destination.TYPE_FITB, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitb.label")), new ValueLabelItem(Destination.TYPE_FITBH, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitbh.label")), new ValueLabelItem(Destination.TYPE_FITBV, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitbv.label")), new ValueLabelItem(Destination.TYPE_FITBV, this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.type.fitbv.label"))};
        return new JComboBox<ValueLabelItem>(valueLabelItemArray);
    }

    private JTextField buildFloatTextField() {
        final JTextField jTextField = new JTextField();
        jTextField.setInputVerifier(new FloatTextFieldInputVerifier());
        jTextField.addKeyListener(new FloatTextFieldKeyListener());
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Object object = focusEvent.getSource();
                if (object == null) {
                    return;
                }
                if (object == jTextField) {
                    String string = jTextField.getText();
                    if ("".equals(string)) {
                        return;
                    }
                    float f = Float.parseFloat(string);
                    jTextField.setText(String.valueOf(f));
                }
            }
        });
        return jTextField;
    }

    private JTextField buildDocumentPageNumbers() {
        final JTextField jTextField = new JTextField();
        jTextField.setInputVerifier(new PageNumberTextFieldInputVerifier());
        jTextField.addKeyListener(new PageNumberTextFieldKeyListener());
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                int n;
                String string;
                int n2;
                Object object = focusEvent.getSource();
                if (object == null) {
                    return;
                }
                if (object == jTextField && (n2 = Integer.parseInt(string = jTextField.getText())) > (n = ImplicitDestinationPanel.this.controller.getDocument().getNumberOfPages())) {
                    jTextField.setText(String.valueOf(n));
                }
            }
        });
        jTextField.setText("1");
        return jTextField;
    }

    private void implicitDestinationFieldsEnabled(boolean bl) {
        this.pageNumberTextField.setEnabled(bl);
        this.implicitDestTypeComboBox.setEnabled(bl);
        this.leftTextField.setEnabled(bl);
        this.topTextField.setEnabled(bl);
        this.zoomTextField.setEnabled(bl);
    }

    private Object parseDestCoordinate(String string) {
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private String getDestCoordinate(Float f) {
        if (f != null) {
            return String.valueOf(f);
        }
        return "";
    }

    private void applySelectedValue(JComboBox jComboBox, Object object) {
        jComboBox.removeItemListener(this);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)jComboBox.getItemAt(i);
            if (!valueLabelItem.getValue().equals(object)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        jComboBox.addItemListener(this);
    }

    public void clearImplicitDestinations() {
        this.pageNumberTextField.setText("");
        this.implicitDestTypeComboBox.setSelectedIndex(-1);
        this.leftTextField.setText("");
        this.topTextField.setText("");
        this.zoomTextField.setText("");
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

