/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.destinations.DestinationsPanel;
import org.icepdf.ri.common.utility.annotation.markup.MarkupAnnotationPanel;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class AnnotationPanel
extends JPanel
implements MutableDocument {
    private final GridBagConstraints constraints;
    private final JTabbedPane annotationTabbedPane = new JTabbedPane(1);
    private MarkupAnnotationPanel markupAnnotationPanel;
    private DestinationsPanel destinationsPanel;

    public AnnotationPanel(SwingController swingController) {
        this.annotationTabbedPane.setAlignmentY(0.0f);
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.addGB(this, this.annotationTabbedPane, 0, 0, 1, 1);
    }

    public void addMarkupAnnotationPanel(MarkupAnnotationPanel markupAnnotationPanel, String string) {
        this.markupAnnotationPanel = markupAnnotationPanel;
        this.markupAnnotationPanel.setParentPanel(this);
        this.annotationTabbedPane.add((Component)this.markupAnnotationPanel, string);
    }

    public void addDestinationPanel(DestinationsPanel destinationsPanel, String string) {
        this.destinationsPanel = destinationsPanel;
        this.destinationsPanel.setParentPanel(this);
        this.annotationTabbedPane.add((Component)this.destinationsPanel, string);
    }

    @Override
    public void refreshDocumentInstance() {
        if (this.markupAnnotationPanel != null) {
            this.markupAnnotationPanel.refreshDocumentInstance();
        }
        if (this.destinationsPanel != null) {
            this.destinationsPanel.refreshDocumentInstance();
        }
    }

    @Override
    public void disposeDocument() {
        if (this.markupAnnotationPanel != null) {
            this.markupAnnotationPanel.disposeDocument();
        }
        if (this.destinationsPanel != null) {
            this.destinationsPanel.disposeDocument();
        }
    }

    public void setSelectedTab(String string) {
        ViewerPropertiesManager viewerPropertiesManager = ViewerPropertiesManager.getInstance();
        if ("application.utilitypane.show.annotation.markup".equals(string)) {
            this.annotationTabbedPane.setSelectedIndex(0);
        } else if ("application.utilitypane.show.annotation.dests".equals(string)) {
            this.annotationTabbedPane.setSelectedIndex(1);
        } else {
            this.annotationTabbedPane.setSelectedIndex(0);
        }
    }

    public MarkupAnnotationPanel getMarkupAnnotationPanel() {
        return this.markupAnnotationPanel;
    }

    public DestinationsPanel getDestinationsPanel() {
        return this.destinationsPanel;
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

