/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.CircleAnnotation;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.core.pobjects.annotations.TextAnnotation;
import org.icepdf.core.pobjects.annotations.TextMarkupAnnotation;
import org.icepdf.core.pobjects.annotations.TextWidgetAnnotation;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.CompoundIcon;
import org.icepdf.ri.common.utility.annotation.AnnotationTreeNode;
import org.icepdf.ri.common.widgets.ColorOverlayIcon;
import org.icepdf.ri.images.IconPack;
import org.icepdf.ri.images.Images;

public class AnnotationCellRender
extends DefaultTreeCellRenderer {
    public static final Icon ANNOTATION_TEXT_ICON = Images.getSingleIcon("annot_text_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final Icon ANNOTATION_HIGHLIGHT_ICON = Images.getSingleIcon("annot_highlight_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final Icon ANNOTATION_CROSS_OUT_ICON = Images.getSingleIcon("annot_cross_out_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final Icon ANNOTATION_UNDERLINE_ICON = Images.getSingleIcon("annot_underline_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final Icon ANNOTATION_FREE_TEXT_ICON = Images.getSingleIcon("annot_free_text_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final Icon ANNOTATION_LINE_ICON = Images.getSingleIcon("annot_line_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final Icon ANNOTATION_CIRCLE_ICON = Images.getSingleIcon("annot_circle_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final Icon ANNOTATION_SQUARE_ICON = Images.getSingleIcon("annot_square_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final Icon ANNOTATION_INK_ICON = Images.getSingleIcon("annot_ink_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final Icon ANNOTATION_LINK_ICON = Images.getSingleIcon("annot_link_tree", IconPack.Variant.NONE, Images.IconSize.SMALL);
    public static final GeneralPath squareColorOutline = new GeneralPath();
    public static final GeneralPath circleColorOutline;
    public static final GeneralPath textColorOutline;
    public static final GeneralPath highlightColorOutline;
    public static final GeneralPath inkColorOutline;
    public static final GeneralPath strikeOutColorOutline;
    public static final GeneralPath underlineColorOutline;
    public static final GeneralPath lineColorOutline;

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Icon icon;
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        Annotation annotation = null;
        if (object instanceof AnnotationTreeNode) {
            annotation = ((AnnotationTreeNode)object).getAnnotation();
        }
        if (annotation instanceof TextAnnotation) {
            icon = new ColorOverlayIcon(Images.getSingleIcon("annot_text_c_tree", IconPack.Variant.NONE, Images.IconSize.SMALL));
            ((ColorOverlayIcon)icon).setColor(annotation.getColor());
            ((ColorOverlayIcon)icon).setColorBound(textColorOutline);
            this.setIcon(icon);
        } else if (annotation instanceof LinkAnnotation) {
            this.setIcon(ANNOTATION_LINK_ICON);
        } else if (annotation instanceof FreeTextAnnotation) {
            this.setIcon(ANNOTATION_FREE_TEXT_ICON);
        } else if (annotation instanceof LineAnnotation) {
            icon = new ColorOverlayIcon(Images.getSingleIcon("annot_line_c_tree", IconPack.Variant.NONE, Images.IconSize.SMALL));
            ((ColorOverlayIcon)icon).setColor(annotation.getColor(), 1.0f, false, false);
            ((ColorOverlayIcon)icon).setColorBound(lineColorOutline);
            this.setIcon(icon);
        } else if (annotation instanceof SquareAnnotation) {
            icon = new ColorOverlayIcon(Images.getSingleIcon("annot_square_c_tree", IconPack.Variant.NONE, Images.IconSize.SMALL));
            ((ColorOverlayIcon)icon).setColor(annotation.getColor(), 1.0f, false, false);
            ((ColorOverlayIcon)icon).setColorBound(squareColorOutline);
            this.setIcon(icon);
        } else if (annotation instanceof CircleAnnotation) {
            icon = new ColorOverlayIcon(Images.getSingleIcon("annot_circle_c_tree", IconPack.Variant.NONE, Images.IconSize.SMALL));
            ((ColorOverlayIcon)icon).setColor(annotation.getColor(), 1.0f, false, false);
            ((ColorOverlayIcon)icon).setColorBound(circleColorOutline);
            this.setIcon(icon);
        } else if (annotation instanceof TextMarkupAnnotation) {
            if (annotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_HIGHLIGHT)) {
                icon = new ColorOverlayIcon(Images.getSingleIcon("annot_highlight_c_tree", IconPack.Variant.NONE, Images.IconSize.SMALL));
                ((ColorOverlayIcon)icon).setColor(annotation.getColor());
                ((ColorOverlayIcon)icon).setBack(false);
                ((ColorOverlayIcon)icon).setColorBound(highlightColorOutline);
                this.setIcon(icon);
            } else if (annotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_SQUIGGLY)) {
                this.setIcon(ANNOTATION_UNDERLINE_ICON);
            } else if (annotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_STRIKE_OUT)) {
                icon = new ColorOverlayIcon(Images.getSingleIcon("annot_cross_out_c_tree", IconPack.Variant.NONE, Images.IconSize.SMALL));
                ((ColorOverlayIcon)icon).setColor(annotation.getColor(), 1.0f, true, true);
                ((ColorOverlayIcon)icon).setColorBound(strikeOutColorOutline);
                this.setIcon(icon);
            } else if (annotation.getSubType().equals(TextMarkupAnnotation.SUBTYPE_UNDERLINE)) {
                icon = new ColorOverlayIcon(Images.getSingleIcon("annot_underline_c_tree", IconPack.Variant.NONE, Images.IconSize.SMALL));
                ((ColorOverlayIcon)icon).setColor(annotation.getColor(), 1.0f, true, false);
                ((ColorOverlayIcon)icon).setColorBound(underlineColorOutline);
                this.setIcon(icon);
            }
        } else if (annotation instanceof InkAnnotation) {
            icon = new ColorOverlayIcon(Images.getSingleIcon("annot_ink_c_tree", IconPack.Variant.NONE, Images.IconSize.SMALL));
            ((ColorOverlayIcon)icon).setColor(annotation.getColor());
            ((ColorOverlayIcon)icon).setColorBound(inkColorOutline);
            this.setIcon(icon);
        } else if (annotation instanceof TextWidgetAnnotation) {
            icon = Images.getSingleIcon("form_highlight", IconPack.Variant.NORMAL, Images.IconSize.SMALL);
            this.setIcon(icon);
        } else if (annotation != null) {
            this.setLeafIcon(null);
            this.setOpenIcon(null);
            this.setClosedIcon(null);
        } else if (object instanceof DefaultMutableTreeNode) {
            icon = Images.getSingleIcon("page", IconPack.Variant.NONE, Images.IconSize.TINY);
            this.setOpenIcon(icon);
            this.setClosedIcon(icon);
            this.setLeafIcon(icon);
        }
        if (SystemProperties.PRIVATE_PROPERTY_ENABLED && annotation != null && !(annotation instanceof TextWidgetAnnotation)) {
            icon = annotation.getFlagPrivateContents() ? Images.getSingleIcon("lock", IconPack.Variant.NONE, Images.IconSize.TINY) : Images.getSingleIcon("unlock", IconPack.Variant.NONE, Images.IconSize.TINY);
            CompoundIcon compoundIcon = new CompoundIcon(this.getIcon(), icon);
            this.setIcon(compoundIcon);
        }
        return this;
    }

    static {
        squareColorOutline.moveTo(5.0f, 2.0f);
        squareColorOutline.lineTo(19.0f, 2.0f);
        squareColorOutline.lineTo(19.0f, 15.0f);
        squareColorOutline.lineTo(5.0f, 15.0f);
        squareColorOutline.closePath();
        circleColorOutline = new GeneralPath();
        circleColorOutline.moveTo(0.0f, 0.0f);
        circleColorOutline.curveTo(0.0, -4.265, -3.458, -7.723, -7.723, -7.723);
        circleColorOutline.curveTo(-11.988, -7.723, -15.446, -4.265, -15.446, 0.0);
        circleColorOutline.curveTo(-15.446, 4.265, -11.988, 7.723, -7.723, 7.723);
        circleColorOutline.curveTo(-3.458, 7.723, 0.0, 4.265, 0.0, 0.0);
        circleColorOutline.closePath();
        circleColorOutline.transform(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 19.0f, 9.0f));
        textColorOutline = new GeneralPath();
        textColorOutline.moveTo(0.0f, 0.0f);
        textColorOutline.curveTo(1.174, -0.335, 2.021, -0.404, 3.362, -0.404);
        textColorOutline.curveTo(8.999, -0.404, 13.569, 2.853, 13.569, 6.869);
        textColorOutline.curveTo(13.569, 10.886, 8.999, 14.142, 3.362, 14.142);
        textColorOutline.curveTo(-2.275, 14.142, -6.845, 10.886, -6.845, 6.869);
        textColorOutline.curveTo(-6.845, 4.847, -5.687, 3.017, -3.818, 1.699);
        textColorOutline.curveTo((double)((float)textColorOutline.getCurrentPoint().getX()), (double)((float)textColorOutline.getCurrentPoint().getY()), -3.732, 0.684, -4.097, -0.404);
        textColorOutline.curveTo(-4.574, -1.822, -5.002, -2.235, -5.002, -2.235);
        textColorOutline.curveTo((double)((float)textColorOutline.getCurrentPoint().getX()), (double)((float)textColorOutline.getCurrentPoint().getY()), -3.801, -2.235, -2.107, -1.557);
        textColorOutline.curveTo(-0.571, -0.94, 0.0, 0.0, 0.0, 0.0);
        textColorOutline.transform(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 8.0f, 16.0f));
        textColorOutline.closePath();
        inkColorOutline = new GeneralPath();
        inkColorOutline.moveTo(7.0f, 11.0f);
        inkColorOutline.lineTo(15.0f, 3.0f);
        inkColorOutline.lineTo(18.0f, 5.0f);
        inkColorOutline.lineTo(8.0f, 14.0f);
        inkColorOutline.closePath();
        highlightColorOutline = new GeneralPath();
        highlightColorOutline.moveTo(3.0f, 2.0f);
        highlightColorOutline.lineTo(13.0f, 2.0f);
        highlightColorOutline.lineTo(13.0f, 12.0f);
        highlightColorOutline.lineTo(3.0f, 12.0f);
        highlightColorOutline.closePath();
        strikeOutColorOutline = new GeneralPath();
        strikeOutColorOutline.moveTo(3.0f, 7.0f);
        strikeOutColorOutline.lineTo(20.0f, 7.0f);
        strikeOutColorOutline.lineTo(20.0f, 9.0f);
        strikeOutColorOutline.lineTo(3.0f, 9.0f);
        strikeOutColorOutline.closePath();
        underlineColorOutline = new GeneralPath();
        underlineColorOutline.moveTo(4.0f, 15.0f);
        underlineColorOutline.lineTo(20.0f, 15.0f);
        underlineColorOutline.lineTo(20.0f, 17.0f);
        underlineColorOutline.lineTo(4.0f, 17.0f);
        underlineColorOutline.closePath();
        lineColorOutline = new GeneralPath();
        lineColorOutline.moveTo(20.0f, 6.0f);
        lineColorOutline.lineTo(16.0f, 1.0f);
        lineColorOutline.lineTo(9.0f, 1.0f);
        lineColorOutline.lineTo(3.0f, 7.0f);
        lineColorOutline.lineTo(7.0f, 15.0f);
        lineColorOutline.lineTo(11.0f, 11.0f);
    }
}

