/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public class SquareAnnotationHandler
extends SelectionBoxHandler
implements ToolHandler {
    private static final Logger logger;
    protected static final float DEFAULT_STROKE_WIDTH = 3.0f;
    private static final BasicStroke stroke;
    private static final float strokeWidth;
    private static Color lineColor;
    private static Color internalColor;
    private static final boolean useInternalColor;
    private static int defaultOpacity;
    protected Rectangle rectangle;
    protected final BorderStyle borderStyle = new BorderStyle();

    public SquareAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        this.borderStyle.setStrokeWidth(3.0f);
        this.checkAndApplyPreferences();
    }

    @Override
    public void paintTool(Graphics graphics) {
        if (this.rectangle != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(SquareAnnotationHandler.stroke);
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)defaultOpacity / 255.0f));
            if (useInternalColor) {
                graphics2D.setColor(internalColor);
                graphics2D.fill(this.rectangle);
            }
            graphics2D.setColor(lineColor);
            graphics2D.draw(this.rectangle);
            graphics.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkAndApplyPreferences();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.rectangle == null) {
            this.rectangle = new Rectangle();
        }
        this.currentRect = new Rectangle(n, n2, 0, 0);
        this.updateDrawableRect(this.pageViewComponent.getWidth(), this.pageViewComponent.getHeight());
        this.rectangle.setRect(this.currentRect);
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
        this.rectangle = this.convertToPageSpace(this.rectangle);
        this.rectToDraw.setRect(this.rectToDraw.getX() - 3.0, this.rectToDraw.getY() - 3.0, this.rectToDraw.getWidth() + 6.0, this.rectToDraw.getHeight() + 6.0);
        Rectangle rectangle = this.convertToPageSpace(this.rectToDraw);
        SquareAnnotation squareAnnotation = (SquareAnnotation)AnnotationFactory.buildAnnotation((Library)this.documentViewController.getDocument().getPageTree().getLibrary(), (Name)Annotation.SUBTYPE_SQUARE, (Rectangle)rectangle);
        ViewModel viewModel = this.documentViewController.getParentController().getViewModel();
        squareAnnotation.setFlag(1024, !viewModel.getAnnotationPrivacy());
        squareAnnotation.setCreationDate(PDate.formatDateTime((Date)new Date()));
        squareAnnotation.setTitleText(SystemProperties.USER_NAME);
        squareAnnotation.setColor(lineColor);
        squareAnnotation.setOpacity(defaultOpacity);
        if (squareAnnotation.isFillColor() || useInternalColor) {
            squareAnnotation.setFillColor(internalColor);
            if (!squareAnnotation.isFillColor()) {
                squareAnnotation.setFillColor(true);
            }
        }
        this.borderStyle.setStrokeWidth(strokeWidth);
        squareAnnotation.setRectangle(this.rectangle);
        squareAnnotation.setBorderStyle(this.borderStyle);
        AffineTransform affineTransform = this.getToPageSpaceTransform();
        AffineTransform affineTransform2 = this.getPageTransform();
        squareAnnotation.setBBox(new Rectangle(0, 0, rectangle.width, rectangle.height));
        squareAnnotation.resetAppearanceStream(affineTransform);
        MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)squareAnnotation, this.documentViewController, this.pageViewComponent);
        Rectangle rectangle2 = new Rectangle(this.rectToDraw.x, this.rectToDraw.y, this.rectToDraw.width, this.rectToDraw.height);
        markupAnnotationComponent.setBounds(rectangle2);
        markupAnnotationComponent.refreshAnnotationRect();
        this.documentViewController.addNewAnnotation(markupAnnotationComponent);
        PopupAnnotationComponent popupAnnotationComponent = markupAnnotationComponent.getPopupAnnotationComponent();
        popupAnnotationComponent.setBoundsRelativeToParent(rectangle2.x + rectangle2.width / 2, rectangle2.y + rectangle2.height / 2, affineTransform2);
        popupAnnotationComponent.setVisible(false);
        ((PopupAnnotation)popupAnnotationComponent.getAnnotation()).setOpen(false);
        this.documentViewController.getParentController().setDocumentToolMode(this.preferences.getInt("application.annotation.rectangle.selection.type", 0));
        this.rectangle = null;
        this.clearRectangle(this.pageViewComponent);
    }

    @Override
    protected void checkAndApplyPreferences() {
        defaultOpacity = this.preferences.getInt("application.viewer.preference.annotation.square.fill.opacity", defaultOpacity);
        lineColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.square.color", lineColor.getRGB()));
        internalColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.square.fill.color", internalColor.getRGB()));
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
        this.rectangle.setRect(this.rectToDraw);
        this.pageViewComponent.repaint();
    }

    @Override
    public void setSelectionRectangle(Point point, Rectangle rectangle) {
    }

    static {
        block5: {
            int n;
            String string;
            block4: {
                logger = Logger.getLogger(SquareAnnotationHandler.class.toString());
                try {
                    string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.square.stroke.color", (String)"#ff0000");
                    n = ColorUtil.convertColor((String)string);
                    lineColor = new Color(n >= 0 ? n : Integer.parseInt("ff0000", 16));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.warning("Error reading squareAnnotation stroke colour");
                }
            }
            useInternalColor = Defs.booleanProperty((String)"org.icepdf.core.views.page.annotation.square.fill.enabled", (boolean)false);
            try {
                string = Defs.sysProperty((String)"org.icepdf.core.views.page.annotation.square.fill.color", (String)"#ffffff");
                n = ColorUtil.convertColor((String)string);
                internalColor = new Color(n >= 0 ? n : Integer.parseInt("ffffff", 16));
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.warning("Error reading square Annotation fill colour");
            }
        }
        defaultOpacity = Defs.intProperty((String)"org.icepdf.core.views.page.annotation.square.fill.opacity", (int)255);
        strokeWidth = (float)Defs.doubleProperty((String)"org.icepdf.core.views.page.annotation.square.stroke.width", (double)3.0);
        stroke = new BasicStroke(strokeWidth, 0, 0, 1.0f);
    }
}

