/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Timer;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.common.tools.TextSelectionPageHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;

public class HighLightAnnotationHandler
extends TextSelectionPageHandler
implements ActionListener,
KeyListener {
    protected static boolean enableHighlightContents;
    private static final int MULTI_CLICK_INTERVAL;
    private MouseEvent lastMouseClickEvent;
    private final Timer mouseClickTimer;
    protected Name markupSubType = Annotation.SUBTYPE_HIGHLIGHT;
    protected MarkupAnnotation annotation;

    public HighLightAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        this.mouseClickTimer = new Timer(MULTI_CLICK_INTERVAL, this);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.cancelSelection();
            this.documentViewController.clearSelectedText();
            this.pageViewComponent.revalidate();
            this.pageViewComponent.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void installTool() {
        super.installTool();
        this.pageViewComponent.addKeyListener(this);
    }

    @Override
    public void uninstallTool() {
        super.uninstallTool();
        this.pageViewComponent.removeKeyListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.mouseClickTimer.stop();
        this.createMarkupAnnotationFromTextSelection(this.lastMouseClickEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        int n = mouseEvent.getClickCount();
        if (n == 1 || mouseEvent.getClickCount() > 3) {
            this.mouseClickTimer.stop();
            return;
        }
        this.lastMouseClickEvent = mouseEvent;
        if (n == 2 && !this.mouseClickTimer.isRunning()) {
            this.mouseClickTimer.restart();
        } else if (n == 3) {
            this.mouseClickTimer.stop();
            this.createMarkupAnnotationFromTextSelection(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isMouseDrag) {
            this.createMarkupAnnotationFromTextSelection(mouseEvent);
        }
        super.mouseReleased(mouseEvent);
        this.documentViewController.clearSelectedText();
    }

    public void createMarkupAnnotation(ArrayList<Shape> arrayList) {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        if (documentViewModel.isSelectAll()) {
            this.documentViewController.clearSelectedText();
            return;
        }
        if (arrayList == null) {
            arrayList = HighLightAnnotationHandler.getSelectedTextBounds(this.pageViewComponent, this.getPageTransform());
        }
        String string = enableHighlightContents && arrayList != null ? this.getSelectedText() : "";
        this.documentViewController.clearSelectedText();
        if (arrayList != null && !arrayList.isEmpty()) {
            Shape shape2;
            GeneralPath generalPath = new GeneralPath();
            for (Shape shape2 : arrayList) {
                generalPath.append(shape2, false);
            }
            Rectangle rectangle = generalPath.getBounds();
            shape2 = this.convertToPageSpace(arrayList, generalPath);
            AffineTransform affineTransform = this.getToPageSpaceTransform();
            AffineTransform affineTransform2 = this.getPageTransform();
            this.annotation = (MarkupAnnotation)AnnotationFactory.buildAnnotation((Library)documentViewModel.getDocument().getPageTree().getLibrary(), (Name)this.markupSubType, (Rectangle)shape2);
            ViewModel viewModel = this.documentViewController.getParentController().getViewModel();
            this.annotation.setFlag(1024, !viewModel.getAnnotationPrivacy());
            this.annotation.setContents(string != null && enableHighlightContents ? string : this.markupSubType.toString());
            this.checkAndApplyPreferences();
            this.annotation.setCreationDate(PDate.formatDateTime((Date)new Date()));
            this.annotation.setTitleText(SystemProperties.USER_NAME);
            this.annotation.setMarkupBounds(arrayList);
            this.annotation.setMarkupPath(generalPath);
            this.annotation.setBBox((Rectangle)shape2);
            this.annotation.resetAppearanceStream(affineTransform);
            MarkupAnnotationComponent markupAnnotationComponent = (MarkupAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)this.annotation, this.documentViewController, this.pageViewComponent);
            this.documentViewController.addNewAnnotation(markupAnnotationComponent);
            markupAnnotationComponent.setBounds(rectangle);
            Rectangle2D.Float float_ = this.annotation.getUserSpaceRectangle();
            this.annotation.syncBBoxToUserSpaceRectangle((Rectangle2D)float_);
            PopupAnnotationComponent popupAnnotationComponent = markupAnnotationComponent.getPopupAnnotationComponent();
            popupAnnotationComponent.setBoundsRelativeToParent(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2, affineTransform2);
            popupAnnotationComponent.setVisible(false);
            ((PopupAnnotation)popupAnnotationComponent.getAnnotation()).setOpen(false);
        }
        this.pageViewComponent.repaint();
    }

    @Override
    protected void checkAndApplyPreferences() {
        Color color = null;
        if (this.preferences.getInt("application.viewer.preference.annotation.highlight.color", -1) != -1) {
            int n = this.preferences.getInt("application.viewer.preference.annotation.highlight.color", 0);
            color = new Color(n);
        }
        if (color != null) {
            this.annotation.setColor(color);
        }
        this.annotation.setOpacity(this.preferences.getInt("application.viewer.preference.annotation.highlight.opacity", 80));
    }

    protected String getSelectedText() {
        Page page = this.pageViewComponent.getPage();
        String string = null;
        try {
            string = page.getViewText().getSelected().toString();
            string = string.replaceAll("[\\s\\p{Z}]", " ");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.fine("HighLightAnnotation initialization interrupted.");
        }
        return string;
    }

    protected void createMarkupAnnotationFromTextSelection(MouseEvent mouseEvent) {
        ArrayList<Shape> arrayList = HighLightAnnotationHandler.getSelectedTextBounds(this.pageViewComponent, this.getPageTransform());
        this.createMarkupAnnotation(arrayList);
        this.documentViewController.getParentController().setDocumentToolMode(this.preferences.getInt("application.annotation.highlight.selection.type", 0));
    }

    public static ArrayList<Shape> getSelectedTextBounds(AbstractPageViewComponent abstractPageViewComponent, AffineTransform affineTransform) {
        Page page = abstractPageViewComponent.getPage();
        ArrayList<Rectangle2D> arrayList = null;
        if (page != null && page.isInitiated()) {
            try {
                ArrayList arrayList2;
                PageText pageText = page.getViewText();
                if (pageText != null && (arrayList2 = pageText.getPageLines()) != null) {
                    for (LineText lineText : arrayList2) {
                        List list = lineText.getWords();
                        Rectangle2D rectangle2D = null;
                        if (arrayList == null) {
                            arrayList = new ArrayList<Rectangle2D>();
                        }
                        if (list == null) continue;
                        for (WordText wordText : list) {
                            GeneralPath generalPath;
                            if (wordText.isSelected() || wordText.isHighlighted()) {
                                generalPath = new GeneralPath(wordText.getBounds());
                                generalPath.transform(affineTransform);
                                if (!wordText.isSelected()) continue;
                                if (rectangle2D == null) {
                                    rectangle2D = generalPath.getBounds2D();
                                    continue;
                                }
                                rectangle2D.add(generalPath.getBounds2D());
                                continue;
                            }
                            for (GlyphText glyphText : wordText.getGlyphs()) {
                                if (!glyphText.isSelected()) continue;
                                generalPath = new GeneralPath(glyphText.getBounds());
                                generalPath.transform(affineTransform);
                                if (rectangle2D == null) {
                                    rectangle2D = generalPath.getBounds2D();
                                    continue;
                                }
                                rectangle2D.add(generalPath.getBounds2D());
                            }
                        }
                        if (rectangle2D == null) continue;
                        arrayList.add(rectangle2D.getBounds2D());
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                logger.fine("HighLightAnnotation selected text bounds calculation interrupted.");
            }
        }
        return arrayList;
    }

    static {
        MULTI_CLICK_INTERVAL = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        try {
            enableHighlightContents = Defs.booleanProperty((String)"org.icepdf.core.views.page.annotation.highlightContent.enabled", (boolean)true);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("Error reading highlight selection content enabled property.");
        }
    }
}

