/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.ri.common.tools.TextSelection;

class GlyphLocation {
    private final int line;
    private final int word;
    private final int glyph;

    public GlyphLocation(int n, int n2, int n3) {
        this.line = n;
        this.word = n2;
        this.glyph = n3;
    }

    public GlyphLocation(GlyphLocation glyphLocation) {
        this.line = glyphLocation.line;
        this.word = glyphLocation.word;
        this.glyph = glyphLocation.glyph;
    }

    public String toString() {
        return "GlyphLocation{line=" + this.line + ", word=" + this.word + ", glyph=" + this.glyph + "}";
    }

    public static WordText getWord(ArrayList<LineText> arrayList, GlyphLocation glyphLocation) {
        return (WordText)arrayList.get(glyphLocation.line).getWords().get(glyphLocation.word);
    }

    public static GlyphText getGlyph(ArrayList<LineText> arrayList, GlyphLocation glyphLocation) {
        return (GlyphText)((WordText)arrayList.get(glyphLocation.line).getWords().get(glyphLocation.word)).getGlyphs().get(glyphLocation.glyph);
    }

    public static GlyphLocation multiPageSelectGlyphLocation(ArrayList<LineText> arrayList, Point2D.Float float_, boolean bl, boolean bl2, Shape shape, Shape shape2) {
        if (arrayList == null) {
            return null;
        }
        if (bl && bl2) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (!GlyphLocation.isLineTextIncluded(arrayList.get(i), shape, shape2) || !GlyphLocation.findMouseContainedWithInLine(float_, arrayList.get(i))) continue;
                return new GlyphLocation(i, 0, 0);
            }
        } else if (bl) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (!GlyphLocation.isLineTextIncluded(arrayList.get(i), shape, shape2) || !GlyphLocation.findMouseContainedWithInLine(float_, arrayList.get(i))) continue;
                int n2 = arrayList.get(i).getWords().size() - 1;
                WordText wordText = (WordText)arrayList.get(i).getWords().get(n2);
                return new GlyphLocation(i, n2, wordText.getGlyphs().size() - 1);
            }
        } else {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                if (!GlyphLocation.isLineTextIncluded(arrayList.get(i), shape, shape2) || !GlyphLocation.findMouseContainedWithInLine(float_, arrayList.get(i))) continue;
                int n = arrayList.get(i).getWords().size() - 1;
                WordText wordText = (WordText)arrayList.get(i).getWords().get(n);
                return new GlyphLocation(i, n, wordText.getGlyphs().size() - 1);
            }
        }
        return null;
    }

    public static boolean isLineTextIncluded(LineText lineText, Shape shape, Shape shape2) {
        return !TextSelection.enableMarginExclusion || !shape.contains(lineText.getBounds()) && !shape2.contains(lineText.getBounds());
    }

    public static GlyphLocation findGlyphLocation(ArrayList<LineText> arrayList, Point2D.Float float_, boolean bl, boolean bl2, GlyphLocation glyphLocation, Shape shape, Shape shape2) {
        block10: {
            double d;
            block11: {
                if (arrayList == null) break block10;
                GlyphLocation glyphLocation2 = GlyphLocation.findGlyphIntersection(arrayList, float_, shape, shape2);
                if (glyphLocation2 != null) {
                    return glyphLocation2;
                }
                if (!bl2) break block11;
                int n = 0;
                if (glyphLocation != null) {
                    n = glyphLocation.line;
                }
                int n2 = arrayList.size();
                for (int i = n; i < n2 - 1; ++i) {
                    LineText lineText;
                    double d2 = arrayList.get((int)i).getBounds().y;
                    double d3 = arrayList.get((int)(i + 1)).getBounds().y;
                    if (!((double)float_.y < d2) || !((double)float_.y >= d3) || !GlyphLocation.isLineTextIncluded(lineText = arrayList.get(i + 1), shape, shape2)) continue;
                    return new GlyphLocation(i + 1, 0, 0);
                }
                if (glyphLocation == null) break block10;
                for (n2 = n; n2 < arrayList.size(); ++n2) {
                    List list;
                    LineText lineText = arrayList.get(n2);
                    double d4 = lineText.getBounds().y;
                    if ((double)float_.y < d4) {
                        if (!GlyphLocation.isLineTextIncluded(lineText, shape, shape2) || n2 != arrayList.size() - 1) continue;
                        list = lineText.getWords();
                        return new GlyphLocation(n2, list.size() - 1, ((WordText)list.get(list.size() - 1)).getGlyphs().size() - 1);
                    }
                    lineText = arrayList.get(n2);
                    list = lineText.getWords();
                    if (!GlyphLocation.isLineTextIncluded(lineText, shape, shape2)) continue;
                    return new GlyphLocation(n2, list.size() - 1, ((WordText)list.get(list.size() - 1)).getGlyphs().size() - 1);
                }
                break block10;
            }
            int n = 0;
            if (glyphLocation != null) {
                n = glyphLocation.line;
            }
            while (n > 0) {
                LineText lineText;
                double d5 = arrayList.get((int)n).getBounds().y;
                d = arrayList.get((int)(n - 1)).getBounds().y;
                if ((double)float_.y > d5 && (double)float_.y < d && GlyphLocation.isLineTextIncluded(lineText = arrayList.get(n - 1), shape, shape2)) {
                    return new GlyphLocation(n - 1, 0, 0);
                }
                --n;
            }
            if (glyphLocation != null) {
                for (int i = n; i >= 0; --i) {
                    LineText lineText = arrayList.get(i);
                    d = lineText.getBounds().y;
                    if (!((double)float_.y > d) || !GlyphLocation.isLineTextIncluded(lineText, shape, shape2)) continue;
                    return new GlyphLocation(i, 0, 0);
                }
            }
        }
        return null;
    }

    public static GlyphLocation findGlyphIntersection(ArrayList<LineText> arrayList, Point2D.Float float_, Shape shape, Shape shape2) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            LineText lineText = arrayList.get(i);
            if (!lineText.intersects(float_) || !GlyphLocation.isLineTextIncluded(lineText, shape, shape2)) continue;
            List list = arrayList.get(i).getWords();
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                WordText wordText = (WordText)list.get(j);
                if (!wordText.intersects(float_)) continue;
                ArrayList arrayList2 = wordText.getGlyphs();
                int n3 = arrayList2.size();
                for (int k = 0; k < n3; ++k) {
                    GlyphText glyphText = (GlyphText)arrayList2.get(k);
                    if (!glyphText.intersects(float_)) continue;
                    return new GlyphLocation(i, j, k);
                }
            }
        }
        return null;
    }

    public static GlyphLocation findFirstGlyphLocation(ArrayList<LineText> arrayList, Point2D.Float float_, boolean bl, boolean bl2, GlyphLocation glyphLocation, Shape shape, Shape shape2) {
        block4: {
            if (arrayList == null) break block4;
            if (bl) {
                int n = arrayList.size() - 1;
                for (int i = 0; i < n; ++i) {
                    LineText lineText = arrayList.get(i);
                    if (!GlyphLocation.isLineTextIncluded(lineText, shape, shape2)) continue;
                    return new GlyphLocation(i, 0, 0);
                }
            } else {
                for (int i = arrayList.size() - 1; i > 0; --i) {
                    LineText lineText = arrayList.get(i);
                    if (!GlyphLocation.isLineTextIncluded(lineText, shape, shape2)) continue;
                    List list = lineText.getWords();
                    return new GlyphLocation(i, list.size() - 1, ((WordText)list.get(list.size() - 1)).getGlyphs().size() - 1);
                }
            }
        }
        return null;
    }

    public static boolean findMouseContainedWithInLine(Point2D.Float float_, LineText lineText) {
        return lineText.getBounds().contains(float_);
    }

    public static int highLightGlyphs(ArrayList<LineText> arrayList, GlyphLocation glyphLocation, GlyphLocation glyphLocation2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Shape shape, Shape shape2) {
        if (arrayList == null) {
            return 0;
        }
        int n = GlyphLocation.fillFirstLine(arrayList.get(glyphLocation.line), glyphLocation, glyphLocation2, bl2, bl4, bl);
        n += GlyphLocation.fillMiddleLines(arrayList, glyphLocation, glyphLocation2, shape, shape2);
        return n += GlyphLocation.fillLastLine(arrayList.get(glyphLocation2.line), glyphLocation, glyphLocation2, bl2, bl4, bl);
    }

    public static int fillFirstLine(LineText lineText, GlyphLocation glyphLocation, GlyphLocation glyphLocation2, boolean bl, boolean bl2, boolean bl3) {
        lineText.setHasHighlight(true);
        List list = lineText.getWords();
        int n = 0;
        n += GlyphLocation.fillFirstWord(list, glyphLocation, glyphLocation2, bl2, bl);
        n += GlyphLocation.fillLastWord(list, glyphLocation, glyphLocation2, bl2, bl);
        if (glyphLocation.line == glyphLocation2.line) {
            if (bl2 && glyphLocation2.word > glyphLocation.word) {
                for (int i = glyphLocation.word + 1; i <= glyphLocation2.word - 1; ++i) {
                    ((WordText)list.get(i)).selectAll();
                    ++n;
                }
            } else {
                for (int i = glyphLocation.word - 1; i >= glyphLocation2.word + 1; --i) {
                    ((WordText)list.get(i)).selectAll();
                    ++n;
                }
            }
        } else if (bl2 && bl || !bl2 && bl) {
            for (int i = glyphLocation.word + 1; i < list.size(); ++i) {
                ((WordText)list.get(i)).selectAll();
                ++n;
            }
        } else {
            for (int i = glyphLocation.word - 1; i >= 0; --i) {
                ((WordText)list.get(i)).selectAll();
                ++n;
            }
        }
        return n;
    }

    public static int fillFirstWord(List<WordText> list, GlyphLocation glyphLocation, GlyphLocation glyphLocation2, boolean bl, boolean bl2) {
        int n = 0;
        if (glyphLocation2 != null && glyphLocation.line == glyphLocation2.line) {
            if (glyphLocation.word == glyphLocation2.word) {
                if (bl) {
                    WordText wordText = list.get(glyphLocation.word);
                    wordText.setHasSelected(true);
                    for (int i = glyphLocation.glyph; i <= glyphLocation2.glyph; ++i) {
                        ((GlyphText)wordText.getGlyphs().get(i)).setSelected(true);
                        ++n;
                    }
                } else {
                    WordText wordText = list.get(glyphLocation.word);
                    wordText.setHasSelected(true);
                    for (int i = glyphLocation.glyph; i >= glyphLocation2.glyph; --i) {
                        ((GlyphText)wordText.getGlyphs().get(i)).setSelected(true);
                        ++n;
                    }
                }
            } else if (bl && glyphLocation2.word > glyphLocation.word) {
                WordText wordText = list.get(glyphLocation.word);
                wordText.setHasSelected(true);
                for (int i = glyphLocation.glyph; i < wordText.getGlyphs().size(); ++i) {
                    ((GlyphText)wordText.getGlyphs().get(i)).setSelected(true);
                    ++n;
                }
            } else {
                WordText wordText = list.get(glyphLocation.word);
                wordText.setHasSelected(true);
                for (int i = glyphLocation.glyph; i >= 0; --i) {
                    ((GlyphText)wordText.getGlyphs().get(i)).setSelected(true);
                    ++n;
                }
            }
        } else if (bl && bl2 || !bl && bl2) {
            WordText wordText = list.get(glyphLocation.word);
            wordText.setHasSelected(true);
            for (int i = glyphLocation.glyph; i < wordText.getGlyphs().size(); ++i) {
                ((GlyphText)wordText.getGlyphs().get(i)).setSelected(true);
                ++n;
            }
        } else {
            WordText wordText = list.get(glyphLocation.word);
            wordText.setHasSelected(true);
            for (int i = glyphLocation.glyph; i >= 0; --i) {
                ((GlyphText)wordText.getGlyphs().get(i)).setSelected(true);
            }
        }
        return n;
    }

    public static int fillLastWord(List<WordText> list, GlyphLocation glyphLocation, GlyphLocation glyphLocation2, boolean bl, boolean bl2) {
        int n;
        block7: {
            block6: {
                n = 0;
                if (!bl || glyphLocation2.word <= glyphLocation.word) break block6;
                if (glyphLocation.line != glyphLocation2.line) break block7;
                WordText wordText = list.get(glyphLocation2.word);
                wordText.setHasSelected(true);
                for (int i = 0; i <= glyphLocation2.glyph; ++i) {
                    ((GlyphText)wordText.getGlyphs().get(i)).setSelected(true);
                    ++n;
                }
                break block7;
            }
            if (glyphLocation.word == glyphLocation2.word && glyphLocation.line == glyphLocation2.line) {
                WordText wordText = list.get(glyphLocation2.word);
                wordText.setHasSelected(true);
                for (int i = glyphLocation.glyph; i >= glyphLocation2.glyph; --i) {
                    ((GlyphText)wordText.getGlyphs().get(i)).setSelected(true);
                    ++n;
                }
            } else if (glyphLocation.line == glyphLocation2.line) {
                WordText wordText = list.get(glyphLocation2.word);
                wordText.setHasSelected(true);
                for (int i = wordText.getGlyphs().size() - 1; i >= glyphLocation2.glyph; --i) {
                    ((GlyphText)wordText.getGlyphs().get(i)).setSelected(true);
                    ++n;
                }
            }
        }
        return n;
    }

    public static int fillLastLine(LineText lineText, GlyphLocation glyphLocation, GlyphLocation glyphLocation2, boolean bl, boolean bl2, boolean bl3) {
        int n;
        block5: {
            List list = lineText.getWords();
            n = 0;
            if (glyphLocation.line == glyphLocation2.line) break block5;
            lineText.setHasHighlight(true);
            if (bl) {
                int n2;
                WordText wordText = (WordText)list.get(glyphLocation2.word);
                wordText.setHasSelected(true);
                for (n2 = 0; n2 <= glyphLocation2.glyph; ++n2) {
                    ((GlyphText)wordText.getGlyphs().get(n2)).setSelected(true);
                    ++n;
                }
                for (n2 = 0; n2 < glyphLocation2.word; ++n2) {
                    ((WordText)list.get(n2)).selectAll();
                    ++n;
                }
            } else {
                n += GlyphLocation.fillFirstWord(list, glyphLocation2, null, bl2, true);
                for (int i = glyphLocation2.word + 1; i < list.size(); ++i) {
                    ((WordText)list.get(i)).selectAll();
                    ++n;
                }
            }
        }
        return n;
    }

    public static int fillMiddleLines(ArrayList<LineText> arrayList, GlyphLocation glyphLocation, GlyphLocation glyphLocation2, Shape shape, Shape shape2) {
        GlyphLocation glyphLocation3 = new GlyphLocation(glyphLocation);
        GlyphLocation glyphLocation4 = new GlyphLocation(glyphLocation2);
        if (glyphLocation3.line > glyphLocation4.line) {
            GlyphLocation glyphLocation5 = glyphLocation3;
            glyphLocation3 = glyphLocation2;
            glyphLocation4 = glyphLocation5;
        }
        int n = 0;
        for (int i = glyphLocation3.line + 1; i < glyphLocation4.line; ++i) {
            if (!GlyphLocation.isLineTextIncluded(arrayList.get(i), shape, shape2)) continue;
            arrayList.get(i).selectAll();
            ++n;
        }
        return n;
    }
}

