/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.properties.CustomPropertiesPanel;
import org.icepdf.ri.common.properties.FontPanel;
import org.icepdf.ri.common.properties.InformationPanel;
import org.icepdf.ri.common.properties.PermissionsPanel;

public class PropertiesDialog
extends EscapeJDialog {
    private final GridBagConstraints constraints;
    private final JButton okButton;

    public PropertiesDialog(Frame frame, SwingController swingController, ResourceBundle resourceBundle) {
        super(frame, true);
        Document document = swingController.getDocument();
        this.setTitle(resourceBundle.getString("viewer.dialog.documentProperties.tab.title"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setAlignmentY(0.0f);
        InformationPanel informationPanel = new InformationPanel(document, resourceBundle);
        jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.documentProperties.tab.description"), informationPanel);
        jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.documentProperties.tab.security"), new PermissionsPanel(document, resourceBundle));
        FontPanel fontPanel = new FontPanel(swingController);
        this.addWindowListener(fontPanel);
        jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.documentProperties.tab.fonts"), fontPanel);
        CustomPropertiesPanel customPropertiesPanel = new CustomPropertiesPanel(document, resourceBundle, this);
        jTabbedPane.addTab(resourceBundle.getString("viewer.dialog.documentProperties.tab.custom"), customPropertiesPanel);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.anchor = 11;
        this.addGB(jPanel, jTabbedPane, 0, 0, 10, 1);
        for (int i = 0; i < 8; ++i) {
            this.addGB(jPanel, new JLabel(), i, 1, 1, 1);
        }
        JButton jButton = new JButton(resourceBundle.getString("viewer.button.cancel.label"));
        jButton.setMnemonic(resourceBundle.getString("viewer.button.cancel.mnemonic").charAt(0));
        jButton.addActionListener(actionEvent -> {
            this.setVisible(false);
            this.dispose();
        });
        this.okButton = new JButton(resourceBundle.getString("viewer.button.ok.label"));
        this.okButton.setMnemonic(resourceBundle.getString("viewer.button.ok.mnemonic").charAt(0));
        this.okButton.addActionListener(actionEvent -> {
            if (actionEvent.getSource() == this.okButton) {
                Map<String, String> map = informationPanel.getProperties();
                map.putAll(customPropertiesPanel.getProperties());
                if (document.getInfo().update(map)) {
                    document.getStateManager().addChange(new PObject((Object)document.getInfo().getEntries(), document.getInfo().getPObjectReference()));
                }
                this.setVisible(false);
                this.dispose();
            }
        });
        this.addGB(jPanel, this.okButton, 8, 1, 1, 1);
        this.addGB(jPanel, jButton, 9, 1, 1, 1);
        this.setLayout(new BorderLayout(15, 15));
        this.add((Component)jPanel, "North");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    void setOkEnabled(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

