/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.print;

import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.regex.Pattern;
import javax.print.CancelablePrintJob;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.print.PrintJobWatcher;

public abstract class PrintHelper
implements Printable {
    public static final PrintService[] EMPTY_PRINTSERVICE_ARRAY = new PrintService[0];
    private static final Pattern END_NEWLINE_PATTERN = Pattern.compile("[\r\n]+$");
    private static final Pattern CARET_COLON_PATTERN = Pattern.compile("[^:]*?[:]");
    public static final String PRINTER_NAME_ATTRIBUTE = "printer-name";
    private static final String PRINTER_STATUS_COMMAND = "lpstat -d";
    protected static final boolean CLIPPING_FIX_ENABLED = Defs.sysPropertyBoolean((String)"org.icepdf.ri.common.printHelper.clippingFix", (boolean)false);
    private static final float DPI = 72.0f;
    private static FutureTask<PrintService[]> SERVICES_TASK;
    private PrintService printService;
    private DocAttributeSet docAttributeSet;
    private PrintRequestAttributeSet printRequestAttributeSet;
    private boolean printFitToMargin;
    private int currentPage;
    private int numberOfPages;
    private boolean paintAnnotation = true;
    private boolean paintSearchHighlight = true;

    protected PrintHelper(DocAttributeSet docAttributeSet, PrintRequestAttributeSet printRequestAttributeSet) {
        this.docAttributeSet = docAttributeSet;
        this.printRequestAttributeSet = printRequestAttributeSet;
    }

    protected PrintHelper(PrintQuality printQuality, MediaSizeName mediaSizeName) {
        this(PrintHelper.createDocAttributeSet(mediaSizeName), PrintHelper.createPrintRequestAttributeSet(printQuality, mediaSizeName));
    }

    public static synchronized void preloadServices() {
        if (SERVICES_TASK == null || SERVICES_TASK.isCancelled() || !SERVICES_TASK.isDone()) {
            PrintHelper.reloadServices();
        }
    }

    public static synchronized void reloadServices() {
        if (SERVICES_TASK != null) {
            SERVICES_TASK.cancel(true);
        }
        SERVICES_TASK = new FutureTask<PrintService[]>(PrintHelper::lookForPrintServices);
        new Thread(SERVICES_TASK).start();
    }

    protected static DocAttributeSet createDocAttributeSet(MediaSizeName mediaSizeName) {
        HashDocAttributeSet hashDocAttributeSet = new HashDocAttributeSet();
        hashDocAttributeSet.add(mediaSizeName);
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        float[] fArray = mediaSize.getSize(25400);
        hashDocAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, fArray[0], fArray[1], 25400));
        return hashDocAttributeSet;
    }

    protected static PrintRequestAttributeSet createPrintRequestAttributeSet(PrintQuality printQuality, MediaSizeName mediaSizeName) {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(printQuality);
        hashPrintRequestAttributeSet.add(mediaSizeName);
        MediaSize mediaSize = MediaSize.getMediaSizeForName(mediaSizeName);
        float[] fArray = mediaSize.getSize(25400);
        hashPrintRequestAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, fArray[0], fArray[1], 25400));
        return hashPrintRequestAttributeSet;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    protected void setNumberOfPages(int n) {
        this.numberOfPages = n;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    protected void setCurrentPage(int n) {
        this.currentPage = n;
    }

    public boolean isPrintFitToMargin() {
        return this.printFitToMargin;
    }

    protected void setPrintFitToMargin(boolean bl) {
        this.printFitToMargin = bl;
    }

    public boolean isPaintAnnotation() {
        return this.paintAnnotation;
    }

    public void setPaintAnnotation(boolean bl) {
        this.paintAnnotation = bl;
    }

    public boolean isPaintSearchHighlight() {
        return this.paintSearchHighlight;
    }

    public void setPaintSearchHighlight(boolean bl) {
        this.paintSearchHighlight = bl;
    }

    public abstract void showPrintSetupDialog();

    public void setupPrintService(PrintService printService, int n, int n2, int n3, boolean bl) {
        this.printFitToMargin = bl;
        this.printRequestAttributeSet.add(new PageRanges(n + 1, n2 + 1));
        this.printRequestAttributeSet.add(new Copies(n3));
        this.printService = printService;
    }

    public boolean setupPrintService(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.setPrintFitToMargin(bl);
        this.getPrintRequestAttributeSet().add(new PageRanges(n + 1, n2 + 1));
        this.getPrintRequestAttributeSet().add(new Copies(n3));
        if (bl2) {
            this.setPrintService(this.getSetupDialog());
            return this.getPrintService() != null;
        }
        return true;
    }

    public void setupPrintService(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, boolean bl) {
        this.setPrintFitToMargin(bl);
        this.setPrintService(printService);
        this.setPrintRequestAttributeSet(printRequestAttributeSet);
    }

    public abstract CancelablePrintJob cancelablePrint() throws PrintException;

    public abstract void print(PrintJobWatcher var1) throws PrintException;

    @Override
    public abstract int print(Graphics var1, PageFormat var2, int var3) throws PrinterException;

    public abstract void print() throws PrintException;

    public static PrintService[] getServices() {
        try {
            return SERVICES_TASK.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            return EMPTY_PRINTSERVICE_ARRAY;
        }
    }

    public DocAttributeSet getDocAttributeSet() {
        return this.docAttributeSet;
    }

    protected void setDocAttributeSet(DocAttributeSet docAttributeSet) {
        this.docAttributeSet = docAttributeSet;
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.printRequestAttributeSet;
    }

    protected void setPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        this.printRequestAttributeSet = printRequestAttributeSet;
    }

    public PrintService getPrintServiceOrDefault() {
        if (this.printService == null) {
            this.printService = PrintHelper.getServices().length > 0 ? PrintHelper.getServices()[0] : null;
        }
        return this.printService;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    protected void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public static MediaSizeName guessMediaSizeName(Document document) {
        PageTree pageTree;
        if (document != null && (pageTree = document.getPageTree()).getNumberOfPages() > 0) {
            Rectangle2D.Float float_ = pageTree.getPage(0).getMediaBox();
            float f = float_.width / 72.0f;
            float f2 = float_.height / 72.0f;
            return MediaSize.findMedia(f, f2, 25400);
        }
        return MediaSizeName.ISO_A4;
    }

    public static boolean hasPrinter(String string) {
        return string.equals("default") || Arrays.stream(PrintHelper.getServices()).map(PrintService::getName).anyMatch(string2 -> string2.equals(string));
    }

    public void setPrinter(String string) {
        Arrays.stream(PrintHelper.getServices()).filter(printService -> printService.getName().equals(string)).findAny().ifPresent(printService -> {
            this.printService = printService;
        });
    }

    protected static PrintService[] lookForPrintServices() {
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        List<Object> list = new ArrayList();
        PrintService printService = PrintHelper.lookupDefaultPrintService();
        if (printService != null && printServiceArray.length > 0) {
            for (PrintService printService2 : printServiceArray) {
                if (printService2.equals(printService)) {
                    list.add(0, printService2);
                    continue;
                }
                list.add(printService2);
            }
        } else {
            list = Arrays.asList(printServiceArray);
        }
        return list.toArray(EMPTY_PRINTSERVICE_ARRAY);
    }

    private static PrintService lookupDefaultPrintService() {
        PrintService printService = null;
        String string = PrintHelper.getUserPrinterProperty();
        if (!string.isEmpty()) {
            PrintService[] printServiceArray;
            block0: for (PrintService printService2 : printServiceArray = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)) {
                PrintServiceAttributeSet printServiceAttributeSet = printService2.getAttributes();
                for (Attribute attribute : printServiceAttributeSet.toArray()) {
                    String string2 = attribute.getName();
                    String string3 = printServiceAttributeSet.get(attribute.getClass()).toString();
                    if (!PRINTER_NAME_ATTRIBUTE.equals(string2) || !string3.equalsIgnoreCase(string)) continue;
                    printService = printService2;
                    continue block0;
                }
            }
            return printService;
        }
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    private static String getUserPrinterProperty() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Process process = Runtime.getRuntime().exec(PRINTER_STATUS_COMMAND);
            try (InputStream inputStream = process.getInputStream();){
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringBuilder.append((char)n);
                }
            }
            stringBuilder = new StringBuilder(END_NEWLINE_PATTERN.matcher(stringBuilder.toString()).replaceAll(""));
            stringBuilder = new StringBuilder(CARET_COLON_PATTERN.matcher(stringBuilder.toString()).replaceAll("").trim());
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        stringBuilder = new StringBuilder(END_NEWLINE_PATTERN.matcher(stringBuilder.toString()).replaceAll(""));
        stringBuilder = new StringBuilder(CARET_COLON_PATTERN.matcher(stringBuilder.toString()).replaceAll("").trim());
        return stringBuilder.toString();
    }

    protected abstract PrintService getSetupDialog();
}

