/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.graphics.images.references.ImageReferenceFactory;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class ImagingPreferencesPanel
extends JPanel {
    private final GridBagConstraints constraints;
    private final Preferences preferences;

    public ImagingPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        super(new GridBagLayout());
        this.setAlignmentY(0.0f);
        this.preferences = viewerPropertiesManager.getPreferences();
        ImageReferenceItem[] imageReferenceItemArray = new ImageReferenceItem[]{new ImageReferenceItem(resourceBundle.getString("viewer.dialog.viewerPreferences.section.imaging.imageReference.default.label"), ImageReferenceFactory.ImageReference.DEFAULT), new ImageReferenceItem(resourceBundle.getString("viewer.dialog.viewerPreferences.section.imaging.imageReference.scaled.label"), ImageReferenceFactory.ImageReference.SCALED), new ImageReferenceItem(resourceBundle.getString("viewer.dialog.viewerPreferences.section.imaging.imageReference.mipMap.label"), ImageReferenceFactory.ImageReference.MIP_MAP), new ImageReferenceItem(resourceBundle.getString("viewer.dialog.viewerPreferences.section.imaging.imageReference.smothScaled.label"), ImageReferenceFactory.ImageReference.SMOOTH_SCALED), new ImageReferenceItem(resourceBundle.getString("viewer.dialog.viewerPreferences.section.imaging.imageReference.blurred.label"), ImageReferenceFactory.ImageReference.BLURRED)};
        JComboBox<ImageReferenceItem> jComboBox = new JComboBox<ImageReferenceItem>(imageReferenceItemArray);
        jComboBox.setSelectedItem(new ImageReferenceItem("", ImageReferenceFactory.imageReferenceType));
        jComboBox.addActionListener(actionEvent -> {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            ImageReferenceItem imageReferenceItem = (ImageReferenceItem)jComboBox.getSelectedItem();
            ImageReferenceFactory.imageReferenceType = imageReferenceItem.getValue();
            this.preferences.put("org.icepdf.core.imageReference", imageReferenceItem.getValue().toString());
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.imaging.imageReference.border.label"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(jPanel, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.imaging.imageReference.label")), 0, 0, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel, jComboBox, 1, 0, 1, 1);
        this.constraints.anchor = 18;
        this.constraints.fill = 1;
        this.addGB(this, jPanel, 0, 0, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 1, 1, 1);
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    static class ImageReferenceItem {
        final String label;
        final ImageReferenceFactory.ImageReference value;

        public ImageReferenceItem(String string, ImageReferenceFactory.ImageReference imageReference) {
            this.label = string;
            this.value = imageReference;
        }

        public String getLabel() {
            return this.label;
        }

        public ImageReferenceFactory.ImageReference getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object object) {
            if (object instanceof ImageReferenceItem) {
                return this.value.equals((Object)((ImageReferenceItem)object).getValue());
            }
            if (object instanceof ImageReferenceFactory.ImageReference) {
                return this.value.equals(object);
            }
            return false;
        }
    }
}

