/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.Page;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.PageViewDecorator;
import org.icepdf.ri.common.widgets.ColorChooserButton;
import org.icepdf.ri.images.Images;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class GeneralPreferencesPanel
extends JPanel
implements PropertyChangeListener,
ItemListener {
    private GridBagConstraints constraints;
    private final Preferences preferences;
    private final ColorChooserButton highlightColorChooserButton;
    private final ColorChooserButton selectionColorChooserButton;
    private final ColorChooserButton paperShadowColorChooserButton;
    private final ColorChooserButton paperColorChooserButton;
    private final ColorChooserButton paperBorderColorChooserButton;
    private final ColorChooserButton viewBackgroundColorChooserButton;
    private final JComboBox<ValueLabelItem> iconSizeComboBox;

    public GeneralPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        super(new GridBagLayout());
        this.setAlignmentY(0.0f);
        this.preferences = viewerPropertiesManager.getPreferences();
        Color color = new Color(this.preferences.getInt("org.icepdf.core.views.page.text.highlight.color", Page.highlightColor.getRGB()));
        Color color2 = new Color(this.preferences.getInt("org.icepdf.core.views.page.text.selection.color", Page.selectionColor.getRGB()));
        this.highlightColorChooserButton = new ColorChooserButton(color);
        this.highlightColorChooserButton.addPropertyChangeListener("background", this);
        this.selectionColorChooserButton = new ColorChooserButton(color2);
        this.selectionColorChooserButton.addPropertyChangeListener("background", this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.selection.border.label"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(jPanel, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.textSelectionColor.label")), 0, 0, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel, this.selectionColorChooserButton, 1, 0, 1, 1);
        this.constraints.anchor = 17;
        this.addGB(jPanel, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.searchHighlightColor.label")), 0, 1, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel, this.highlightColorChooserButton, 1, 1, 1, 1);
        this.constraints.anchor = 11;
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(this, jPanel, 0, 0, 1, 1);
        Color color3 = new Color(this.preferences.getInt("org.icepdf.core.views.page.shadow.color", PageViewDecorator.pageShadowColor.getRGB()));
        Color color4 = new Color(this.preferences.getInt("org.icepdf.core.views.page.paper.color", PageViewDecorator.pageColor.getRGB()));
        Color color5 = new Color(this.preferences.getInt("org.icepdf.core.views.page.border.color", PageViewDecorator.pageBorderColor.getRGB()));
        Color color6 = new Color(this.preferences.getInt("org.icepdf.core.views.background.color", AbstractDocumentView.backgroundColour.getRGB()));
        this.paperShadowColorChooserButton = new ColorChooserButton(color3);
        this.paperShadowColorChooserButton.addPropertyChangeListener("background", this);
        this.paperColorChooserButton = new ColorChooserButton(color4);
        this.paperColorChooserButton.addPropertyChangeListener("background", this);
        this.paperBorderColorChooserButton = new ColorChooserButton(color5);
        this.paperBorderColorChooserButton.addPropertyChangeListener("background", this);
        this.viewBackgroundColorChooserButton = new ColorChooserButton(color6);
        this.viewBackgroundColorChooserButton.addPropertyChangeListener("background", this);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.pageView.border.label"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.anchor = 17;
        this.addGB(jPanel2, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.pageView.shadowColor.label")), 0, 0, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel2, this.paperShadowColorChooserButton, 1, 0, 1, 1);
        this.constraints.anchor = 17;
        this.addGB(jPanel2, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.pageView.paperColor.label")), 0, 1, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel2, this.paperColorChooserButton, 1, 1, 1, 1);
        this.constraints.anchor = 17;
        this.addGB(jPanel2, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.pageView.borderColor.label")), 0, 2, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel2, this.paperBorderColorChooserButton, 1, 2, 1, 1);
        this.constraints.anchor = 17;
        this.addGB(jPanel2, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.pageView.backgroundColor.label")), 0, 3, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel2, this.viewBackgroundColorChooserButton, 1, 3, 1, 1);
        this.constraints.anchor = 11;
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(this, jPanel2, 0, 1, 1, 1);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.iconSize.border.label"), 1, 0));
        ValueLabelItem[] valueLabelItemArray = new ValueLabelItem[]{new ValueLabelItem(Boolean.TRUE, resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.iconSize.small.label")), new ValueLabelItem(Boolean.FALSE, resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.iconSize.large.label"))};
        this.iconSizeComboBox = new JComboBox<ValueLabelItem>(valueLabelItemArray);
        this.iconSizeComboBox.setSelectedIndex(Images.getDefaultIconSizeOr(this.preferences, Images.IconSize.SMALL) == Images.IconSize.SMALL ? 0 : 1);
        this.iconSizeComboBox.addItemListener(this);
        this.constraints.anchor = 17;
        this.addGB(jPanel3, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.general.iconSize.label")), 0, 0, 1, 1);
        this.constraints.anchor = 13;
        this.constraints.fill = 0;
        this.addGB(jPanel3, this.iconSizeComboBox, 1, 0, 1, 1);
        this.constraints.anchor = 11;
        this.constraints.fill = 1;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(this, jPanel3, 0, 2, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 3, 1, 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.iconSizeComboBox) {
            this.preferences.put("application.icon.default.size", this.iconSizeComboBox.getSelectedIndex() == 0 ? Images.IconSize.SMALL.toString() : Images.IconSize.LARGE.toString());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object == this.highlightColorChooserButton) {
            Page.highlightColor = this.highlightColorChooserButton.getBackground();
            this.preferences.putInt("org.icepdf.core.views.page.text.highlight.color", Page.highlightColor.getRGB());
        } else if (object == this.selectionColorChooserButton) {
            Page.selectionColor = this.selectionColorChooserButton.getBackground();
            this.preferences.putInt("org.icepdf.core.views.page.text.selection.color", Page.selectionColor.getRGB());
        } else if (object == this.paperShadowColorChooserButton) {
            PageViewDecorator.pageShadowColor = this.paperShadowColorChooserButton.getBackground();
            this.preferences.putInt("org.icepdf.core.views.page.shadow.color", PageViewDecorator.pageShadowColor.getRGB());
        } else if (object == this.paperColorChooserButton) {
            PageViewDecorator.pageColor = this.paperColorChooserButton.getBackground();
            this.preferences.putInt("org.icepdf.core.views.page.paper.color", PageViewDecorator.pageColor.getRGB());
        } else if (object == this.paperBorderColorChooserButton) {
            PageViewDecorator.pageBorderColor = this.paperBorderColorChooserButton.getBackground();
            this.preferences.putInt("org.icepdf.core.views.background.color", PageViewDecorator.pageBorderColor.getRGB());
        } else if (object == this.viewBackgroundColorChooserButton) {
            AbstractDocumentView.backgroundColour = this.viewBackgroundColorChooserButton.getBackground();
            this.preferences.putInt("org.icepdf.core.views.background.color", AbstractDocumentView.backgroundColour.getRGB());
        }
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

