/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

class ToolbarLayout
implements LayoutManager {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    int align;
    int hgap;
    int vgap;

    public ToolbarLayout() {
        this(1, 5, 5);
    }

    public ToolbarLayout(int n) {
        this(n, 5, 5);
    }

    public ToolbarLayout(int n, int n2, int n3) {
        this.hgap = n2;
        this.vgap = n3;
        this.setAlignment(n);
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int n) {
        switch (n) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = n;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getMinimumSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                if (i > 0) {
                    dimension.width += this.hgap;
                }
                dimension.width += dimension2.width;
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right + 2 * this.hgap;
            dimension.height += insets.top + insets.bottom + 2 * this.vgap;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (container.getWidth() == 0) {
            return this.minimumLayoutSize(container);
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = 0;
            int n2 = container.getComponentCount();
            Insets insets = container.getInsets();
            int n3 = this.hgap * 2 + insets.left + insets.right;
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                if (dimension.width + dimension2.width + n3 <= container.getWidth()) {
                    dimension.height = Math.max(dimension.height, dimension2.height);
                } else {
                    dimension.height += this.vgap + dimension2.height;
                    dimension.width = 0;
                }
                if (dimension.width > 0) {
                    dimension.width += this.hgap;
                }
                dimension.width += dimension2.width;
                if (dimension.width <= n) continue;
                n = dimension.width;
            }
            dimension.width = Math.max(dimension.width, n);
            dimension.width += insets.left + insets.right + 2 * this.hgap;
            dimension.height += insets.top + insets.bottom + 2 * this.vgap;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getWidth() - (insets.left + insets.right + this.hgap * 2);
            int n2 = container.getComponentCount();
            int n3 = 0;
            int n4 = insets.top + this.vgap;
            int n5 = 0;
            int n6 = 0;
            boolean bl = container.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                component.setSize(dimension.width, dimension.height);
                if (n3 == 0 || n3 + dimension.width <= n) {
                    if (n3 > 0) {
                        n3 += this.hgap;
                    }
                    n3 += dimension.width;
                    n5 = Math.max(n5, dimension.height);
                    continue;
                }
                n5 = this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, i, bl);
                n3 = dimension.width;
                n4 += this.vgap + n5;
                n5 = dimension.height;
                n6 = i;
            }
            this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n2, bl);
        }
    }

    private int moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        switch (this.align) {
            case 0: {
                n += bl ? 0 : n3;
                break;
            }
            case 1: {
                n += n3 / 2;
                break;
            }
            case 2: {
                n += bl ? n3 : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                n += n3;
            }
        }
        for (int i = n5; i < n6; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            int n7 = n2 + (n4 - component.getHeight()) / 2;
            if (bl) {
                component.setLocation(n, n7);
            } else {
                component.setLocation(container.getWidth() - n - component.getWidth(), n7);
            }
            n += component.getWidth() + this.hgap;
        }
        return n4;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

